/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.json.Json;

@Singleton
@Path(value="")
public class StudioResource {
    private static final QualifiedType<ObjectNode> ENTITY = QualifiedType.of(ObjectNode.class).with(new Class[]{Json.class});
    private final Jdbi jdbi;

    @Inject
    public StudioResource(Jdbi jdbi) {
        this.jdbi = jdbi;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="studio/{kind}")
    public Response getEntities(@PathParam(value="kind") String kind) {
        List entityList = (List)this.jdbi.withHandle(handle -> ((Query)handle.createQuery("select entity from studio.entities where kind = :kind").bind("kind", kind)).mapTo(ENTITY).list());
        return Response.ok((Object)entityList).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="studio/{kind}")
    public Response addEntity(ObjectNode entity, @PathParam(value="kind") String kind) {
        UUID id;
        try {
            id = UUID.fromString(entity.get("id").asText());
        }
        catch (Exception e) {
            id = UUID.randomUUID();
            entity.put("id", id.toString());
        }
        UUID finalId = id;
        this.jdbi.useHandle(handle -> ((Update)((Update)((Update)handle.createUpdate("insert into studio.entities (id, entity, kind) values (:id, CAST(:entity AS jsonb), :kind)").bind("id", finalId)).bindByType("entity", (Object)entity, ENTITY)).bind("kind", kind)).execute());
        return Response.created((URI)URI.create("studio/" + kind + "/" + id)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="studio/{kind}/{id}")
    public Response getEntity(@PathParam(value="id") UUID id, @PathParam(value="kind") String kind) {
        ObjectNode entity = (ObjectNode)this.jdbi.withHandle(handle -> (ObjectNode)((Query)((Query)handle.createQuery("select entity from studio.entities where id = :id and kind = :kind").bind("id", id)).bind("kind", kind)).mapTo(ENTITY).one());
        return Response.ok((Object)entity).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="studio/{kind}/{id}")
    public Response updateEntity(ObjectNode entity, @PathParam(value="id") UUID id, @PathParam(value="kind") String kind) {
        this.jdbi.useHandle(handle -> ((Update)((Update)((Update)handle.createUpdate("update studio.entities set map = CAST(:entity AS jsonb) where id = :id and kind = :kind").bind("id", id)).bindByType("entity", (Object)entity, ENTITY)).bind("kind", kind)).execute());
        return Response.noContent().build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="studio/{kind}/{id}")
    public Response deleteEntity(@PathParam(value="id") UUID id, @PathParam(value="kind") String kind) {
        this.jdbi.useHandle(handle -> handle.execute("delete from studio.entities where id = (?) and kind = (?)", new Object[]{id, kind}));
        return Response.noContent().build();
    }
}

