/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.TaskBasedAsyncPublisherOperator;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.context.api.ContextMap;
import java.util.function.BooleanSupplier;

final class PublishAndSubscribeOnPublishers {
    private PublishAndSubscribeOnPublishers() {
    }

    static <T> void deliverOnSubscribeAndOnError(PublisherSource.Subscriber<? super T> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider, Throwable cause) {
        SubscriberUtils.deliverErrorFromSource(contextProvider.wrapPublisherSubscriber(subscriber, contextMap), (Throwable)cause);
    }

    private static <T> void safeHandleSubscribe(HandleSubscribe handler, PublisherSource.Subscriber<? super T> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
        try {
            handler.handleSubscribe(subscriber, contextMap, contextProvider);
        }
        catch (Throwable throwable) {
            SubscriberUtils.safeOnError(subscriber, (Throwable)throwable);
        }
    }

    static <T> Publisher<T> publishOn(Publisher<T> original, BooleanSupplier shouldOffload, Executor executor) {
        return Executors.immediate() == executor ? original : new PublishOn(original, shouldOffload, executor);
    }

    static <T> Publisher<T> subscribeOn(Publisher<T> original, BooleanSupplier shouldOffload, Executor executor) {
        return Executors.immediate() == executor ? original : new SubscribeOn(original, shouldOffload, executor);
    }

    private static final class SubscribeOn<T>
    extends TaskBasedAsyncPublisherOperator<T> {
        SubscribeOn(Publisher<T> original, BooleanSupplier shouldOffload, Executor executor) {
            super(original, shouldOffload, executor);
        }

        @Override
        public void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
            TaskBasedAsyncPublisherOperator.OffloadedSubscriptionSubscriber<? super T> upstreamSubscriber;
            try {
                BooleanSupplier shouldOffload = this.shouldOffload();
                upstreamSubscriber = new TaskBasedAsyncPublisherOperator.OffloadedSubscriptionSubscriber<T>(subscriber, shouldOffload, this.executor());
                if (shouldOffload.getAsBoolean()) {
                    this.executor().execute(() -> PublishAndSubscribeOnPublishers.safeHandleSubscribe((x$0, x$1, x$2) -> super.handleSubscribe(x$0, x$1, x$2), upstreamSubscriber, contextMap, contextProvider));
                    return;
                }
            }
            catch (Throwable throwable) {
                SubscriberUtils.deliverErrorFromSource(subscriber, (Throwable)throwable);
                return;
            }
            PublishAndSubscribeOnPublishers.safeHandleSubscribe((x$0, x$1, x$2) -> super.handleSubscribe(x$0, x$1, x$2), upstreamSubscriber, contextMap, contextProvider);
        }
    }

    private static final class PublishOn<T>
    extends TaskBasedAsyncPublisherOperator<T> {
        PublishOn(Publisher<T> original, BooleanSupplier shouldOffload, Executor executor) {
            super(original, shouldOffload, executor);
        }

        @Override
        void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
            TaskBasedAsyncPublisherOperator.OffloadedSubscriber<? super T> upstreamSubscriber;
            try {
                BooleanSupplier shouldOffload = this.shouldOffload();
                upstreamSubscriber = new TaskBasedAsyncPublisherOperator.OffloadedSubscriber<T>(subscriber, shouldOffload, this.executor());
            }
            catch (Throwable throwable) {
                SubscriberUtils.deliverErrorFromSource(subscriber, (Throwable)throwable);
                return;
            }
            PublishAndSubscribeOnPublishers.safeHandleSubscribe((x$0, x$1, x$2) -> super.handleSubscribe(x$0, x$1, x$2), upstreamSubscriber, contextMap, contextProvider);
        }
    }

    @FunctionalInterface
    private static interface HandleSubscribe<T> {
        public void handleSubscribe(PublisherSource.Subscriber<? super T> var1, ContextMap var2, AsyncContextProvider var3);
    }
}

