/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark.util;

import org.apache.amoro.spark.util.ExpressionHelper;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.transforms.SortOrderVisitor;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Expressions;

public class SortOrderToSpark
implements SortOrderVisitor<Expression> {
    final ExpressionHelper expressionHelper;

    public SortOrderToSpark(ExpressionHelper expressionHelper) {
        this.expressionHelper = expressionHelper;
    }

    public Expression field(String sourceName, int sourceId, SortDirection direction, NullOrder nullOrder) {
        return this.expressionHelper.sort((Expression)Expressions.column((String)sourceName), this.ascending(direction));
    }

    public Expression bucket(String sourceName, int sourceId, int width, SortDirection direction, NullOrder nullOrder) {
        return this.expressionHelper.sort((Expression)Expressions.bucket((int)width, (String[])new String[]{sourceName}), this.ascending(direction));
    }

    public Expression truncate(String sourceName, int sourceId, int width, SortDirection direction, NullOrder nullOrder) {
        return this.expressionHelper.sort((Expression)this.expressionHelper.truncate(sourceName, width), this.ascending(direction));
    }

    public Expression year(String sourceName, int sourceId, SortDirection direction, NullOrder nullOrder) {
        return this.expressionHelper.sort((Expression)Expressions.years((String)sourceName), this.ascending(direction));
    }

    public Expression month(String sourceName, int sourceId, SortDirection direction, NullOrder nullOrder) {
        return this.expressionHelper.sort((Expression)Expressions.months((String)sourceName), this.ascending(direction));
    }

    public Expression day(String sourceName, int sourceId, SortDirection direction, NullOrder nullOrder) {
        return this.expressionHelper.sort((Expression)Expressions.days((String)sourceName), this.ascending(direction));
    }

    public Expression hour(String sourceName, int sourceId, SortDirection direction, NullOrder nullOrder) {
        return this.expressionHelper.sort((Expression)Expressions.hours((String)sourceName), this.ascending(direction));
    }

    private boolean ascending(SortDirection direction) {
        return direction == SortDirection.ASC;
    }
}

