/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.Tristate;
import org.slf4j.Logger;

public class Listing {
    private final S3AFileSystem owner;
    private static final Logger LOG = S3AFileSystem.LOG;
    static final PathFilter ACCEPT_ALL = new PathFilter(){

        public boolean accept(Path file) {
            return true;
        }

        public String toString() {
            return "ACCEPT_ALL";
        }
    };

    public Listing(S3AFileSystem owner) {
        this.owner = owner;
    }

    ProvidedFileStatusIterator createProvidedFileStatusIterator(FileStatus[] fileStatuses, PathFilter filter, FileStatusAcceptor acceptor) {
        return new ProvidedFileStatusIterator(fileStatuses, filter, acceptor);
    }

    FileStatusListingIterator createFileStatusListingIterator(Path listPath, ListObjectsRequest request, PathFilter filter, FileStatusAcceptor acceptor) throws IOException {
        return this.createFileStatusListingIterator(listPath, request, filter, acceptor, null);
    }

    FileStatusListingIterator createFileStatusListingIterator(Path listPath, ListObjectsRequest request, PathFilter filter, FileStatusAcceptor acceptor, RemoteIterator<FileStatus> providedStatus) throws IOException {
        return new FileStatusListingIterator(new ObjectListingIterator(listPath, request), filter, acceptor, providedStatus);
    }

    @VisibleForTesting
    LocatedFileStatusIterator createLocatedFileStatusIterator(RemoteIterator<FileStatus> statusIterator) {
        return new LocatedFileStatusIterator(statusIterator);
    }

    @VisibleForTesting
    TombstoneReconcilingIterator createTombstoneReconcilingIterator(RemoteIterator<LocatedFileStatus> iterator, Set<Path> tombstones) {
        return new TombstoneReconcilingIterator(iterator, tombstones);
    }

    static class AcceptAllButSelfAndS3nDirs
    implements FileStatusAcceptor {
        private final Path qualifiedPath;

        public AcceptAllButSelfAndS3nDirs(Path qualifiedPath) {
            this.qualifiedPath = qualifiedPath;
        }

        @Override
        public boolean accept(Path keyPath, S3ObjectSummary summary) {
            return !keyPath.equals((Object)this.qualifiedPath) && !summary.getKey().endsWith("_$folder$");
        }

        @Override
        public boolean accept(Path keyPath, String prefix) {
            return !keyPath.equals((Object)this.qualifiedPath);
        }

        @Override
        public boolean accept(FileStatus status) {
            return status != null && !status.getPath().equals((Object)this.qualifiedPath);
        }
    }

    static class AcceptAllButS3nDirs
    implements FileStatusAcceptor {
        AcceptAllButS3nDirs() {
        }

        @Override
        public boolean accept(Path keyPath, S3ObjectSummary summary) {
            return !summary.getKey().endsWith("_$folder$");
        }

        @Override
        public boolean accept(Path keyPath, String prefix) {
            return !keyPath.toString().endsWith("_$folder$");
        }

        @Override
        public boolean accept(FileStatus status) {
            return !status.getPath().toString().endsWith("_$folder$");
        }
    }

    static class TombstoneReconcilingIterator
    implements RemoteIterator<LocatedFileStatus> {
        private LocatedFileStatus next = null;
        private final RemoteIterator<LocatedFileStatus> iterator;
        private final Set<Path> tombstones;

        TombstoneReconcilingIterator(RemoteIterator<LocatedFileStatus> iterator, Set<Path> tombstones) {
            this.iterator = iterator;
            this.tombstones = tombstones != null ? tombstones : Collections.EMPTY_SET;
        }

        private boolean fetch() throws IOException {
            while (this.next == null && this.iterator.hasNext()) {
                LocatedFileStatus candidate = (LocatedFileStatus)this.iterator.next();
                if (this.tombstones.contains(candidate.getPath())) continue;
                this.next = candidate;
                return true;
            }
            return false;
        }

        public boolean hasNext() throws IOException {
            if (this.next != null) {
                return true;
            }
            return this.fetch();
        }

        public LocatedFileStatus next() throws IOException {
            if (this.hasNext()) {
                LocatedFileStatus result = this.next;
                this.next = null;
                this.fetch();
                return result;
            }
            throw new NoSuchElementException();
        }
    }

    class LocatedFileStatusIterator
    implements RemoteIterator<LocatedFileStatus> {
        private final RemoteIterator<FileStatus> statusIterator;

        LocatedFileStatusIterator(RemoteIterator<FileStatus> statusIterator) {
            this.statusIterator = statusIterator;
        }

        public boolean hasNext() throws IOException {
            return this.statusIterator.hasNext();
        }

        public LocatedFileStatus next() throws IOException {
            return Listing.this.owner.toLocatedFileStatus((FileStatus)this.statusIterator.next());
        }
    }

    static class AcceptFilesOnly
    implements FileStatusAcceptor {
        private final Path qualifiedPath;

        public AcceptFilesOnly(Path qualifiedPath) {
            this.qualifiedPath = qualifiedPath;
        }

        @Override
        public boolean accept(Path keyPath, S3ObjectSummary summary) {
            return !keyPath.equals((Object)this.qualifiedPath) && !summary.getKey().endsWith("_$folder$") && !S3AUtils.objectRepresentsDirectory(summary.getKey(), summary.getSize());
        }

        @Override
        public boolean accept(Path keyPath, String prefix) {
            return false;
        }

        @Override
        public boolean accept(FileStatus status) {
            return status != null && status.isFile();
        }
    }

    class ObjectListingIterator
    implements RemoteIterator<ObjectListing> {
        private final Path listPath;
        private ObjectListing objects;
        private boolean firstListing = true;
        private int listingCount = 1;
        private int maxKeys;

        ObjectListingIterator(Path listPath, ListObjectsRequest request) {
            this.listPath = listPath;
            this.maxKeys = Listing.this.owner.getMaxKeys();
            this.objects = Listing.this.owner.listObjects(request);
        }

        public boolean hasNext() throws IOException {
            return this.firstListing || this.objects.isTruncated();
        }

        public ObjectListing next() throws IOException {
            if (this.firstListing) {
                this.firstListing = false;
            } else {
                try {
                    if (!this.objects.isTruncated()) {
                        throw new NoSuchElementException("No more results in listing of " + this.listPath);
                    }
                    LOG.debug("[{}], Requesting next {} objects under {}", new Object[]{this.listingCount, this.maxKeys, this.listPath});
                    this.objects = Listing.this.owner.continueListObjects(this.objects);
                    ++this.listingCount;
                    LOG.debug("New listing status: {}", (Object)this);
                }
                catch (AmazonClientException e) {
                    throw S3AUtils.translateException("listObjects()", this.listPath, e);
                }
            }
            return this.objects;
        }

        public String toString() {
            return "Object listing iterator against " + this.listPath + "; listing count " + this.listingCount + "; isTruncated=" + this.objects.isTruncated();
        }

        public Path getListPath() {
            return this.listPath;
        }

        public int getListingCount() {
            return this.listingCount;
        }
    }

    class FileStatusListingIterator
    implements RemoteIterator<FileStatus> {
        private final ObjectListingIterator source;
        private final PathFilter filter;
        private final FileStatusAcceptor acceptor;
        private int batchSize;
        private ListIterator<FileStatus> statusBatchIterator;
        private final Set<FileStatus> providedStatus;
        private Iterator<FileStatus> providedStatusIterator;

        FileStatusListingIterator(ObjectListingIterator source, PathFilter filter, FileStatusAcceptor acceptor, RemoteIterator<FileStatus> providedStatus) throws IOException {
            this.source = source;
            this.filter = filter;
            this.acceptor = acceptor;
            this.providedStatus = new HashSet<FileStatus>();
            while (providedStatus != null && providedStatus.hasNext()) {
                FileStatus status = (FileStatus)providedStatus.next();
                if (!filter.accept(status.getPath()) || !acceptor.accept(status)) continue;
                this.providedStatus.add(status);
            }
            this.requestNextBatch();
        }

        public boolean hasNext() throws IOException {
            return this.sourceHasNext() || this.providedStatusIterator.hasNext();
        }

        private boolean sourceHasNext() throws IOException {
            if (this.statusBatchIterator.hasNext() || this.requestNextBatch()) {
                return true;
            }
            if (this.providedStatusIterator == null) {
                LOG.debug("Start iterating the provided status.");
                this.providedStatusIterator = this.providedStatus.iterator();
            }
            return false;
        }

        public FileStatus next() throws IOException {
            FileStatus status;
            if (this.sourceHasNext()) {
                status = this.statusBatchIterator.next();
                LOG.debug("Removing the status from provided file status {}", (Object)status);
                this.providedStatus.remove(status);
            } else if (this.providedStatusIterator.hasNext()) {
                status = this.providedStatusIterator.next();
                LOG.debug("Returning provided file status {}", (Object)status);
            } else {
                throw new NoSuchElementException();
            }
            return status;
        }

        private boolean requestNextBatch() throws IOException {
            while (this.source.hasNext()) {
                if (this.buildNextStatusBatch(this.source.next())) {
                    return true;
                }
                LOG.debug("All entries in batch were filtered...continuing");
            }
            return false;
        }

        private boolean buildNextStatusBatch(ObjectListing objects) {
            int added = 0;
            int ignored = 0;
            ArrayList<S3AFileStatus> stats = new ArrayList<S3AFileStatus>(objects.getObjectSummaries().size() + objects.getCommonPrefixes().size());
            for (S3ObjectSummary summary : objects.getObjectSummaries()) {
                String key = summary.getKey();
                Path keyPath = Listing.this.owner.keyToQualifiedPath(key);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: {}", (Object)keyPath, (Object)S3AUtils.stringify(summary));
                }
                if (this.acceptor.accept(keyPath, summary) && this.filter.accept(keyPath)) {
                    S3AFileStatus status = S3AUtils.createFileStatus(keyPath, summary, Listing.this.owner.getDefaultBlockSize(keyPath), Listing.this.owner.getUsername());
                    LOG.debug("Adding: {}", (Object)status);
                    stats.add(status);
                    ++added;
                    continue;
                }
                LOG.debug("Ignoring: {}", (Object)keyPath);
                ++ignored;
            }
            for (String prefix : objects.getCommonPrefixes()) {
                Path keyPath = Listing.this.owner.keyToQualifiedPath(prefix);
                if (this.acceptor.accept(keyPath, prefix) && this.filter.accept(keyPath)) {
                    S3AFileStatus status = new S3AFileStatus(Tristate.FALSE, keyPath, Listing.this.owner.getUsername());
                    LOG.debug("Adding directory: {}", (Object)status);
                    ++added;
                    stats.add(status);
                    continue;
                }
                LOG.debug("Ignoring directory: {}", (Object)keyPath);
                ++ignored;
            }
            this.batchSize = stats.size();
            this.statusBatchIterator = stats.listIterator();
            boolean hasNext = this.statusBatchIterator.hasNext();
            LOG.debug("Added {} entries; ignored {}; hasNext={}; hasMoreObjects={}", new Object[]{added, ignored, hasNext, objects.isTruncated()});
            return hasNext;
        }

        public int getBatchSize() {
            return this.batchSize;
        }
    }

    static class ProvidedFileStatusIterator
    implements RemoteIterator<FileStatus> {
        private final ArrayList<FileStatus> filteredStatusList;
        private int index = 0;

        ProvidedFileStatusIterator(FileStatus[] fileStatuses, PathFilter filter, FileStatusAcceptor acceptor) {
            Preconditions.checkArgument((fileStatuses != null ? 1 : 0) != 0, (Object)"Null status list!");
            this.filteredStatusList = new ArrayList(fileStatuses.length);
            for (FileStatus status : fileStatuses) {
                if (!filter.accept(status.getPath()) || !acceptor.accept(status)) continue;
                this.filteredStatusList.add(status);
            }
            this.filteredStatusList.trimToSize();
        }

        public boolean hasNext() throws IOException {
            return this.index < this.filteredStatusList.size();
        }

        public FileStatus next() throws IOException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.filteredStatusList.get(this.index++);
        }
    }

    static final class SingleStatusRemoteIterator
    implements RemoteIterator<LocatedFileStatus> {
        private LocatedFileStatus status;

        public SingleStatusRemoteIterator(LocatedFileStatus status) {
            this.status = status;
        }

        public boolean hasNext() throws IOException {
            return this.status != null;
        }

        public LocatedFileStatus next() throws IOException {
            if (this.hasNext()) {
                LocatedFileStatus s = this.status;
                this.status = null;
                return s;
            }
            throw new NoSuchElementException();
        }
    }

    static interface FileStatusAcceptor {
        public boolean accept(Path var1, S3ObjectSummary var2);

        public boolean accept(Path var1, String var2);

        public boolean accept(FileStatus var1);
    }
}

