/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.BatchScan;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.IncrementalAppendScan;
import org.apache.iceberg.IncrementalChangelogScan;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.MetricsModes;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Scan;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.AggregateEvaluator;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.BoundAggregate;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionUtil;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkAggregates;
import org.apache.iceberg.spark.SparkFilters;
import org.apache.iceberg.spark.SparkReadConf;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.source.SparkBatchQueryScan;
import org.apache.iceberg.spark.source.SparkChangelogScan;
import org.apache.iceberg.spark.source.SparkCopyOnWriteScan;
import org.apache.iceberg.spark.source.SparkLocalScan;
import org.apache.iceberg.spark.source.StructInternalRow;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.Aggregation;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.Statistics;
import org.apache.spark.sql.connector.read.SupportsPushDownAggregates;
import org.apache.spark.sql.connector.read.SupportsPushDownFilters;
import org.apache.spark.sql.connector.read.SupportsPushDownRequiredColumns;
import org.apache.spark.sql.connector.read.SupportsReportStatistics;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkScanBuilder
implements ScanBuilder,
SupportsPushDownAggregates,
SupportsPushDownFilters,
SupportsPushDownRequiredColumns,
SupportsReportStatistics {
    private static final Logger LOG = LoggerFactory.getLogger(SparkScanBuilder.class);
    private static final Filter[] NO_FILTERS = new Filter[0];
    private StructType pushedAggregateSchema;
    private org.apache.spark.sql.connector.read.Scan localScan;
    private final SparkSession spark;
    private final Table table;
    private final CaseInsensitiveStringMap options;
    private final SparkReadConf readConf;
    private final List<String> metaColumns = Lists.newArrayList();
    private Schema schema;
    private boolean caseSensitive;
    private List<Expression> filterExpressions = null;
    private Filter[] pushedFilters = NO_FILTERS;

    SparkScanBuilder(SparkSession spark, Table table, String branch, Schema schema, CaseInsensitiveStringMap options) {
        this.spark = spark;
        this.table = table;
        this.schema = schema;
        this.options = options;
        this.readConf = new SparkReadConf(spark, table, branch, (Map<String, String>)options);
        this.caseSensitive = this.readConf.caseSensitive();
    }

    SparkScanBuilder(SparkSession spark, Table table, CaseInsensitiveStringMap options) {
        this(spark, table, table.schema(), options);
    }

    SparkScanBuilder(SparkSession spark, Table table, String branch, CaseInsensitiveStringMap options) {
        this(spark, table, branch, SnapshotUtil.schemaFor((Table)table, (String)branch), options);
    }

    SparkScanBuilder(SparkSession spark, Table table, Schema schema, CaseInsensitiveStringMap options) {
        this(spark, table, null, schema, options);
    }

    private Expression filterExpression() {
        if (this.filterExpressions != null) {
            return (Expression)this.filterExpressions.stream().reduce(Expressions.alwaysTrue(), Expressions::and);
        }
        return Expressions.alwaysTrue();
    }

    public SparkScanBuilder caseSensitive(boolean isCaseSensitive) {
        this.caseSensitive = isCaseSensitive;
        return this;
    }

    public Filter[] pushFilters(Filter[] filters) {
        ArrayList expressions = Lists.newArrayListWithExpectedSize((int)filters.length);
        ArrayList pushableFilters = Lists.newArrayListWithExpectedSize((int)filters.length);
        ArrayList postScanFilters = Lists.newArrayListWithExpectedSize((int)filters.length);
        for (Filter filter : filters) {
            try {
                Expression expr = SparkFilters.convert(filter);
                if (expr != null) {
                    Binder.bind((Types.StructType)this.schema.asStruct(), (Expression)expr, (boolean)this.caseSensitive);
                    expressions.add(expr);
                    pushableFilters.add(filter);
                }
                if (expr == null || this.unpartitioned() || !ExpressionUtil.selectsPartitions((Expression)expr, (Table)this.table, (boolean)this.caseSensitive)) {
                    postScanFilters.add(filter);
                    continue;
                }
                LOG.info("Evaluating completely on Iceberg side: {}", (Object)filter);
            }
            catch (Exception e) {
                LOG.warn("Failed to check if {} can be pushed down: {}", (Object)filter, (Object)e.getMessage());
                postScanFilters.add(filter);
            }
        }
        this.filterExpressions = expressions;
        this.pushedFilters = pushableFilters.toArray(new Filter[0]);
        return postScanFilters.toArray(new Filter[0]);
    }

    private boolean unpartitioned() {
        return this.table.specs().values().stream().noneMatch(PartitionSpec::isPartitioned);
    }

    public Filter[] pushedFilters() {
        return this.pushedFilters;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean pushAggregation(Aggregation aggregation) {
        if (!this.canPushDownAggregation(aggregation)) {
            return false;
        }
        ArrayList expressions = Lists.newArrayListWithExpectedSize((int)aggregation.aggregateExpressions().length);
        for (AggregateFunc aggregateFunc : aggregation.aggregateExpressions()) {
            try {
                Expression expr = SparkAggregates.convert(aggregateFunc);
                if (expr == null) {
                    LOG.info("Skipping aggregate pushdown: AggregateFunc {} can't be converted to iceberg expression", (Object)aggregateFunc);
                    return false;
                }
                Expression bound = Binder.bind((Types.StructType)this.schema.asStruct(), (Expression)expr, (boolean)this.caseSensitive);
                expressions.add((BoundAggregate)bound);
            }
            catch (IllegalArgumentException e) {
                LOG.info("Skipping aggregate pushdown: Bind failed for AggregateFunc {}", (Object)aggregateFunc, (Object)e);
                return false;
            }
        }
        AggregateEvaluator aggregateEvaluator = AggregateEvaluator.create((List)expressions);
        if (!this.metricsModeSupportsAggregatePushDown(aggregateEvaluator.aggregates())) {
            return false;
        }
        TableScan scan = (TableScan)this.table.newScan().includeColumnStats();
        Snapshot snapshot = this.readSnapshot();
        if (snapshot == null) {
            LOG.info("Skipping aggregate pushdown: table snapshot is null");
            return false;
        }
        scan = scan.useSnapshot(snapshot.snapshotId());
        scan = this.configureSplitPlanning(scan);
        scan = (TableScan)scan.filter(this.filterExpression());
        try {
            Throwable throwable = null;
            try (CloseableIterable fileScanTasks = scan.planFiles();){
                ImmutableList tasks = ImmutableList.copyOf((Iterable)fileScanTasks);
                for (FileScanTask task : tasks) {
                    if (!task.deletes().isEmpty()) {
                        LOG.info("Skipping aggregate pushdown: detected row level deletes");
                        boolean bl = false;
                        return bl;
                    }
                    aggregateEvaluator.update((DataFile)task.file());
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            LOG.info("Skipping aggregate pushdown: ", (Throwable)e);
            return false;
        }
        if (!aggregateEvaluator.allAggregatorsValid()) {
            return false;
        }
        this.pushedAggregateSchema = SparkSchemaUtil.convert(new Schema(aggregateEvaluator.resultType().fields()));
        InternalRow[] pushedAggregateRows = new InternalRow[1];
        StructLike structLike = aggregateEvaluator.result();
        pushedAggregateRows[0] = new StructInternalRow(aggregateEvaluator.resultType()).setStruct(structLike);
        this.localScan = new SparkLocalScan(this.table, this.pushedAggregateSchema, pushedAggregateRows, this.filterExpressions);
        return true;
    }

    private boolean canPushDownAggregation(Aggregation aggregation) {
        if (!(this.table instanceof BaseTable)) {
            return false;
        }
        if (!this.readConf.aggregatePushDownEnabled()) {
            return false;
        }
        if (this.readConf.startSnapshotId() != null) {
            LOG.info("Skipping aggregate pushdown: incremental scan is not supported");
            return false;
        }
        if (aggregation.groupByExpressions().length > 0) {
            LOG.info("Skipping aggregate pushdown: group by aggregation push down is not supported");
            return false;
        }
        return true;
    }

    private Snapshot readSnapshot() {
        Snapshot snapshot = this.readConf.snapshotId() != null ? this.table.snapshot(this.readConf.snapshotId().longValue()) : SnapshotUtil.latestSnapshot((Table)this.table, (String)this.readConf.branch());
        return snapshot;
    }

    private boolean metricsModeSupportsAggregatePushDown(List<BoundAggregate<?, ?>> aggregates) {
        MetricsConfig config = MetricsConfig.forTable((Table)this.table);
        for (BoundAggregate<?, ?> aggregate : aggregates) {
            String colName = aggregate.columnName();
            if (colName.equals("*")) continue;
            MetricsModes.MetricsMode mode = config.columnMode(colName);
            if (mode instanceof MetricsModes.None) {
                LOG.info("Skipping aggregate pushdown: No metrics for column {}", (Object)colName);
                return false;
            }
            if (mode instanceof MetricsModes.Counts) {
                if (aggregate.op() != Expression.Operation.MAX && aggregate.op() != Expression.Operation.MIN) continue;
                LOG.info("Skipping aggregate pushdown: Cannot produce min or max from count for column {}", (Object)colName);
                return false;
            }
            if (!(mode instanceof MetricsModes.Truncate) || aggregate.type().typeId() != Type.TypeID.STRING || aggregate.op() != Expression.Operation.MAX && aggregate.op() != Expression.Operation.MIN) continue;
            LOG.info("Skipping aggregate pushdown: Cannot produce min or max from truncated values for column {}", (Object)colName);
            return false;
        }
        return true;
    }

    public void pruneColumns(StructType requestedSchema) {
        StructType requestedProjection = new StructType((StructField[])Stream.of(requestedSchema.fields()).filter(field -> MetadataColumns.nonMetadataColumn((String)field.name())).toArray(StructField[]::new));
        this.schema = SparkSchemaUtil.prune(this.schema, requestedProjection, this.filterExpression(), this.caseSensitive);
        Stream.of(requestedSchema.fields()).map(StructField::name).filter(MetadataColumns::isMetadataColumn).distinct().forEach(this.metaColumns::add);
    }

    private Schema schemaWithMetadataColumns() {
        List<Types.NestedField> metadataFields = this.metaColumns.stream().distinct().map(name -> MetadataColumns.metadataColumn((Table)this.table, (String)name)).collect(Collectors.toList());
        Schema metadataSchema = this.calculateMetadataSchema(metadataFields);
        return TypeUtil.join((Schema)this.schema, (Schema)metadataSchema);
    }

    private Schema calculateMetadataSchema(List<Types.NestedField> metaColumnFields) {
        Optional<Types.NestedField> partitionField = metaColumnFields.stream().filter(f -> 0x7FFFFFFA == f.fieldId()).findFirst();
        if (!partitionField.isPresent()) {
            return new Schema(metaColumnFields);
        }
        Set idsToReassign = TypeUtil.indexById((Types.StructType)partitionField.get().type().asStructType()).keySet();
        Set currentlyUsedIds = metaColumnFields.stream().map(Types.NestedField::fieldId).collect(Collectors.toSet());
        Set allUsedIds = this.table.schemas().values().stream().map(currSchema -> TypeUtil.indexById((Types.StructType)currSchema.asStruct()).keySet()).reduce(currentlyUsedIds, Sets::union);
        AtomicInteger nextId = new AtomicInteger();
        return new Schema(metaColumnFields, this.table.schema().identifierFieldIds(), oldId -> {
            if (!idsToReassign.contains(oldId)) {
                return oldId;
            }
            int candidate = nextId.incrementAndGet();
            while (allUsedIds.contains(candidate)) {
                candidate = nextId.incrementAndGet();
            }
            return candidate;
        });
    }

    public org.apache.spark.sql.connector.read.Scan build() {
        if (this.localScan != null) {
            return this.localScan;
        }
        return this.buildBatchScan();
    }

    private org.apache.spark.sql.connector.read.Scan buildBatchScan() {
        Long snapshotId = this.readConf.snapshotId();
        Long asOfTimestamp = this.readConf.asOfTimestamp();
        String branch = this.readConf.branch();
        String tag = this.readConf.tag();
        Preconditions.checkArgument((snapshotId == null || asOfTimestamp == null ? 1 : 0) != 0, (String)"Cannot set both %s and %s to select which table snapshot to scan", (Object)"snapshot-id", (Object)"as-of-timestamp");
        Long startSnapshotId = this.readConf.startSnapshotId();
        Long endSnapshotId = this.readConf.endSnapshotId();
        if (snapshotId != null || asOfTimestamp != null) {
            Preconditions.checkArgument((startSnapshotId == null && endSnapshotId == null ? 1 : 0) != 0, (String)"Cannot set %s and %s for incremental scans when either %s or %s is set", (Object)"start-snapshot-id", (Object)"end-snapshot-id", (Object)"snapshot-id", (Object)"as-of-timestamp");
        }
        Preconditions.checkArgument((startSnapshotId != null || endSnapshotId == null ? 1 : 0) != 0, (String)"Cannot set only %s for incremental scans. Please, set %s too.", (Object)"end-snapshot-id", (Object)"start-snapshot-id");
        Long startTimestamp = this.readConf.startTimestamp();
        Long endTimestamp = this.readConf.endTimestamp();
        Preconditions.checkArgument((startTimestamp == null && endTimestamp == null ? 1 : 0) != 0, (String)"Cannot set %s or %s for incremental scans and batch scan. They are only valid for changelog scans.", (Object)"start-timestamp", (Object)"end-timestamp");
        if (startSnapshotId != null) {
            return this.buildIncrementalAppendScan(startSnapshotId, endSnapshotId);
        }
        return this.buildBatchScan(snapshotId, asOfTimestamp, branch, tag);
    }

    private org.apache.spark.sql.connector.read.Scan buildBatchScan(Long snapshotId, Long asOfTimestamp, String branch, String tag) {
        Schema expectedSchema = this.schemaWithMetadataColumns();
        BatchScan scan = (BatchScan)((BatchScan)((BatchScan)this.table.newBatchScan().caseSensitive(this.caseSensitive)).filter(this.filterExpression())).project(expectedSchema);
        if (snapshotId != null) {
            scan = scan.useSnapshot(snapshotId.longValue());
        }
        if (asOfTimestamp != null) {
            scan = scan.asOfTime(asOfTimestamp.longValue());
        }
        if (branch != null) {
            scan = scan.useRef(branch);
        }
        if (tag != null) {
            scan = scan.useRef(tag);
        }
        scan = this.configureSplitPlanning(scan);
        return new SparkBatchQueryScan(this.spark, this.table, (Scan<?, ? extends ScanTask, ? extends ScanTaskGroup<?>>)scan, this.readConf, expectedSchema, this.filterExpressions);
    }

    private org.apache.spark.sql.connector.read.Scan buildIncrementalAppendScan(long startSnapshotId, Long endSnapshotId) {
        Schema expectedSchema = this.schemaWithMetadataColumns();
        IncrementalAppendScan scan = (IncrementalAppendScan)((IncrementalAppendScan)((IncrementalAppendScan)((IncrementalAppendScan)this.table.newIncrementalAppendScan().fromSnapshotExclusive(startSnapshotId)).caseSensitive(this.caseSensitive)).filter(this.filterExpression())).project(expectedSchema);
        if (endSnapshotId != null) {
            scan = (IncrementalAppendScan)scan.toSnapshot(endSnapshotId.longValue());
        }
        scan = this.configureSplitPlanning(scan);
        return new SparkBatchQueryScan(this.spark, this.table, (Scan<?, ? extends ScanTask, ? extends ScanTaskGroup<?>>)scan, this.readConf, expectedSchema, this.filterExpressions);
    }

    public org.apache.spark.sql.connector.read.Scan buildChangelogScan() {
        Preconditions.checkArgument((this.readConf.snapshotId() == null && this.readConf.asOfTimestamp() == null && this.readConf.branch() == null && this.readConf.tag() == null ? 1 : 0) != 0, (String)"Cannot set neither %s, %s, %s and %s for changelogs", (Object)"snapshot-id", (Object)"as-of-timestamp", (Object)"branch", (Object)"tag");
        Long startSnapshotId = this.readConf.startSnapshotId();
        Long endSnapshotId = this.readConf.endSnapshotId();
        Long startTimestamp = this.readConf.startTimestamp();
        Long endTimestamp = this.readConf.endTimestamp();
        Preconditions.checkArgument((startSnapshotId == null || startTimestamp == null ? 1 : 0) != 0, (String)"Cannot set both %s and %s for changelogs", (Object)"start-snapshot-id", (Object)"start-timestamp");
        Preconditions.checkArgument((endSnapshotId == null || endTimestamp == null ? 1 : 0) != 0, (String)"Cannot set both %s and %s for changelogs", (Object)"end-snapshot-id", (Object)"end-timestamp");
        if (startTimestamp != null && endTimestamp != null) {
            Preconditions.checkArgument((startTimestamp < endTimestamp ? 1 : 0) != 0, (String)"Cannot set %s to be greater than %s for changelogs", (Object)"start-timestamp", (Object)"end-timestamp");
        }
        boolean emptyScan = false;
        if (startTimestamp != null && (startSnapshotId = this.getStartSnapshotId(startTimestamp)) == null && endTimestamp == null) {
            emptyScan = true;
        }
        if (endTimestamp != null) {
            endSnapshotId = SnapshotUtil.nullableSnapshotIdAsOfTime((Table)this.table, (long)endTimestamp);
            if (startSnapshotId == null && endSnapshotId == null || startSnapshotId != null && startSnapshotId.equals(endSnapshotId)) {
                emptyScan = true;
            }
        }
        Schema expectedSchema = this.schemaWithMetadataColumns();
        IncrementalChangelogScan scan = (IncrementalChangelogScan)((IncrementalChangelogScan)((IncrementalChangelogScan)this.table.newIncrementalChangelogScan().caseSensitive(this.caseSensitive)).filter(this.filterExpression())).project(expectedSchema);
        if (startSnapshotId != null) {
            scan = (IncrementalChangelogScan)scan.fromSnapshotExclusive(startSnapshotId.longValue());
        }
        if (endSnapshotId != null) {
            scan = (IncrementalChangelogScan)scan.toSnapshot(endSnapshotId.longValue());
        }
        scan = this.configureSplitPlanning(scan);
        return new SparkChangelogScan(this.spark, this.table, scan, this.readConf, expectedSchema, this.filterExpressions, emptyScan);
    }

    private Long getStartSnapshotId(Long startTimestamp) {
        Snapshot oldestSnapshotAfter = SnapshotUtil.oldestAncestorAfter((Table)this.table, (long)startTimestamp);
        if (oldestSnapshotAfter == null) {
            return null;
        }
        if (oldestSnapshotAfter.timestampMillis() == startTimestamp.longValue()) {
            return oldestSnapshotAfter.snapshotId();
        }
        return oldestSnapshotAfter.parentId();
    }

    public org.apache.spark.sql.connector.read.Scan buildMergeOnReadScan() {
        Preconditions.checkArgument((this.readConf.snapshotId() == null && this.readConf.asOfTimestamp() == null && this.readConf.tag() == null ? 1 : 0) != 0, (String)"Cannot set time travel options %s, %s, %s for row-level command scans", (Object)"snapshot-id", (Object)"as-of-timestamp", (Object)"tag");
        Preconditions.checkArgument((this.readConf.startSnapshotId() == null && this.readConf.endSnapshotId() == null ? 1 : 0) != 0, (String)"Cannot set incremental scan options %s and %s for row-level command scans", (Object)"start-snapshot-id", (Object)"end-snapshot-id");
        Snapshot snapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.readConf.branch());
        if (snapshot == null) {
            return new SparkBatchQueryScan(this.spark, this.table, null, this.readConf, this.schemaWithMetadataColumns(), this.filterExpressions);
        }
        long snapshotId = snapshot.snapshotId();
        CaseInsensitiveStringMap adjustedOptions = Spark3Util.setOption("snapshot-id", Long.toString(snapshotId), this.options);
        SparkReadConf adjustedReadConf = new SparkReadConf(this.spark, this.table, this.readConf.branch(), (Map<String, String>)adjustedOptions);
        Schema expectedSchema = this.schemaWithMetadataColumns();
        BatchScan scan = (BatchScan)((BatchScan)((BatchScan)this.table.newBatchScan().useSnapshot(snapshotId).caseSensitive(this.caseSensitive)).filter(this.filterExpression())).project(expectedSchema);
        scan = this.configureSplitPlanning(scan);
        return new SparkBatchQueryScan(this.spark, this.table, (Scan<?, ? extends ScanTask, ? extends ScanTaskGroup<?>>)scan, adjustedReadConf, expectedSchema, this.filterExpressions);
    }

    public org.apache.spark.sql.connector.read.Scan buildCopyOnWriteScan() {
        Snapshot snapshot = SnapshotUtil.latestSnapshot((Table)this.table, (String)this.readConf.branch());
        if (snapshot == null) {
            return new SparkCopyOnWriteScan(this.spark, this.table, this.readConf, this.schemaWithMetadataColumns(), this.filterExpressions);
        }
        Schema expectedSchema = this.schemaWithMetadataColumns();
        BatchScan scan = (BatchScan)((BatchScan)((BatchScan)((BatchScan)this.table.newBatchScan().useSnapshot(snapshot.snapshotId()).ignoreResiduals()).caseSensitive(this.caseSensitive)).filter(this.filterExpression())).project(expectedSchema);
        scan = this.configureSplitPlanning(scan);
        return new SparkCopyOnWriteScan(this.spark, this.table, scan, snapshot, this.readConf, expectedSchema, this.filterExpressions);
    }

    private <T extends Scan<T, ?, ?>> T configureSplitPlanning(T scan) {
        Long splitOpenFileCost;
        Integer splitLookback;
        Object configuredScan = scan;
        Long splitSize = this.readConf.splitSizeOption();
        if (splitSize != null) {
            configuredScan = (Scan)configuredScan.option("read.split.target-size", String.valueOf(splitSize));
        }
        if ((splitLookback = this.readConf.splitLookbackOption()) != null) {
            configuredScan = (Scan)configuredScan.option("read.split.planning-lookback", String.valueOf(splitLookback));
        }
        if ((splitOpenFileCost = this.readConf.splitOpenFileCostOption()) != null) {
            configuredScan = (Scan)configuredScan.option("read.split.open-file-cost", String.valueOf(splitOpenFileCost));
        }
        return configuredScan;
    }

    public Statistics estimateStatistics() {
        return ((SupportsReportStatistics)this.build()).estimateStatistics();
    }

    public StructType readSchema() {
        return this.build().readSchema();
    }
}

