/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseFileRewriteCoordinator<F extends ContentFile<F>> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseFileRewriteCoordinator.class);
    private final Map<Pair<String, String>, Set<F>> resultMap = Maps.newConcurrentMap();

    BaseFileRewriteCoordinator() {
    }

    public void stageRewrite(Table table, String fileSetId, Set<F> newFiles) {
        LOG.debug("Staging the output for {} - fileset {} with {} files", new Object[]{table.name(), fileSetId, newFiles.size()});
        Pair<String, String> id = this.toId(table, fileSetId);
        this.resultMap.put(id, newFiles);
    }

    public Set<F> fetchNewFiles(Table table, String fileSetId) {
        Pair<String, String> id = this.toId(table, fileSetId);
        Set<F> result = this.resultMap.get(id);
        ValidationException.check((result != null ? 1 : 0) != 0, (String)"No results for rewrite of file set %s in table %s", (Object[])new Object[]{fileSetId, table});
        return result;
    }

    public void clearRewrite(Table table, String fileSetId) {
        LOG.debug("Removing entry for {} - id {}", (Object)table.name(), (Object)fileSetId);
        Pair<String, String> id = this.toId(table, fileSetId);
        this.resultMap.remove(id);
    }

    public Set<String> fetchSetIds(Table table) {
        return this.resultMap.keySet().stream().filter(e -> ((String)e.first()).equals(Spark3Util.baseTableUUID(table))).map(Pair::second).collect(Collectors.toSet());
    }

    private Pair<String, String> toId(Table table, String setId) {
        return Pair.of((Object)Spark3Util.baseTableUUID(table), (Object)setId);
    }
}

