/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.datagen.functions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.connector.datagen.source.GeneratorFunction;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.streaming.api.operators.OutputTypeConfigurable;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class FromElementsGeneratorFunction<OUT>
implements GeneratorFunction<Long, OUT>,
OutputTypeConfigurable<OUT> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(FromElementsGeneratorFunction.class);
    @Nullable
    private TypeSerializer<OUT> serializer;
    private byte[] elementsSerialized;
    private int numElementsEmitted;
    private transient Iterable<OUT> elements;
    private transient DataInputView input;

    @SafeVarargs
    public FromElementsGeneratorFunction(TypeInformation<OUT> typeInfo, OUT ... elements) {
        this(typeInfo, new ExecutionConfig(), (Iterable<OUT>)Arrays.asList(elements));
    }

    public FromElementsGeneratorFunction(TypeInformation<OUT> typeInfo, ExecutionConfig config, Iterable<OUT> elements) {
        FromElementsGeneratorFunction.checkIterable(elements, typeInfo.getTypeClass());
        this.serializer = typeInfo.createSerializer(config.getSerializerConfig());
        this.elements = elements;
        this.trySerialize(elements);
    }

    @Nullable
    @VisibleForTesting
    public TypeSerializer<OUT> getSerializer() {
        return this.serializer;
    }

    private void serializeElements(Iterable<OUT> elements) throws IOException {
        Preconditions.checkState((this.serializer != null ? 1 : 0) != 0, (Object)"serializer not set");
        LOG.info("Serializing elements using  {}", this.serializer);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper wrapper = new DataOutputViewStreamWrapper((OutputStream)baos);
        try {
            for (OUT element : elements) {
                this.serializer.serialize(element, (DataOutputView)wrapper);
            }
        }
        catch (Exception e) {
            throw new IOException("Serializing the source elements failed: " + e.getMessage(), e);
        }
        this.elementsSerialized = baos.toByteArray();
    }

    @Override
    public void open(SourceReaderContext readerContext) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.elementsSerialized);
        this.input = new DataInputViewStreamWrapper((InputStream)bais);
    }

    @Override
    public OUT map(Long nextIndex) throws Exception {
        while ((long)this.numElementsEmitted < nextIndex) {
            ++this.numElementsEmitted;
            this.tryDeserialize(this.serializer, this.input);
        }
        ++this.numElementsEmitted;
        return this.tryDeserialize(this.serializer, this.input);
    }

    private OUT tryDeserialize(TypeSerializer<OUT> serializer, DataInputView input) throws IOException {
        try {
            return (OUT)serializer.deserialize(input);
        }
        catch (EOFException eof) {
            throw new NoSuchElementException("Reached the end of the collection. This could be caused by issues with the serializer or by calling the map() function more times than there are elements in the collection. Make sure that you set the number of records to be produced by the DataGeneratorSource equal to the number of elements in the collection.");
        }
        catch (Exception e) {
            throw new IOException("Failed to deserialize an element from the source. If you are using user-defined serialization (Value and Writable types), check the serialization functions.\nSerializer is " + serializer, e);
        }
    }

    public void setOutputType(TypeInformation<OUT> outTypeInfo, ExecutionConfig executionConfig) {
        Preconditions.checkState((this.elements != null ? 1 : 0) != 0, (Object)"The output type should've been specified before shipping the graph to the cluster");
        FromElementsGeneratorFunction.checkIterable(this.elements, outTypeInfo.getTypeClass());
        TypeSerializer newSerializer = outTypeInfo.createSerializer(executionConfig.getSerializerConfig());
        if (Objects.equals(this.serializer, newSerializer)) {
            return;
        }
        this.serializer = newSerializer;
        try {
            this.serializeElements(this.elements);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void trySerialize(Iterable<OUT> elements) {
        try {
            this.serializeElements(elements);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static <OUT> void checkIterable(Iterable<OUT> elements, Class<?> viewedAs) {
        for (OUT elem : elements) {
            if (elem == null) {
                throw new IllegalArgumentException("The collection contains a null element");
            }
            if (viewedAs.isAssignableFrom(elem.getClass())) continue;
            throw new IllegalArgumentException("The elements in the collection are not all subclasses of " + viewedAs.getCanonicalName());
        }
    }
}

