/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.util;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.sql.connector.expressions.Cast;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.GeneralScalarExpression;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.types.DataType;

public class V2ExpressionSQLBuilder {
    public String build(Expression expr) {
        if (expr instanceof Literal) {
            return this.visitLiteral((Literal)expr);
        }
        if (expr instanceof NamedReference) {
            return this.visitNamedReference((NamedReference)expr);
        }
        if (expr instanceof Cast) {
            Cast cast = (Cast)expr;
            return this.visitCast(this.build(cast.expression()), cast.dataType());
        }
        if (expr instanceof GeneralScalarExpression) {
            String name;
            GeneralScalarExpression e = (GeneralScalarExpression)expr;
            switch (name = e.name()) {
                case "IN": {
                    List children2 = Arrays.stream(e.children()).map(c -> this.build((Expression)c)).collect(Collectors.toList());
                    return this.visitIn((String)children2.get(0), children2.subList(1, children2.size()));
                }
                case "IS_NULL": {
                    return this.visitIsNull(this.build(e.children()[0]));
                }
                case "IS_NOT_NULL": {
                    return this.visitIsNotNull(this.build(e.children()[0]));
                }
                case "STARTS_WITH": {
                    return this.visitStartsWith(this.build(e.children()[0]), this.build(e.children()[1]));
                }
                case "ENDS_WITH": {
                    return this.visitEndsWith(this.build(e.children()[0]), this.build(e.children()[1]));
                }
                case "CONTAINS": {
                    return this.visitContains(this.build(e.children()[0]), this.build(e.children()[1]));
                }
                case "=": 
                case "<>": 
                case "<=>": 
                case "<": 
                case "<=": 
                case ">": 
                case ">=": {
                    return this.visitBinaryComparison(name, this.inputToSQL(e.children()[0]), this.inputToSQL(e.children()[1]));
                }
                case "+": 
                case "*": 
                case "/": 
                case "%": 
                case "&": 
                case "|": 
                case "^": {
                    return this.visitBinaryArithmetic(name, this.inputToSQL(e.children()[0]), this.inputToSQL(e.children()[1]));
                }
                case "-": {
                    if (e.children().length == 1) {
                        return this.visitUnaryArithmetic(name, this.inputToSQL(e.children()[0]));
                    }
                    return this.visitBinaryArithmetic(name, this.inputToSQL(e.children()[0]), this.inputToSQL(e.children()[1]));
                }
                case "AND": {
                    return this.visitAnd(name, this.build(e.children()[0]), this.build(e.children()[1]));
                }
                case "OR": {
                    return this.visitOr(name, this.build(e.children()[0]), this.build(e.children()[1]));
                }
                case "NOT": {
                    return this.visitNot(this.build(e.children()[0]));
                }
                case "~": {
                    return this.visitUnaryArithmetic(name, this.inputToSQL(e.children()[0]));
                }
                case "ABS": 
                case "COALESCE": 
                case "LN": 
                case "EXP": 
                case "POWER": 
                case "SQRT": 
                case "FLOOR": 
                case "CEIL": 
                case "WIDTH_BUCKET": {
                    return this.visitSQLFunction(name, (String[])Arrays.stream(e.children()).map(c -> this.build((Expression)c)).toArray(String[]::new));
                }
                case "CASE_WHEN": {
                    List<String> children3 = Arrays.stream(e.children()).map(c -> this.build((Expression)c)).collect(Collectors.toList());
                    return this.visitCaseWhen(children3.toArray(new String[e.children().length]));
                }
            }
            return this.visitUnexpectedExpr(expr);
        }
        return this.visitUnexpectedExpr(expr);
    }

    protected String visitLiteral(Literal literal) {
        return literal.toString();
    }

    protected String visitNamedReference(NamedReference namedRef) {
        return namedRef.toString();
    }

    protected String visitIn(String v, List<String> list) {
        if (list.isEmpty()) {
            return "CASE WHEN " + v + " IS NULL THEN NULL ELSE FALSE END";
        }
        return v + " IN (" + list.stream().collect(Collectors.joining(", ")) + ")";
    }

    protected String visitIsNull(String v) {
        return v + " IS NULL";
    }

    protected String visitIsNotNull(String v) {
        return v + " IS NOT NULL";
    }

    protected String visitStartsWith(String l, String r) {
        String value = r.substring(1, r.length() - 1);
        return l + " LIKE '" + value + "%'";
    }

    protected String visitEndsWith(String l, String r) {
        String value = r.substring(1, r.length() - 1);
        return l + " LIKE '%" + value + "'";
    }

    protected String visitContains(String l, String r) {
        String value = r.substring(1, r.length() - 1);
        return l + " LIKE '%" + value + "%'";
    }

    private String inputToSQL(Expression input) {
        if (input.children().length > 1) {
            return "(" + this.build(input) + ")";
        }
        return this.build(input);
    }

    protected String visitBinaryComparison(String name, String l, String r) {
        switch (name) {
            case "<=>": {
                return "(" + l + " = " + r + ") OR (" + l + " IS NULL AND " + r + " IS NULL)";
            }
        }
        return l + " " + name + " " + r;
    }

    protected String visitBinaryArithmetic(String name, String l, String r) {
        return l + " " + name + " " + r;
    }

    protected String visitCast(String l, DataType dataType) {
        return "CAST(" + l + " AS " + dataType.typeName() + ")";
    }

    protected String visitAnd(String name, String l, String r) {
        return "(" + l + ") " + name + " (" + r + ")";
    }

    protected String visitOr(String name, String l, String r) {
        return "(" + l + ") " + name + " (" + r + ")";
    }

    protected String visitNot(String v) {
        return "NOT (" + v + ")";
    }

    protected String visitUnaryArithmetic(String name, String v) {
        return name + v;
    }

    protected String visitCaseWhen(String[] children2) {
        StringBuilder sb = new StringBuilder("CASE");
        for (int i = 0; i < children2.length; i += 2) {
            String c = children2[i];
            int j = i + 1;
            if (j < children2.length) {
                String v = children2[j];
                sb.append(" WHEN ");
                sb.append(c);
                sb.append(" THEN ");
                sb.append(v);
                continue;
            }
            sb.append(" ELSE ");
            sb.append(c);
        }
        sb.append(" END");
        return sb.toString();
    }

    protected String visitSQLFunction(String funcName, String[] inputs) {
        return funcName + "(" + Arrays.stream(inputs).collect(Collectors.joining(", ")) + ")";
    }

    protected String visitUnexpectedExpr(Expression expr) throws IllegalArgumentException {
        throw new IllegalArgumentException("Unexpected V2 expression: " + expr);
    }
}

