/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.util.Map;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.CatalogExtension;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.FunctionCatalog;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

@Evolving
public abstract class DelegatingCatalogExtension
implements CatalogExtension {
    private CatalogPlugin delegate;

    @Override
    public final void setDelegateCatalog(CatalogPlugin delegate) {
        this.delegate = delegate;
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public final void initialize(String name, CaseInsensitiveStringMap options) {
    }

    @Override
    public String[] defaultNamespace() {
        return this.delegate.defaultNamespace();
    }

    @Override
    public Identifier[] listTables(String[] namespace) throws NoSuchNamespaceException {
        return this.asTableCatalog().listTables(namespace);
    }

    @Override
    public Table loadTable(Identifier ident) throws NoSuchTableException {
        return this.asTableCatalog().loadTable(ident);
    }

    @Override
    public Table loadTable(Identifier ident, long timestamp) throws NoSuchTableException {
        return this.asTableCatalog().loadTable(ident, timestamp);
    }

    @Override
    public Table loadTable(Identifier ident, String version) throws NoSuchTableException {
        return this.asTableCatalog().loadTable(ident, version);
    }

    @Override
    public void invalidateTable(Identifier ident) {
        this.asTableCatalog().invalidateTable(ident);
    }

    @Override
    public boolean tableExists(Identifier ident) {
        return this.asTableCatalog().tableExists(ident);
    }

    @Override
    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) throws TableAlreadyExistsException, NoSuchNamespaceException {
        return this.asTableCatalog().createTable(ident, schema, partitions, properties);
    }

    @Override
    public Table alterTable(Identifier ident, TableChange ... changes) throws NoSuchTableException {
        return this.asTableCatalog().alterTable(ident, changes);
    }

    @Override
    public boolean dropTable(Identifier ident) {
        return this.asTableCatalog().dropTable(ident);
    }

    @Override
    public boolean purgeTable(Identifier ident) {
        return this.asTableCatalog().purgeTable(ident);
    }

    @Override
    public void renameTable(Identifier oldIdent, Identifier newIdent) throws NoSuchTableException, TableAlreadyExistsException {
        this.asTableCatalog().renameTable(oldIdent, newIdent);
    }

    @Override
    public String[][] listNamespaces() throws NoSuchNamespaceException {
        return this.asNamespaceCatalog().listNamespaces();
    }

    @Override
    public String[][] listNamespaces(String[] namespace) throws NoSuchNamespaceException {
        return this.asNamespaceCatalog().listNamespaces(namespace);
    }

    @Override
    public boolean namespaceExists(String[] namespace) {
        return this.asNamespaceCatalog().namespaceExists(namespace);
    }

    @Override
    public Map<String, String> loadNamespaceMetadata(String[] namespace) throws NoSuchNamespaceException {
        return this.asNamespaceCatalog().loadNamespaceMetadata(namespace);
    }

    @Override
    public void createNamespace(String[] namespace, Map<String, String> metadata) throws NamespaceAlreadyExistsException {
        this.asNamespaceCatalog().createNamespace(namespace, metadata);
    }

    @Override
    public void alterNamespace(String[] namespace, NamespaceChange ... changes) throws NoSuchNamespaceException {
        this.asNamespaceCatalog().alterNamespace(namespace, changes);
    }

    @Override
    public boolean dropNamespace(String[] namespace, boolean cascade) throws NoSuchNamespaceException, NonEmptyNamespaceException {
        return this.asNamespaceCatalog().dropNamespace(namespace, cascade);
    }

    @Override
    public UnboundFunction loadFunction(Identifier ident) throws NoSuchFunctionException {
        return this.asFunctionCatalog().loadFunction(ident);
    }

    @Override
    public Identifier[] listFunctions(String[] namespace) throws NoSuchNamespaceException {
        return this.asFunctionCatalog().listFunctions(namespace);
    }

    @Override
    public boolean functionExists(Identifier ident) {
        return this.asFunctionCatalog().functionExists(ident);
    }

    private TableCatalog asTableCatalog() {
        return (TableCatalog)this.delegate;
    }

    private SupportsNamespaces asNamespaceCatalog() {
        return (SupportsNamespaces)this.delegate;
    }

    private FunctionCatalog asFunctionCatalog() {
        return (FunctionCatalog)this.delegate;
    }
}

