/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans.logical.statsEstimation;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat$;
import org.apache.spark.sql.catalyst.plans.logical.Histogram;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.plans.logical.Statistics$;
import org.apache.spark.sql.catalyst.plans.logical.Union;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.EstimationUtils$;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.LogicalPlanStats;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.math.BigInt;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;

public final class UnionEstimation$ {
    public static UnionEstimation$ MODULE$;

    static {
        new UnionEstimation$();
    }

    private Function2<Object, Object, Object> createStatComparator(DataType dt) {
        Function2 & Serializable & scala.Serializable intersect;
        DataType dataType = dt;
        if (ByteType$.MODULE$.equals(dataType)) {
            intersect = (Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)UnionEstimation$.$anonfun$createStatComparator$1(a, b));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            intersect = (Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)UnionEstimation$.$anonfun$createStatComparator$2(a, b));
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            intersect = (Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)UnionEstimation$.$anonfun$createStatComparator$3(a, b));
        } else if (LongType$.MODULE$.equals(dataType)) {
            intersect = (Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)UnionEstimation$.$anonfun$createStatComparator$4(a, b));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            intersect = (Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)UnionEstimation$.$anonfun$createStatComparator$5(a, b));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            intersect = (Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)UnionEstimation$.$anonfun$createStatComparator$6(a, b));
        } else if (dataType instanceof DecimalType) {
            intersect = (Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)UnionEstimation$.$anonfun$createStatComparator$7(dt, a, b));
        } else if (DateType$.MODULE$.equals(dataType)) {
            intersect = (Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)UnionEstimation$.$anonfun$createStatComparator$8(a, b));
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            intersect = (Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)UnionEstimation$.$anonfun$createStatComparator$9(a, b));
        } else if (TimestampNTZType$.MODULE$.equals(dataType)) {
            intersect = (Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)UnionEstimation$.$anonfun$createStatComparator$10(a, b));
        } else if (dataType instanceof AnsiIntervalType) {
            AnsiIntervalType ansiIntervalType = (AnsiIntervalType)dataType;
            intersect = (Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)UnionEstimation$.$anonfun$createStatComparator$11(ansiIntervalType, a, b));
        } else {
            throw new IllegalStateException(new StringBuilder(23).append("Unsupported data type: ").append(dt.catalogString()).toString());
        }
        return intersect;
    }

    private boolean isTypeSupported(DataType dt) {
        DataType dataType = dt;
        boolean bl = ByteType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (FloatType$.MODULE$.equals(dataType) ? true : (LongType$.MODULE$.equals(dataType) ? true : (DoubleType$.MODULE$.equals(dataType) ? true : (DateType$.MODULE$.equals(dataType) ? true : (dataType instanceof DecimalType ? true : (TimestampType$.MODULE$.equals(dataType) ? true : (TimestampNTZType$.MODULE$.equals(dataType) ? true : dataType instanceof AnsiIntervalType)))))))));
        boolean bl2 = bl;
        return bl2;
    }

    public Option<Statistics> estimate(Union union) {
        BigInt sizeInBytes = (BigInt)((TraversableOnce)union.children().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.stats().sizeInBytes(), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.BigIntIsIntegral$.MODULE$);
        None$ outputRows = EstimationUtils$.MODULE$.rowCountsExist(union.children()) ? new Some(((TraversableOnce)union.children().map((Function1 & Serializable & scala.Serializable)x$2 -> (BigInt)x$2.stats().rowCount().get(), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.BigIntIsIntegral$.MODULE$)) : None$.MODULE$;
        Seq<Tuple2<Attribute, ColumnStat>> newMinMaxStats = this.computeMinMaxStats(union);
        Seq<Tuple2<Attribute, ColumnStat>> newNullCountStats = this.computeNullCountStats(union);
        AttributeMap<ColumnStat> baseStats = AttributeMap$.MODULE$.apply(newMinMaxStats);
        Seq overwriteStats = (Seq)newNullCountStats.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Attribute attr = (Attribute)tuple2._1();
            ColumnStat stat = (ColumnStat)tuple2._2();
            Tuple2 tuple22 = (Tuple2)baseStats.get(attr).map((Function1 & Serializable & scala.Serializable)baseStat -> {
                Option<BigInt> x$1 = stat.nullCount();
                Option<BigInt> x$2 = baseStat.copy$default$1();
                Option<Object> x$3 = baseStat.copy$default$2();
                Option<Object> x$4 = baseStat.copy$default$3();
                Option<Object> x$5 = baseStat.copy$default$5();
                Option<Object> x$6 = baseStat.copy$default$6();
                Option<Histogram> x$7 = baseStat.copy$default$7();
                int x$8 = baseStat.copy$default$8();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attr), (Object)baseStat.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8));
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> tuple2);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
        AttributeMap<ColumnStat> newAttrStats = AttributeMap$.MODULE$.apply((Seq)newMinMaxStats.$plus$plus((GenTraversableOnce)overwriteStats, Seq$.MODULE$.canBuildFrom()));
        return new Some((Object)new Statistics(sizeInBytes, (Option<BigInt>)outputRows, newAttrStats, Statistics$.MODULE$.apply$default$4()));
    }

    private Seq<Tuple2<Attribute, ColumnStat>> computeMinMaxStats(Union union) {
        Seq<Attribute> unionOutput = union.output();
        Seq attrToComputeMinMaxStats = (Seq)((TraversableLike)((IterableLike)((GenericTraversableTemplate)union.children().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.output(), Seq$.MODULE$.canBuildFrom())).transpose((Function1)Predef$.MODULE$.$conforms())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)UnionEstimation$.$anonfun$computeMinMaxStats$2(unionOutput, union, x0$1)));
        return (Seq)attrToComputeMinMaxStats.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq attrs2 = (Seq)tuple2._1();
            int outputIndex = tuple2._2$mcI$sp();
            DataType dataType = ((Expression)unionOutput.apply(outputIndex)).dataType();
            Function2<Object, Object, Object> statComparator = MODULE$.createStatComparator(dataType);
            Tuple2 minMaxValue = (Tuple2)((TraversableOnce)attrs2.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foldLeft((Object)new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$), (Function2 & Serializable & scala.Serializable)(x0$4, x1$1) -> {
                Option maxVal;
                Option minVal;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$4, x1$1);
                        if (tuple22 == null) break block2;
                        Tuple2 tuple23 = (Tuple2)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple23 == null) break block2;
                        minVal = (Option)tuple23._1();
                        maxVal = (Option)tuple23._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                Attribute attr = (Attribute)tuple2._1();
                int childIndex = tuple2._2$mcI$sp();
                ColumnStat colStat = (ColumnStat)((LogicalPlanStats)union.children().apply(childIndex)).stats().attributeStats().apply(attr);
                Option min = minVal.isEmpty() || BoxesRunTime.unboxToBoolean((Object)statComparator.apply(colStat.min().get(), minVal.get())) ? colStat.min() : minVal;
                Option max = maxVal.isEmpty() || BoxesRunTime.unboxToBoolean((Object)statComparator.apply(maxVal.get(), colStat.max().get())) ? colStat.max() : maxVal;
                Tuple2 tuple24 = new Tuple2((Object)min, max);
                return tuple24;
            });
            Option x$1 = (Option)minMaxValue._1();
            Option x$2 = (Option)minMaxValue._2();
            Option<BigInt> x$3 = ColumnStat$.MODULE$.apply$default$1();
            Option<BigInt> x$4 = ColumnStat$.MODULE$.apply$default$4();
            Option<Object> x$5 = ColumnStat$.MODULE$.apply$default$5();
            Option<Object> x$6 = ColumnStat$.MODULE$.apply$default$6();
            Option<Histogram> x$7 = ColumnStat$.MODULE$.apply$default$7();
            int x$8 = ColumnStat$.MODULE$.apply$default$8();
            ColumnStat newStat = new ColumnStat(x$3, (Option<Object>)x$1, (Option<Object>)x$2, x$4, x$5, x$6, x$7, x$8);
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(unionOutput.apply(outputIndex)), (Object)newStat);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple2<Attribute, ColumnStat>> computeNullCountStats(Union union) {
        Seq<Attribute> unionOutput = union.output();
        Seq attrToComputeNullCount = (Seq)((TraversableLike)((IterableLike)((GenericTraversableTemplate)union.children().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.output(), Seq$.MODULE$.canBuildFrom())).transpose((Function1)Predef$.MODULE$.$conforms())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)UnionEstimation$.$anonfun$computeNullCountStats$2(union, x0$1)));
        return (Seq)attrToComputeNullCount.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq attrs2 = (Seq)tuple2._1();
            int outputIndex = tuple2._2$mcI$sp();
            ColumnStat firstStat = (ColumnStat)((LogicalPlanStats)union.children().head()).stats().attributeStats().apply(attrs2.head());
            BigInt firstNullCount = (BigInt)firstStat.nullCount().get();
            BigInt colWithNullStatValues = (BigInt)((TraversableOnce)((TraversableLike)attrs2.zipWithIndex(Seq$.MODULE$.canBuildFrom())).tail()).foldLeft((Object)firstNullCount, (Function2 & Serializable & scala.Serializable)(x0$4, x1$1) -> {
                Tuple2 tuple2;
                BigInt totalNullCount;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$4, x1$1);
                        if (tuple22 == null) break block2;
                        totalNullCount = (BigInt)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                Attribute attr = (Attribute)tuple2._1();
                int childIndex = tuple2._2$mcI$sp();
                ColumnStat colStat = (ColumnStat)((LogicalPlanStats)union.children().apply(childIndex)).stats().attributeStats().apply(attr);
                BigInt bigInt = totalNullCount.$plus((BigInt)colStat.nullCount().get());
                return bigInt;
            });
            Some x$1 = new Some((Object)colWithNullStatValues);
            Option<BigInt> x$2 = ColumnStat$.MODULE$.apply$default$1();
            Option<Object> x$3 = ColumnStat$.MODULE$.apply$default$2();
            Option<Object> x$4 = ColumnStat$.MODULE$.apply$default$3();
            Option<Object> x$5 = ColumnStat$.MODULE$.apply$default$5();
            Option<Object> x$6 = ColumnStat$.MODULE$.apply$default$6();
            Option<Histogram> x$7 = ColumnStat$.MODULE$.apply$default$7();
            int x$8 = ColumnStat$.MODULE$.apply$default$8();
            ColumnStat newStat = new ColumnStat(x$2, x$3, x$4, (Option<BigInt>)x$1, x$5, x$6, x$7, x$8);
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(unionOutput.apply(outputIndex)), (Object)newStat);
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$createStatComparator$1(Object a, Object b) {
        return ByteType$.MODULE$.ordering().lt((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)a)), (Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)b)));
    }

    public static final /* synthetic */ boolean $anonfun$createStatComparator$2(Object a, Object b) {
        return ShortType$.MODULE$.ordering().lt((Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)a)), (Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)b)));
    }

    public static final /* synthetic */ boolean $anonfun$createStatComparator$3(Object a, Object b) {
        return IntegerType$.MODULE$.ordering().lt((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)a)), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)b)));
    }

    public static final /* synthetic */ boolean $anonfun$createStatComparator$4(Object a, Object b) {
        return LongType$.MODULE$.ordering().lt((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)a)), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)b)));
    }

    public static final /* synthetic */ boolean $anonfun$createStatComparator$5(Object a, Object b) {
        return FloatType$.MODULE$.ordering().lt((Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)a)), (Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)b)));
    }

    public static final /* synthetic */ boolean $anonfun$createStatComparator$6(Object a, Object b) {
        return DoubleType$.MODULE$.ordering().lt((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)a)), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)b)));
    }

    public static final /* synthetic */ boolean $anonfun$createStatComparator$7(DataType dt$1, Object a, Object b) {
        return ((DecimalType)dt$1).ordering().lt((Decimal)a, (Decimal)b);
    }

    public static final /* synthetic */ boolean $anonfun$createStatComparator$8(Object a, Object b) {
        return DateType$.MODULE$.ordering().lt((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)a)), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)b)));
    }

    public static final /* synthetic */ boolean $anonfun$createStatComparator$9(Object a, Object b) {
        return TimestampType$.MODULE$.ordering().lt((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)a)), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)b)));
    }

    public static final /* synthetic */ boolean $anonfun$createStatComparator$10(Object a, Object b) {
        return TimestampNTZType$.MODULE$.ordering().lt((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)a)), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)b)));
    }

    public static final /* synthetic */ boolean $anonfun$createStatComparator$11(AnsiIntervalType x12$1, Object a, Object b) {
        return x12$1.ordering().lt(a, b);
    }

    public static final /* synthetic */ boolean $anonfun$computeMinMaxStats$3(Union union$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Attribute attr = (Attribute)tuple2._1();
        int childIndex = tuple2._2$mcI$sp();
        AttributeMap<ColumnStat> attrStats = ((LogicalPlanStats)union$1.children().apply(childIndex)).stats().attributeStats();
        boolean bl = attrStats.get(attr).isDefined() && ((ColumnStat)attrStats.apply(attr)).hasMinMaxStats();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$computeMinMaxStats$2(Seq unionOutput$1, Union union$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq attrs2 = (Seq)tuple2._1();
        int outputIndex = tuple2._2$mcI$sp();
        boolean bl = MODULE$.isTypeSupported(((Expression)unionOutput$1.apply(outputIndex)).dataType()) && ((IterableLike)attrs2.zipWithIndex(Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)UnionEstimation$.$anonfun$computeMinMaxStats$3(union$1, x0$2)));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$computeNullCountStats$3(Union union$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Attribute attr = (Attribute)tuple2._1();
        int childIndex = tuple2._2$mcI$sp();
        AttributeMap<ColumnStat> attrStats = ((LogicalPlanStats)union$2.children().apply(childIndex)).stats().attributeStats();
        boolean bl = attrStats.get(attr).isDefined() && ((ColumnStat)attrStats.apply(attr)).nullCount().isDefined();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$computeNullCountStats$2(Union union$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq attrs2 = (Seq)tuple2._1();
        boolean bl = ((IterableLike)attrs2.zipWithIndex(Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)UnionEstimation$.$anonfun$computeNullCountStats$3(union$2, x0$2)));
        return bl;
    }

    private UnionEstimation$() {
        MODULE$ = this;
    }
}

