/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table;

import org.apache.amoro.ServerTableIdentifier;
import org.apache.amoro.metrics.Counter;
import org.apache.amoro.metrics.Metric;
import org.apache.amoro.metrics.MetricDefine;
import org.apache.amoro.server.metrics.MetricRegistry;
import org.apache.amoro.server.table.AbstractTableMetrics;

public class TableOrphanFilesCleaningMetrics
extends AbstractTableMetrics {
    private final Counter orphanDataFilesCount = new Counter();
    private final Counter expectedOrphanDataFilesCount = new Counter();
    private final Counter orphanMetadataFilesCount = new Counter();
    private final Counter expectedOrphanMetadataFilesCount = new Counter();
    public static final MetricDefine TABLE_ORPHAN_CONTENT_FILE_CLEANING_COUNT = MetricDefine.defineCounter((String)"table_orphan_content_file_cleaning_count").withDescription("Count of orphan content files cleaned in the table since ams started").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_ORPHAN_METADATA_FILE_CLEANING_COUNT = MetricDefine.defineCounter((String)"table_orphan_metadata_file_cleaning_count").withDescription("Count of orphan metadata files cleaned in the table since ams started").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_EXPECTED_ORPHAN_CONTENT_FILE_CLEANING_COUNT = MetricDefine.defineCounter((String)"table_expected_orphan_content_file_cleaning_count").withDescription("Expected count of orphan content files cleaned in the table since ams started").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_EXPECTED_ORPHAN_METADATA_FILE_CLEANING_COUNT = MetricDefine.defineCounter((String)"table_expected_orphan_metadata_file_cleaning_count").withDescription("Expected count of orphan metadata files cleaned in the table since ams started").withTags(new String[]{"catalog", "database", "table"}).build();

    public TableOrphanFilesCleaningMetrics(ServerTableIdentifier identifier) {
        super(identifier);
    }

    @Override
    public void registerMetrics(MetricRegistry registry) {
        if (this.globalRegistry == null) {
            this.registerMetric(registry, TABLE_ORPHAN_CONTENT_FILE_CLEANING_COUNT, (Metric)this.orphanDataFilesCount);
            this.registerMetric(registry, TABLE_ORPHAN_METADATA_FILE_CLEANING_COUNT, (Metric)this.orphanMetadataFilesCount);
            this.registerMetric(registry, TABLE_EXPECTED_ORPHAN_CONTENT_FILE_CLEANING_COUNT, (Metric)this.expectedOrphanDataFilesCount);
            this.registerMetric(registry, TABLE_EXPECTED_ORPHAN_METADATA_FILE_CLEANING_COUNT, (Metric)this.expectedOrphanMetadataFilesCount);
            this.globalRegistry = registry;
        }
    }

    public void completeOrphanDataFiles(int expected, int cleaned) {
        this.expectedOrphanMetadataFilesCount.inc((long)expected);
        this.orphanDataFilesCount.inc((long)cleaned);
    }

    public void completeOrphanMetadataFiles(int expected, int cleaned) {
        this.expectedOrphanMetadataFilesCount.inc((long)expected);
        this.orphanMetadataFilesCount.inc((long)cleaned);
    }
}

