/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.persistence;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.amoro.exception.AmoroRuntimeException;
import org.apache.amoro.exception.PersistenceException;
import org.apache.amoro.server.persistence.NestedSqlSession;
import org.apache.amoro.server.persistence.SqlSessionFactoryProvider;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.ibatis.session.TransactionIsolationLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistentBase {
    private static final Logger LOG = LoggerFactory.getLogger(PersistentBase.class);

    protected PersistentBase() {
    }

    @VisibleForTesting
    protected NestedSqlSession beginSession() {
        return NestedSqlSession.openSession(() -> SqlSessionFactoryProvider.getInstance().get().openSession(TransactionIsolationLevel.READ_COMMITTED));
    }

    public final <T> Long updateAs(Class<T> mapperClz, Function<T, Number> updateFunction) {
        Throwable throwable = null;
        try (NestedSqlSession session = this.beginSession();){
            T mapper = PersistentBase.getMapper(session, mapperClz);
            Number number = updateFunction.apply(mapper);
            session.commit();
            Long l = number.longValue();
            return l;
        }
        catch (Throwable t) {
            try {
                session.rollback();
                throw AmoroRuntimeException.wrap((Throwable)t, PersistenceException::new);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    protected final <T> void doAs(Class<T> mapperClz, Consumer<T> consumer) {
        try (NestedSqlSession session = this.beginSession();){
            try {
                T mapper = PersistentBase.getMapper(session, mapperClz);
                consumer.accept(mapper);
                session.commit();
            }
            catch (Throwable t) {
                session.rollback();
                throw AmoroRuntimeException.wrap((Throwable)t, PersistenceException::new);
            }
        }
    }

    protected final <T> void doAsIgnoreError(Class<T> mapperClz, Consumer<T> consumer) {
        try (NestedSqlSession session = this.beginSession();){
            try {
                T mapper = PersistentBase.getMapper(session, mapperClz);
                consumer.accept(mapper);
                session.commit();
            }
            catch (Throwable t) {
                LOG.error("Ignore error in doAsIgnoreError", t);
            }
        }
    }

    protected final void doAsTransaction(Runnable ... operations) {
        try (NestedSqlSession session = this.beginSession();){
            try {
                Arrays.stream(operations).forEach(Runnable::run);
                session.commit();
            }
            catch (Throwable t) {
                session.rollback();
                throw AmoroRuntimeException.wrap((Throwable)t, PersistenceException::new);
            }
        }
    }

    protected final <T, R> R getAs(Class<T> mapperClz, Function<T, R> func) {
        Throwable throwable = null;
        try (NestedSqlSession session = this.beginSession();){
            T mapper = PersistentBase.getMapper(session, mapperClz);
            R r = func.apply(mapper);
            return r;
        }
        catch (Throwable t) {
            try {
                throw AmoroRuntimeException.wrap((Throwable)t, PersistenceException::new);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    protected final <T> void doAsExisted(Class<T> mapperClz, Function<T, Integer> func, Supplier<? extends AmoroRuntimeException> errorSupplier) {
        try (NestedSqlSession session = this.beginSession();){
            try {
                int result = func.apply(PersistentBase.getMapper(session, mapperClz));
                if (result == 0) {
                    throw errorSupplier.get();
                }
                session.commit();
            }
            catch (Throwable t) {
                session.rollback();
                throw AmoroRuntimeException.wrap((Throwable)t, PersistenceException::new);
            }
        }
    }

    protected static <T> T getMapper(NestedSqlSession sqlSession, Class<T> type) {
        Preconditions.checkNotNull((Object)sqlSession);
        return (T)sqlSession.getSqlSession().getMapper(type);
    }
}

