/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils.map;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.amoro.AmoroIOException;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.utils.LocalFileUtil;
import org.apache.amoro.utils.SerializationUtil;
import org.rocksdb.AbstractImmutableNativeReference;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.MutableColumnFamilyOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Statistics;
import org.rocksdb.TtlDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBBackend {
    private static final Logger LOG = LoggerFactory.getLogger(RocksDBBackend.class);
    private static final String BACKEND_BASE_DIR = System.getProperty("java.io.tmpdir");
    private static final ThreadLocal<RocksDBBackend> instance = new ThreadLocal();
    private final Map<String, ColumnFamilyHandle> handleMap = new HashMap<String, ColumnFamilyHandle>();
    private final Map<String, ColumnFamilyDescriptor> descriptorMap = new HashMap<String, ColumnFamilyDescriptor>();
    private RocksDB rocksDB;
    private boolean closed = false;
    private final String rocksDBBasePath;
    private long totalBytesWritten;

    public static RocksDBBackend getOrCreateInstance() {
        Preconditions.checkNotNull((Object)BACKEND_BASE_DIR, (Object)"The default rocksdb path is null.");
        return RocksDBBackend.getOrCreateInstance(BACKEND_BASE_DIR);
    }

    public static RocksDBBackend getOrCreateInstance(@Nullable String backendBaseDir) {
        if (backendBaseDir == null) {
            Preconditions.checkNotNull((Object)BACKEND_BASE_DIR, (Object)"The default rocksdb path is null.");
            return RocksDBBackend.getOrCreateInstance(BACKEND_BASE_DIR);
        }
        return RocksDBBackend.createIfAbsent(backendBaseDir, null);
    }

    public static RocksDBBackend getOrCreateInstance(@Nullable String backendBaseDir, @Nullable Integer ttlSeconds) {
        if (backendBaseDir == null) {
            Preconditions.checkNotNull((Object)BACKEND_BASE_DIR, (Object)"The default rocksdb path is null.");
            return RocksDBBackend.getOrCreateInstance(BACKEND_BASE_DIR, ttlSeconds);
        }
        return RocksDBBackend.createIfAbsent(backendBaseDir, ttlSeconds);
    }

    private static RocksDBBackend createIfAbsent(@Nullable String backendBaseDir, @Nullable Integer ttlSeconds) {
        RocksDBBackend backend = instance.get();
        if (backend == null) {
            backend = new RocksDBBackend(backendBaseDir, ttlSeconds);
            instance.set(backend);
        }
        if (backend.closed) {
            backend = new RocksDBBackend(backendBaseDir, ttlSeconds);
            instance.set(backend);
        }
        return backend;
    }

    private RocksDBBackend(@Nullable String backendBaseDir, @Nullable Integer ttlSeconds) {
        this.rocksDBBasePath = backendBaseDir == null ? UUID.randomUUID().toString() : String.format("%s/%s", backendBaseDir, UUID.randomUUID());
        this.totalBytesWritten = 0L;
        this.setup(ttlSeconds);
    }

    private void setup(@Nullable Integer ttlSeconds) {
        try {
            List<ColumnFamilyDescriptor> managedColumnFamilies;
            LOG.info("DELETING RocksDB instance persisted at {}", (Object)this.rocksDBBasePath);
            LocalFileUtil.deleteDirectory((File)new File(this.rocksDBBasePath));
            DBOptions dbOptions = new DBOptions().setCreateIfMissing(true).setCreateMissingColumnFamilies(true).setWalDir(this.rocksDBBasePath).setStatsDumpPeriodSec(300).setStatistics(new Statistics());
            dbOptions.setLogger(new org.rocksdb.Logger(dbOptions){

                protected void log(InfoLogLevel infoLogLevel, String logMsg) {
                    LOG.debug("From Rocks DB : {}", (Object)logMsg);
                }
            });
            ArrayList managedHandles = new ArrayList();
            LocalFileUtil.mkdir((File)new File(this.rocksDBBasePath));
            if (ttlSeconds != null && ttlSeconds > 0) {
                Options ttlDBOptions = new Options(dbOptions, new ColumnFamilyOptions());
                this.rocksDB = TtlDB.open((Options)ttlDBOptions, (String)this.rocksDBBasePath, (int)ttlSeconds, (boolean)false);
                managedColumnFamilies = new ArrayList<ColumnFamilyDescriptor>();
            } else {
                managedColumnFamilies = this.loadManagedColumnFamilies(dbOptions);
                this.rocksDB = RocksDB.open((DBOptions)dbOptions, (String)this.rocksDBBasePath, managedColumnFamilies, managedHandles);
            }
            Preconditions.checkArgument((managedHandles.size() == managedColumnFamilies.size() ? 1 : 0) != 0, (Object)"Unexpected number of handles are returned");
            for (int index = 0; index < managedHandles.size(); ++index) {
                ColumnFamilyHandle handle = (ColumnFamilyHandle)managedHandles.get(index);
                ColumnFamilyDescriptor descriptor = managedColumnFamilies.get(index);
                String familyNameFromHandle = new String(handle.getName());
                String familyNameFromDescriptor = new String(descriptor.getName());
                Preconditions.checkArgument((boolean)familyNameFromDescriptor.equals(familyNameFromHandle), (Object)"Family Handles not in order with descriptors");
                this.handleMap.put(familyNameFromHandle, handle);
                this.descriptorMap.put(familyNameFromDescriptor, descriptor);
            }
            this.addShutDownHook();
        }
        catch (IOException | RocksDBException re) {
            LOG.error("Got exception opening Rocks DB instance ", re);
            if (this.rocksDB != null) {
                this.close();
            }
            throw new AmoroIOException(re);
        }
    }

    private void addShutDownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
    }

    private List<ColumnFamilyDescriptor> loadManagedColumnFamilies(DBOptions dbOptions) throws RocksDBException {
        ArrayList<ColumnFamilyDescriptor> managedColumnFamilies = new ArrayList<ColumnFamilyDescriptor>();
        Options options = new Options(dbOptions, new ColumnFamilyOptions());
        List existing = RocksDB.listColumnFamilies((Options)options, (String)this.rocksDBBasePath);
        if (existing.isEmpty()) {
            LOG.info("No column family found. Loading default");
            managedColumnFamilies.add(this.getColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY));
        } else {
            LOG.info("Loading column families :" + existing.stream().map(String::new).collect(Collectors.toList()));
            managedColumnFamilies.addAll(existing.stream().map(this::getColumnFamilyDescriptor).collect(Collectors.toList()));
        }
        return managedColumnFamilies;
    }

    private ColumnFamilyDescriptor getColumnFamilyDescriptor(byte[] columnFamilyName) {
        return new ColumnFamilyDescriptor(columnFamilyName, new ColumnFamilyOptions());
    }

    private ColumnFamilyDescriptor getColumnFamilyDescriptor(byte[] columnFamilyName, ColumnFamilyOptions columnFamilyOptions) {
        return new ColumnFamilyDescriptor(columnFamilyName, columnFamilyOptions);
    }

    @VisibleForTesting
    public <K extends Serializable, T extends Serializable> void put(String columnFamilyName, K key, T value) {
        try {
            Preconditions.checkArgument((key != null && value != null ? 1 : 0) != 0, (Object)"values or keys in rocksdb can not be null!");
            byte[] payload = this.serializePayload(value);
            this.rocksDB.put(this.handleMap.get(columnFamilyName), SerializationUtil.kryoSerialize(key), payload);
        }
        catch (Exception e) {
            throw new AmoroIOException((Throwable)e);
        }
    }

    public void put(String columnFamilyName, byte[] key, byte[] value) {
        try {
            Preconditions.checkArgument((key != null && value != null ? 1 : 0) != 0, (Object)"values or keys in rocksdb can not be null!");
            ColumnFamilyHandle cfHandler = this.handleMap.get(columnFamilyName);
            Preconditions.checkArgument((cfHandler != null ? 1 : 0) != 0, (Object)("column family " + columnFamilyName + " does not exists in rocksdb"));
            this.rocksDB.put(cfHandler, key, this.payload(value));
        }
        catch (Exception e) {
            throw new AmoroIOException((Throwable)e);
        }
    }

    public void put(ColumnFamilyHandle columnFamilyHandle, byte[] key, byte[] value) {
        try {
            Preconditions.checkArgument((key != null && value != null ? 1 : 0) != 0, (Object)"values or keys in rocksdb can not be null!");
            Preconditions.checkArgument((columnFamilyHandle != null ? 1 : 0) != 0, (Object)"Column family handler couldn't be null.");
            this.rocksDB.put(columnFamilyHandle, key, this.payload(value));
        }
        catch (Exception e) {
            throw new AmoroIOException((Throwable)e);
        }
    }

    @VisibleForTesting
    public <K extends Serializable> void delete(String columnFamilyName, K key) {
        try {
            Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"keys in rocksdb can not be null!");
            this.rocksDB.delete(this.handleMap.get(columnFamilyName), SerializationUtil.kryoSerialize(key));
        }
        catch (Exception e) {
            throw new AmoroIOException((Throwable)e);
        }
    }

    public void delete(String columnFamilyName, byte[] key) {
        try {
            Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"keys in rocksdb can not be null!");
            this.rocksDB.delete(this.handleMap.get(columnFamilyName), key);
        }
        catch (Exception e) {
            throw new AmoroIOException((Throwable)e);
        }
    }

    @VisibleForTesting
    public <K extends Serializable, T extends Serializable> T get(String columnFamilyName, K key) {
        Preconditions.checkArgument((!this.closed ? 1 : 0) != 0);
        try {
            Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"keys in rocksdb can not be null!");
            byte[] val = this.rocksDB.get(this.handleMap.get(columnFamilyName), SerializationUtil.kryoSerialize(key));
            return (T)(val == null ? null : (Serializable)SerializationUtil.kryoDeserialize((byte[])val));
        }
        catch (Exception e) {
            throw new AmoroIOException((Throwable)e);
        }
    }

    public byte[] get(String columnFamilyName, byte[] key) {
        Preconditions.checkArgument((!this.closed ? 1 : 0) != 0);
        try {
            Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"keys in rocksdb can not be null!");
            return this.rocksDB.get(this.handleMap.get(columnFamilyName), key);
        }
        catch (Exception e) {
            throw new AmoroIOException((Throwable)e);
        }
    }

    public byte[] get(ColumnFamilyHandle columnFamilyHandle, byte[] key) {
        Preconditions.checkArgument((!this.closed ? 1 : 0) != 0);
        try {
            Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"keys in rocksdb can not be null!");
            Preconditions.checkNotNull((Object)columnFamilyHandle, (Object)"Column Family Handle couldn't be null!");
            return this.rocksDB.get(columnFamilyHandle, key);
        }
        catch (Exception e) {
            throw new AmoroIOException((Throwable)e);
        }
    }

    public RocksDB getDB() {
        return this.rocksDB;
    }

    @VisibleForTesting
    public <T extends Serializable> Iterator<T> valuesForTest(String columnFamilyName) {
        return new ValueIteratorForTest(this.rocksDB.newIterator(this.handleMap.get(columnFamilyName)));
    }

    public Iterator<byte[]> values(String columnFamilyName) {
        return new ValueIterator(this.rocksDB.newIterator(this.handleMap.get(columnFamilyName)));
    }

    public Iterator<byte[]> values(String columnFamilyName, byte[] seekOffset) {
        return new ValueIterator(this.rocksDB.newIterator(this.handleMap.get(columnFamilyName)), seekOffset);
    }

    public void addColumnFamily(String columnFamilyName) {
        this.addColumnFamily(columnFamilyName, new ColumnFamilyOptions());
    }

    public void addColumnFamily(String columnFamilyName, ColumnFamilyOptions columnFamilyOptions) {
        Preconditions.checkArgument((!this.closed ? 1 : 0) != 0);
        this.descriptorMap.computeIfAbsent(columnFamilyName, colFamilyName -> {
            try {
                ColumnFamilyDescriptor descriptor = this.getColumnFamilyDescriptor(colFamilyName.getBytes(), columnFamilyOptions);
                ColumnFamilyHandle handle = this.rocksDB.createColumnFamily(descriptor);
                this.handleMap.put((String)colFamilyName, handle);
                return descriptor;
            }
            catch (RocksDBException e) {
                throw new AmoroIOException((Throwable)e);
            }
        });
    }

    public void dropColumnFamily(String columnFamilyName) {
        Preconditions.checkArgument((!this.closed ? 1 : 0) != 0);
        this.descriptorMap.computeIfPresent(columnFamilyName, (colFamilyName, descriptor) -> {
            ColumnFamilyHandle handle = this.handleMap.get(colFamilyName);
            try {
                this.rocksDB.dropColumnFamily(handle);
                handle.close();
            }
            catch (RocksDBException e) {
                throw new AmoroIOException((Throwable)e);
            }
            this.handleMap.remove(columnFamilyName);
            return null;
        });
    }

    public List<ColumnFamilyDescriptor> listColumnFamilies() {
        return new ArrayList<ColumnFamilyDescriptor>(this.descriptorMap.values());
    }

    public ColumnFamilyHandle getColumnFamilyHandle(String columnFamilyName) {
        return this.handleMap.get(columnFamilyName);
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.handleMap.values().forEach(AbstractImmutableNativeReference::close);
            this.handleMap.clear();
            this.descriptorMap.clear();
            this.rocksDB.close();
            try {
                LocalFileUtil.deleteDirectory((File)new File(this.rocksDBBasePath));
            }
            catch (IOException e) {
                throw new AmoroIOException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getRocksDBBasePath() {
        return this.rocksDBBasePath;
    }

    public long getTotalBytesWritten() {
        return this.totalBytesWritten;
    }

    private byte[] serializePayload(Object value) throws IOException {
        byte[] payload = SerializationUtil.kryoSerialize((Object)value);
        this.totalBytesWritten += (long)payload.length;
        return payload;
    }

    private byte[] payload(byte[] value) {
        this.totalBytesWritten += (long)value.length;
        return value;
    }

    public void setOptions(ColumnFamilyHandle columnFamilyHandle, MutableColumnFamilyOptions mutableColumnFamilyOptions) {
        Preconditions.checkNotNull((Object)columnFamilyHandle);
        Preconditions.checkNotNull((Object)mutableColumnFamilyOptions);
        try {
            this.rocksDB.setOptions(columnFamilyHandle, mutableColumnFamilyOptions);
        }
        catch (RocksDBException e) {
            throw new AmoroIOException((Throwable)e);
        }
    }

    public static class ValueIterator
    implements Iterator<byte[]>,
    AutoCloseable {
        private final RocksIterator iterator;

        public ValueIterator(RocksIterator iterator) {
            this.iterator = iterator;
            iterator.seekToFirst();
        }

        public ValueIterator(RocksIterator iterator, byte[] seekOffset) {
            this.iterator = iterator;
            iterator.seek(seekOffset);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.isValid();
        }

        @Override
        public byte[] next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("next() called on rocksDB with no more valid entries");
            }
            byte[] val = this.iterator.value();
            this.iterator.next();
            return val;
        }

        public byte[] key() {
            return this.iterator.key();
        }

        @Override
        public void close() throws Exception {
            if (this.iterator != null) {
                this.iterator.close();
            }
        }
    }

    private static class ValueIteratorForTest<R>
    implements Iterator<R> {
        private final RocksIterator iterator;

        public ValueIteratorForTest(RocksIterator iterator) {
            this.iterator = iterator;
            iterator.seekToFirst();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.isValid();
        }

        @Override
        public R next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("next() called on rocksDB with no more valid entries");
            }
            Object val = SerializationUtil.kryoDeserialize((byte[])this.iterator.value());
            this.iterator.next();
            return (R)val;
        }
    }
}

