/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.op.MixedHadoopTableOperations;
import org.apache.amoro.op.MixedTableOperations;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.CachingCatalog;
import org.apache.iceberg.CatalogProperties;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.aws.glue.GlueCatalog;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.hadoop.HadoopTableOperations;
import org.apache.iceberg.rest.RESTCatalog;
import org.apache.iceberg.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixedFormatCatalogUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MixedFormatCatalogUtil.class);

    public static void mergeCatalogProperties(CatalogMeta meta, Map<String, String> properties) {
        if (meta.getCatalogProperties() == null) {
            meta.setCatalogProperties((Map)Maps.newHashMap());
        }
        if (properties != null) {
            properties.forEach((arg_0, arg_1) -> ((CatalogMeta)meta).putToCatalogProperties(arg_0, arg_1));
        }
    }

    public static Map<String, String> withIcebergCatalogInitializeProperties(String catalogName, String metastoreType, Map<String, String> properties) {
        HashMap icebergCatalogProperties = Maps.newHashMap(properties);
        icebergCatalogProperties.put("type", metastoreType);
        if ("glue".equals(metastoreType)) {
            icebergCatalogProperties.put("catalog-impl", GlueCatalog.class.getName());
        }
        if ("ams".equalsIgnoreCase(metastoreType)) {
            icebergCatalogProperties.put("warehouse", catalogName);
            if (!icebergCatalogProperties.containsKey("catalog-impl")) {
                icebergCatalogProperties.put("catalog-impl", RESTCatalog.class.getName());
            }
        }
        if ("custom".equalsIgnoreCase(metastoreType)) {
            Preconditions.checkArgument((boolean)icebergCatalogProperties.containsKey("catalog-impl"), (Object)"Custom catalog properties must contains catalog-impl");
        }
        if (icebergCatalogProperties.containsKey("catalog-impl")) {
            icebergCatalogProperties.remove("type");
        }
        return icebergCatalogProperties;
    }

    public static Table useMixedTableOperations(Table table, String tableLocation, AuthenticatedFileIO authenticatedFileIO, Configuration configuration) {
        if (table instanceof BaseTable) {
            BaseTable baseTable = (BaseTable)table;
            if (baseTable.operations() instanceof MixedHadoopTableOperations) {
                return table;
            }
            if (baseTable.operations() instanceof MixedTableOperations) {
                return table;
            }
            if (baseTable.operations() instanceof HadoopTableOperations) {
                return new BaseTable((TableOperations)new MixedHadoopTableOperations(new Path(tableLocation), authenticatedFileIO, configuration), table.name());
            }
            return new BaseTable((TableOperations)new MixedTableOperations(((BaseTable)table).operations(), authenticatedFileIO), table.name());
        }
        return table;
    }

    public static Map<String, String> mergeCatalogPropertiesToTable(Map<String, String> tableProperties, Map<String, String> catalogProperties) {
        String optimizationEnabled;
        Map<String, String> mergedProperties = catalogProperties.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("table.")).collect(Collectors.toMap(e -> ((String)e.getKey()).substring("table.".length()), Map.Entry::getValue));
        if (!PropertyUtil.propertyAsBoolean(tableProperties, (String)"log-store.enabled", (boolean)false)) {
            mergedProperties = mergedProperties.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("log-store.")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        if (!Boolean.parseBoolean(optimizationEnabled = tableProperties.getOrDefault("self-optimizing.enabled", mergedProperties.getOrDefault("self-optimizing.enabled", String.valueOf(true))))) {
            mergedProperties = mergedProperties.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("self-optimizing.")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            mergedProperties.put("self-optimizing.enabled", optimizationEnabled);
        }
        mergedProperties.putAll(tableProperties);
        return mergedProperties;
    }

    public static Catalog buildCacheCatalog(Catalog catalog, Map<String, String> properties) {
        boolean cacheEnabled = PropertyUtil.propertyAsBoolean(properties, (String)"cache-enabled", (boolean)true);
        boolean cacheCaseSensitive = PropertyUtil.propertyAsBoolean(properties, (String)"cache.case-sensitive", (boolean)true);
        long cacheExpirationIntervalMs = PropertyUtil.propertyAsLong(properties, (String)"cache.expiration-interval-ms", (long)CatalogProperties.CACHE_EXPIRATION_INTERVAL_MS_DEFAULT);
        if (cacheExpirationIntervalMs <= 0L) {
            LOG.warn("Configuration `{}` is {}, less than or equal to 0, then the cache will not take effect.", (Object)"cache.expiration-interval-ms", (Object)cacheExpirationIntervalMs);
            cacheEnabled = false;
        }
        return cacheEnabled ? CachingCatalog.wrap((Catalog)catalog, (boolean)cacheCaseSensitive, (long)cacheExpirationIntervalMs) : catalog;
    }
}

