/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.optimizing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.amoro.data.DefaultKeyedFile;
import org.apache.amoro.data.PrimaryKeyedFile;
import org.apache.amoro.optimizing.BaseOptimizingInput;
import org.apache.amoro.shade.guava32.com.google.common.base.MoreObjects;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.utils.ContentFiles;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;

public class RewriteFilesInput
extends BaseOptimizingInput {
    private static final long serialVersionUID = -696610318564333923L;
    private final DataFile[] rewrittenDataFiles;
    private final DataFile[] rePosDeletedDataFiles;
    private final ContentFile<?>[] readOnlyDeleteFiles;
    private final ContentFile<?>[] rewrittenDeleteFiles;
    private final MixedTable table;

    public RewriteFilesInput(DataFile[] rewrittenDataFiles, DataFile[] rePosDeletedDataFiles, ContentFile<?>[] readOnlyDeleteFiles, ContentFile<?>[] rewrittenDeleteFiles, MixedTable table) {
        this.rewrittenDataFiles = rewrittenDataFiles;
        this.rePosDeletedDataFiles = rePosDeletedDataFiles;
        this.readOnlyDeleteFiles = readOnlyDeleteFiles;
        this.rewrittenDeleteFiles = rewrittenDeleteFiles;
        this.table = table;
    }

    public DataFile[] rewrittenDataFiles() {
        return this.rewrittenDataFiles;
    }

    public DataFile[] rePosDeletedDataFiles() {
        return this.rePosDeletedDataFiles;
    }

    public ContentFile<?>[] readOnlyDeleteFiles() {
        return this.readOnlyDeleteFiles;
    }

    public ContentFile<?>[] rewrittenDeleteFiles() {
        return this.rewrittenDeleteFiles;
    }

    public List<PrimaryKeyedFile> rewrittenDataFilesForMixed() {
        if (this.rewrittenDataFiles == null) {
            return null;
        }
        return Arrays.stream(this.rewrittenDataFiles).map(s -> (DefaultKeyedFile)s).collect(Collectors.toList());
    }

    public List<PrimaryKeyedFile> rePosDeletedDataFilesForMixed() {
        if (this.rePosDeletedDataFiles == null) {
            return null;
        }
        return Arrays.stream(this.rePosDeletedDataFiles).map(s -> (DefaultKeyedFile)s).collect(Collectors.toList());
    }

    public List<DeleteFile> positionDeleteForMixed() {
        return Arrays.stream(this.deleteFiles()).filter(s -> s instanceof DeleteFile).map(ContentFiles::asDeleteFile).collect(Collectors.toList());
    }

    public List<PrimaryKeyedFile> equalityDeleteForMixed() {
        return Arrays.stream(this.deleteFiles()).filter(s -> s instanceof DataFile).map(s -> (PrimaryKeyedFile)s).collect(Collectors.toList());
    }

    public ContentFile<?>[] readOnlyDeleteFilesForMixed() {
        return this.readOnlyDeleteFiles;
    }

    public ContentFile<?>[] rewrittenDeleteFilesForMixed() {
        return this.rewrittenDeleteFiles;
    }

    public ContentFile<?>[] deleteFiles() {
        ArrayList list = new ArrayList();
        if (this.readOnlyDeleteFiles != null) {
            list.addAll(Arrays.asList(this.readOnlyDeleteFiles));
        }
        if (this.rewrittenDeleteFiles != null) {
            list.addAll(Arrays.asList(this.rewrittenDeleteFiles));
        }
        return list.toArray(new ContentFile[0]);
    }

    public DataFile[] dataFiles() {
        ArrayList<DataFile> list = new ArrayList<DataFile>();
        if (this.rewrittenDataFiles != null) {
            list.addAll(Arrays.asList(this.rewrittenDataFiles));
        }
        if (this.rePosDeletedDataFiles != null) {
            list.addAll(Arrays.asList(this.rePosDeletedDataFiles));
        }
        return list.toArray(new DataFile[0]);
    }

    public ContentFile<?>[] allFiles() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.rewrittenDataFiles != null) {
            list.addAll(Arrays.asList(this.rewrittenDataFiles));
        }
        if (this.rePosDeletedDataFiles != null) {
            list.addAll(Arrays.asList(this.rePosDeletedDataFiles));
        }
        if (this.readOnlyDeleteFiles != null) {
            list.addAll(Arrays.asList(this.readOnlyDeleteFiles));
        }
        if (this.rewrittenDeleteFiles != null) {
            list.addAll(Arrays.asList(this.rewrittenDeleteFiles));
        }
        return list.toArray(new ContentFile[0]);
    }

    public MixedTable getTable() {
        return this.table;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rewrittenDataFilesSize", this.rewrittenDataFiles.length).add("rePosDeletedDataFilesSize", this.rePosDeletedDataFiles.length).add("readOnlyDeleteFilesSize", this.readOnlyDeleteFiles.length).add("rewrittenDeleteFilesSize", this.rewrittenDeleteFiles.length).add("table", (Object)this.table.name()).addValue((Object)super.toString()).toString();
    }
}

