/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized;

import org.apache.arrow.vector.FieldVector;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.arrow.vectorized.NullabilityHolder;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;

public class VectorHolder {
    private final ColumnDescriptor columnDescriptor;
    private final FieldVector vector;
    private final boolean isDictionaryEncoded;
    private final Dictionary dictionary;
    private final NullabilityHolder nullabilityHolder;
    private final Types.NestedField icebergField;

    public VectorHolder(ColumnDescriptor columnDescriptor, FieldVector vector, boolean isDictionaryEncoded, Dictionary dictionary, NullabilityHolder holder, Types.NestedField icebergField) {
        Preconditions.checkNotNull((Object)columnDescriptor, (Object)"ColumnDescriptor cannot be null");
        Preconditions.checkNotNull((Object)vector, (Object)"Vector cannot be null");
        Preconditions.checkNotNull((Object)holder, (Object)"NullabilityHolder cannot be null");
        Preconditions.checkNotNull((Object)icebergField, (Object)"IcebergField cannot be null");
        this.columnDescriptor = columnDescriptor;
        this.vector = vector;
        this.isDictionaryEncoded = isDictionaryEncoded;
        this.dictionary = dictionary;
        this.nullabilityHolder = holder;
        this.icebergField = icebergField;
    }

    private VectorHolder() {
        this((Types.NestedField)null);
    }

    private VectorHolder(Types.NestedField field) {
        this.columnDescriptor = null;
        this.vector = null;
        this.isDictionaryEncoded = false;
        this.dictionary = null;
        this.nullabilityHolder = null;
        this.icebergField = field;
    }

    private VectorHolder(FieldVector vec, Types.NestedField field, NullabilityHolder nulls) {
        this.columnDescriptor = null;
        this.vector = vec;
        this.isDictionaryEncoded = false;
        this.dictionary = null;
        this.nullabilityHolder = nulls;
        this.icebergField = field;
    }

    public ColumnDescriptor descriptor() {
        return this.columnDescriptor;
    }

    public FieldVector vector() {
        return this.vector;
    }

    public boolean isDictionaryEncoded() {
        return this.isDictionaryEncoded;
    }

    public Dictionary dictionary() {
        return this.dictionary;
    }

    public NullabilityHolder nullabilityHolder() {
        return this.nullabilityHolder;
    }

    public Type icebergType() {
        return this.icebergField != null ? this.icebergField.type() : null;
    }

    public Types.NestedField icebergField() {
        return this.icebergField;
    }

    public int numValues() {
        return this.vector.getValueCount();
    }

    public static <T> VectorHolder constantHolder(Types.NestedField icebergField, int numRows, T constantValue) {
        return new ConstantVectorHolder<T>(icebergField, numRows, constantValue);
    }

    public static VectorHolder deletedVectorHolder(int numRows) {
        return new DeletedVectorHolder(numRows);
    }

    public static VectorHolder dummyHolder(int numRows) {
        return new ConstantVectorHolder(numRows);
    }

    public boolean isDummy() {
        return this.vector == null;
    }

    public static class DeletedVectorHolder
    extends VectorHolder {
        private final int numRows;

        public DeletedVectorHolder(int numRows) {
            super(MetadataColumns.IS_DELETED);
            this.numRows = numRows;
        }

        @Override
        public int numValues() {
            return this.numRows;
        }
    }

    public static class PositionVectorHolder
    extends VectorHolder {
        public PositionVectorHolder(FieldVector vector, Types.NestedField icebergField, NullabilityHolder nulls) {
            super(vector, icebergField, nulls);
        }
    }

    public static class ConstantVectorHolder<T>
    extends VectorHolder {
        private final T constantValue;
        private final int numRows;

        public ConstantVectorHolder(int numRows) {
            this.numRows = numRows;
            this.constantValue = null;
        }

        public ConstantVectorHolder(Types.NestedField icebergField, int numRows, T constantValue) {
            super(icebergField);
            this.numRows = numRows;
            this.constantValue = constantValue;
        }

        @Override
        public int numValues() {
            return this.numRows;
        }

        public Object getConstant() {
            return this.constantValue;
        }
    }
}

