/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.watermarkstatus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionIndexSet;
import org.apache.flink.streaming.api.watermark.InternalWatermark;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.PushingAsyncDataInput;
import org.apache.flink.streaming.runtime.io.checkpointing.CheckpointedInputGate;
import org.apache.flink.streaming.runtime.watermarkstatus.HeapPriorityQueue;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.Preconditions;

@Internal
public class StatusWatermarkValve {
    private final List<Map<Integer, SubpartitionStatus>> subpartitionStatuses;
    private final int[] subpartitionIndexes;
    private long lastOutputWatermark;
    private WatermarkStatus lastOutputWatermarkStatus;
    private final HeapPriorityQueue<SubpartitionStatus> alignedSubpartitionStatuses;
    private final boolean isInputChannelShared;

    @VisibleForTesting
    public StatusWatermarkValve(int numInputChannels) {
        this(StatusWatermarkValve.getIndexSets(numInputChannels));
    }

    private static ResultSubpartitionIndexSet[] getIndexSets(int numInputChannels) {
        Object[] subpartitionIndexRanges = new ResultSubpartitionIndexSet[numInputChannels];
        Arrays.fill(subpartitionIndexRanges, new ResultSubpartitionIndexSet(0));
        return subpartitionIndexRanges;
    }

    public StatusWatermarkValve(CheckpointedInputGate inputGate) {
        this(StatusWatermarkValve.getIndexSets(inputGate));
    }

    private static ResultSubpartitionIndexSet[] getIndexSets(CheckpointedInputGate inputGate) {
        ResultSubpartitionIndexSet[] subpartitionIndexSets = new ResultSubpartitionIndexSet[inputGate.getNumberOfInputChannels()];
        for (int i = 0; i < inputGate.getNumberOfInputChannels(); ++i) {
            subpartitionIndexSets[i] = inputGate.getChannel(i).getConsumedSubpartitionIndexSet();
        }
        return subpartitionIndexSets;
    }

    public StatusWatermarkValve(ResultSubpartitionIndexSet[] subpartitionIndexSets) {
        int numSubpartitions = 0;
        for (ResultSubpartitionIndexSet subpartitionIndexSet : subpartitionIndexSets) {
            numSubpartitions += subpartitionIndexSet.size();
        }
        this.alignedSubpartitionStatuses = new HeapPriorityQueue<SubpartitionStatus>((left, right) -> Long.compare(left.watermark, right.watermark), numSubpartitions);
        this.subpartitionStatuses = new ArrayList<Map<Integer, SubpartitionStatus>>(subpartitionIndexSets.length);
        this.subpartitionIndexes = new int[subpartitionIndexSets.length];
        Arrays.fill(this.subpartitionIndexes, -1);
        for (ResultSubpartitionIndexSet subpartitionIndexSet : subpartitionIndexSets) {
            HashMap<Integer, SubpartitionStatus> map = new HashMap<Integer, SubpartitionStatus>();
            Iterator iterator = subpartitionIndexSet.values().iterator();
            while (iterator.hasNext()) {
                int subpartitionId = (Integer)iterator.next();
                SubpartitionStatus subpartitionStatus = new SubpartitionStatus();
                subpartitionStatus.watermark = Long.MIN_VALUE;
                subpartitionStatus.watermarkStatus = WatermarkStatus.ACTIVE;
                this.markWatermarkAligned(subpartitionStatus);
                map.put(subpartitionId, subpartitionStatus);
            }
            if (subpartitionIndexSet.size() == 1) {
                this.subpartitionIndexes[this.subpartitionStatuses.size()] = (Integer)subpartitionIndexSet.values().iterator().next();
            }
            this.subpartitionStatuses.add(map);
        }
        this.lastOutputWatermark = Long.MIN_VALUE;
        this.lastOutputWatermarkStatus = WatermarkStatus.ACTIVE;
        this.isInputChannelShared = Arrays.stream(subpartitionIndexSets).anyMatch(x -> x.size() > 1);
    }

    public void inputWatermark(Watermark watermark, int channelIndex, PushingAsyncDataInput.DataOutput<?> output) throws Exception {
        long watermarkMillis;
        SubpartitionStatus subpartitionStatus;
        if (watermark instanceof InternalWatermark) {
            int subpartitionStatusIndex = ((InternalWatermark)watermark).getSubpartitionIndex();
            subpartitionStatus = this.subpartitionStatuses.get(channelIndex).get(subpartitionStatusIndex);
        } else {
            subpartitionStatus = this.subpartitionStatuses.get(channelIndex).get(this.subpartitionIndexes[channelIndex]);
        }
        if (this.lastOutputWatermarkStatus.isActive() && subpartitionStatus.watermarkStatus.isActive() && (watermarkMillis = watermark.getTimestamp()) > subpartitionStatus.watermark) {
            subpartitionStatus.watermark = watermarkMillis;
            if (subpartitionStatus.isWatermarkAligned) {
                this.adjustAlignedSubpartitionStatuses(subpartitionStatus);
            } else if (watermarkMillis >= this.lastOutputWatermark) {
                this.markWatermarkAligned(subpartitionStatus);
            }
            this.findAndOutputNewMinWatermarkAcrossAlignedSubpartitions(output);
        }
    }

    public void inputWatermarkStatus(WatermarkStatus watermarkStatus, int channelIndex, PushingAsyncDataInput.DataOutput<?> output) throws Exception {
        Preconditions.checkState((!this.isInputChannelShared ? 1 : 0) != 0);
        SubpartitionStatus subpartitionStatus = this.subpartitionStatuses.get(channelIndex).get(this.subpartitionIndexes[channelIndex]);
        if (watermarkStatus.isIdle() && subpartitionStatus.watermarkStatus.isActive()) {
            subpartitionStatus.watermarkStatus = WatermarkStatus.IDLE;
            this.markWatermarkUnaligned(subpartitionStatus);
            if (!SubpartitionStatus.hasActiveSubpartitions(this.subpartitionStatuses)) {
                if (subpartitionStatus.watermark == this.lastOutputWatermark) {
                    this.findAndOutputMaxWatermarkAcrossAllSubpartitions(output);
                }
                this.lastOutputWatermarkStatus = WatermarkStatus.IDLE;
                output.emitWatermarkStatus(this.lastOutputWatermarkStatus);
            } else if (subpartitionStatus.watermark == this.lastOutputWatermark) {
                this.findAndOutputNewMinWatermarkAcrossAlignedSubpartitions(output);
            }
        } else if (watermarkStatus.isActive() && subpartitionStatus.watermarkStatus.isIdle()) {
            subpartitionStatus.watermarkStatus = WatermarkStatus.ACTIVE;
            if (subpartitionStatus.watermark >= this.lastOutputWatermark) {
                this.markWatermarkAligned(subpartitionStatus);
            }
            if (this.lastOutputWatermarkStatus.isIdle()) {
                this.lastOutputWatermarkStatus = WatermarkStatus.ACTIVE;
                output.emitWatermarkStatus(this.lastOutputWatermarkStatus);
            }
        }
    }

    private void findAndOutputNewMinWatermarkAcrossAlignedSubpartitions(PushingAsyncDataInput.DataOutput<?> output) throws Exception {
        boolean hasAlignedSubpartitions;
        boolean bl = hasAlignedSubpartitions = !this.alignedSubpartitionStatuses.isEmpty();
        if (hasAlignedSubpartitions && this.alignedSubpartitionStatuses.peek().watermark > this.lastOutputWatermark) {
            this.lastOutputWatermark = this.alignedSubpartitionStatuses.peek().watermark;
            output.emitWatermark(new Watermark(this.lastOutputWatermark));
        }
    }

    private void markWatermarkAligned(SubpartitionStatus subpartitionStatus) {
        if (!subpartitionStatus.isWatermarkAligned) {
            subpartitionStatus.isWatermarkAligned = true;
            subpartitionStatus.addTo(this.alignedSubpartitionStatuses);
        }
    }

    private void markWatermarkUnaligned(SubpartitionStatus subpartitionStatus) {
        if (subpartitionStatus.isWatermarkAligned) {
            subpartitionStatus.isWatermarkAligned = false;
            subpartitionStatus.removeFrom(this.alignedSubpartitionStatuses);
        }
    }

    private void adjustAlignedSubpartitionStatuses(SubpartitionStatus subpartitionStatus) {
        this.alignedSubpartitionStatuses.adjustModifiedElement(subpartitionStatus);
    }

    private void findAndOutputMaxWatermarkAcrossAllSubpartitions(PushingAsyncDataInput.DataOutput<?> output) throws Exception {
        long maxWatermark = Long.MIN_VALUE;
        for (Map<Integer, SubpartitionStatus> map : this.subpartitionStatuses) {
            for (SubpartitionStatus subpartitionStatus : map.values()) {
                maxWatermark = Math.max(subpartitionStatus.watermark, maxWatermark);
            }
        }
        if (maxWatermark > this.lastOutputWatermark) {
            this.lastOutputWatermark = maxWatermark;
            output.emitWatermark(new Watermark(this.lastOutputWatermark));
        }
    }

    @VisibleForTesting
    protected SubpartitionStatus getSubpartitionStatus(int subpartitionIndex) {
        for (Map<Integer, SubpartitionStatus> map : this.subpartitionStatuses) {
            Preconditions.checkState((map.size() == 1 ? 1 : 0) != 0, (Object)"Cannot trigger this method when an input channel consumes multiple subpartition.");
        }
        Preconditions.checkArgument((subpartitionIndex >= 0 && subpartitionIndex < this.subpartitionStatuses.size() ? 1 : 0) != 0, (Object)("Invalid subpartition index. Number of subpartitions: " + this.subpartitionStatuses.size()));
        return this.subpartitionStatuses.get(subpartitionIndex).get(0);
    }

    @VisibleForTesting
    protected static class SubpartitionStatus
    implements HeapPriorityQueue.HeapPriorityQueueElement {
        protected long watermark;
        protected WatermarkStatus watermarkStatus;
        protected boolean isWatermarkAligned;
        private int heapIndex = Integer.MIN_VALUE;

        protected SubpartitionStatus() {
        }

        private static boolean hasActiveSubpartitions(List<Map<Integer, SubpartitionStatus>> subpartitionStatuses) {
            for (Map<Integer, SubpartitionStatus> map : subpartitionStatuses) {
                for (SubpartitionStatus status : map.values()) {
                    if (!status.watermarkStatus.isActive()) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public int getInternalIndex() {
            return this.heapIndex;
        }

        @Override
        public void setInternalIndex(int newIndex) {
            this.heapIndex = newIndex;
        }

        private void removeFrom(HeapPriorityQueue<SubpartitionStatus> queue) {
            Preconditions.checkState((this.heapIndex != Integer.MIN_VALUE ? 1 : 0) != 0);
            queue.remove(this);
            this.setInternalIndex(Integer.MIN_VALUE);
        }

        private void addTo(HeapPriorityQueue<SubpartitionStatus> queue) {
            Preconditions.checkState((this.heapIndex == Integer.MIN_VALUE ? 1 : 0) != 0);
            queue.add(this);
        }
    }
}

