/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.exception;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.amoro.ServerTableIdentifier;
import org.apache.amoro.api.AmoroException;
import org.apache.amoro.api.InvalidObjectException;
import org.apache.amoro.api.MetaException;
import org.apache.amoro.api.NoSuchObjectException;
import org.apache.amoro.api.OperationConflictException;
import org.apache.amoro.api.TableIdentifier;
import org.apache.amoro.exception.AlreadyExistsException;
import org.apache.amoro.exception.BlockerConflictException;
import org.apache.amoro.exception.ForbiddenException;
import org.apache.amoro.exception.IllegalMetadataException;
import org.apache.amoro.exception.IllegalTaskStateException;
import org.apache.amoro.exception.ObjectNotExistsException;
import org.apache.amoro.exception.OptimizingClosedException;
import org.apache.amoro.exception.PersistenceException;
import org.apache.amoro.exception.PluginAuthException;
import org.apache.amoro.exception.PluginRetryAuthException;
import org.apache.amoro.exception.TaskNotFoundException;
import org.apache.amoro.exception.TaskRuntimeException;
import org.apache.amoro.exception.UndefinedException;
import org.apache.amoro.shade.thrift.org.apache.thrift.TException;

public class AmoroRuntimeException
extends RuntimeException {
    private static final Map<Class<? extends AmoroRuntimeException>, Integer> CODE_MAP = new HashMap<Class<? extends AmoroRuntimeException>, Integer>();
    private static final int UNDEFINED = -1;
    private final int errorCode = Optional.ofNullable(CODE_MAP.get(this.getClass())).orElse(-1);
    private final String errorName = this.getClass().getSimpleName();

    protected AmoroRuntimeException() {
    }

    protected AmoroRuntimeException(String message) {
        super(message);
    }

    protected AmoroRuntimeException(Throwable throwable) {
        super(throwable);
    }

    protected AmoroRuntimeException(String message, Throwable throwable) {
        super(message, throwable);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorName() {
        return this.errorName;
    }

    private AmoroException transform() {
        return new AmoroException(this.errorCode, this.errorName, this.getMessage());
    }

    protected static String getObjectName(TableIdentifier tableIdentifier) {
        return "Table " + tableIdentifier.getCatalog() + '.' + tableIdentifier.getDatabase() + '.' + tableIdentifier.getTableName();
    }

    protected static String getObjectName(ServerTableIdentifier tableIdentifier) {
        return "Table " + tableIdentifier.getCatalog() + '.' + tableIdentifier.getDatabase() + '.' + tableIdentifier.getTableName();
    }

    public static AmoroException normalize(Throwable throwable) {
        return AmoroRuntimeException.wrap(throwable).transform();
    }

    public static TException normalizeCompatibly(Throwable throwable) {
        if (throwable.getClass().equals(ObjectNotExistsException.class)) {
            return new NoSuchObjectException(throwable.getMessage());
        }
        if (throwable.getClass().equals(AlreadyExistsException.class)) {
            return new org.apache.amoro.api.AlreadyExistsException(throwable.getMessage());
        }
        if (throwable.getClass().equals(IllegalMetadataException.class) || throwable.getClass().equals(PersistenceException.class)) {
            return new MetaException(throwable.getMessage());
        }
        if (throwable.getClass().equals(IllegalArgumentException.class)) {
            return new InvalidObjectException(throwable.getMessage());
        }
        if (throwable.getClass().equals(BlockerConflictException.class)) {
            return new OperationConflictException(throwable.getMessage());
        }
        return new TException(throwable.getMessage());
    }

    public static AmoroRuntimeException wrap(Throwable throwable, Function<Throwable, AmoroRuntimeException> exceptionTransform) {
        if (throwable instanceof AmoroRuntimeException) {
            return (AmoroRuntimeException)throwable;
        }
        return exceptionTransform.apply(throwable);
    }

    public static AmoroRuntimeException wrap(Throwable throwable) {
        return AmoroRuntimeException.wrap(throwable, UndefinedException::new);
    }

    static {
        CODE_MAP.put(PersistenceException.class, 1000);
        CODE_MAP.put(ObjectNotExistsException.class, 1001);
        CODE_MAP.put(AlreadyExistsException.class, 1002);
        CODE_MAP.put(IllegalMetadataException.class, 1003);
        CODE_MAP.put(ForbiddenException.class, 1004);
        CODE_MAP.put(TaskNotFoundException.class, 2001);
        CODE_MAP.put(TaskRuntimeException.class, 2002);
        CODE_MAP.put(OptimizingClosedException.class, 2003);
        CODE_MAP.put(IllegalTaskStateException.class, 2004);
        CODE_MAP.put(PluginAuthException.class, 2005);
        CODE_MAP.put(PluginRetryAuthException.class, 2006);
        CODE_MAP.put(BlockerConflictException.class, 3001);
    }
}

