/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.client;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URLDecoder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.apache.amoro.client.ThriftClient;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.thrift.org.apache.commons.lang3.tuple.Pair;
import org.apache.amoro.shade.thrift.org.apache.thrift.TServiceClient;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class PoolConfig<T extends TServiceClient>
extends GenericObjectPoolConfig<ThriftClient<T>> {
    private static final int MIN_IDLE_DEFAULT = 0;
    private static final int MAX_IDLE_DEFAULT = 5;
    private static final int MAX_WAIT_MS_DEFAULT = 5000;
    private int connectTimeout = 0;
    private int socketTimeout = 0;
    private int maxMessageSize = 0x6400000;
    private boolean autoReconnect = true;
    private int maxReconnects = 5;
    private static final String URL_ENCODING = "UTF-8";
    private static final String URL_QUERY_DELIMITER = "&";
    private static final String URL_QUERY_PARAMETER_DELIMITER = "=";

    public PoolConfig() {
        this.setMinIdle(0);
        this.setMaxIdle(5);
        this.setMaxWait(Duration.ofMillis(5000L));
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
    }

    public int getMaxReconnects() {
        return this.maxReconnects;
    }

    public void setMaxReconnects(int maxReconnects) {
        this.maxReconnects = maxReconnects;
    }

    public static PoolConfig<?> forUrl(String url) {
        PoolConfig poolConfig = new PoolConfig();
        PoolConfig.parseQuery(URI.create(url)).forEach(pair -> {
            try {
                BeanUtils.setProperty((Object)((Object)poolConfig), (String)((String)pair.getKey()), (Object)pair.getValue());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Parse url parameters failed", e);
            }
        });
        return poolConfig;
    }

    static List<Pair<String, String>> parseQuery(URI uri) {
        Preconditions.checkNotNull((Object)uri, (Object)"URI can not be null");
        ArrayList queries = Lists.newArrayList();
        String query = uri.getRawQuery();
        if (query != null && !query.trim().isEmpty()) {
            String[] pairs;
            for (String pair : pairs = query.trim().split(URL_QUERY_DELIMITER)) {
                String[] kv = pair.trim().split(URL_QUERY_PARAMETER_DELIMITER, 2);
                try {
                    String key = URLDecoder.decode(kv[0], URL_ENCODING);
                    String value = URLDecoder.decode(kv[1], URL_ENCODING);
                    queries.add(Pair.of((Object)key, (Object)value));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Unsupported encoding for uri", e);
                }
            }
        }
        return queries;
    }
}

