/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.threadinfo;

import java.util.List;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class VertexFlameGraph
implements ResponseBody {
    private static final String FIELD_NAME_END_TIMESTAMP = "endTimestamp";
    private static final String FIELD_NAME_DATA = "data";
    @JsonProperty(value="endTimestamp")
    private final long endTimestamp;
    @JsonProperty(value="data")
    private final Node root;

    @JsonCreator
    public VertexFlameGraph(@JsonProperty(value="endTimestamp") long endTimestamp, @JsonProperty(value="data") Node root) {
        this.endTimestamp = endTimestamp;
        this.root = root;
    }

    @JsonIgnore
    public long getEndTime() {
        return this.endTimestamp;
    }

    @JsonIgnore
    public Node getRoot() {
        return this.root;
    }

    public String toString() {
        return "OperatorFlameGraph: endTimestamp=" + this.endTimestamp + "\n" + this.getRoot().toString();
    }

    public static VertexFlameGraph terminated() {
        return new VertexFlameGraph(-1L, null);
    }

    public static VertexFlameGraph disabled() {
        return new VertexFlameGraph(-2L, null);
    }

    public static VertexFlameGraph waiting() {
        return new VertexFlameGraph(-3L, null);
    }

    public static class Node {
        private static final String FIELD_NAME_NAME = "name";
        private static final String FIELD_NAME_VALUE = "value";
        private static final String FIELD_NAME_CHILDREN = "children";
        @JsonProperty(value="name")
        private final String stackTraceLocation;
        @JsonProperty(value="value")
        private final int hitCount;
        @JsonProperty(value="children")
        private final List<Node> children;

        @JsonCreator
        Node(@JsonProperty(value="name") String stackTraceLocation, @JsonProperty(value="value") int hitCount, @JsonProperty(value="children") List<Node> children) {
            this.stackTraceLocation = stackTraceLocation;
            this.hitCount = hitCount;
            this.children = children;
        }

        @JsonIgnore
        public String getStackTraceLocation() {
            return this.stackTraceLocation;
        }

        @JsonIgnore
        public int getHitCount() {
            return this.hitCount;
        }

        @JsonIgnore
        public List<Node> getChildren() {
            return this.children;
        }

        public String toString() {
            return this.getStackTraceLocation() + ": " + this.getHitCount() + "\n\t" + this.toStringChildren();
        }

        private String toStringChildren() {
            StringBuilder sb = new StringBuilder();
            for (Node child : this.getChildren()) {
                sb.append(child.toString());
            }
            return sb.toString();
        }
    }
}

