/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cluster.baseline.autoadjust;

import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.processors.cluster.baseline.autoadjust.BaselineAutoAdjustData;
import org.apache.ignite.internal.processors.cluster.baseline.autoadjust.BaselineAutoAdjustExecutor;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;

class BaselineAutoAdjustScheduler {
    private final GridTimeoutProcessor timeoutProcessor;
    private final BaselineAutoAdjustExecutor baselineAutoAdjustExecutor;
    private BaselineMultiplyUseTimeoutObject baselineTimeoutObj;
    private final IgniteLogger log;

    public BaselineAutoAdjustScheduler(GridTimeoutProcessor timeoutProcessor, BaselineAutoAdjustExecutor baselineAutoAdjustExecutor, IgniteLogger log) {
        this.timeoutProcessor = timeoutProcessor;
        this.baselineAutoAdjustExecutor = baselineAutoAdjustExecutor;
        this.log = log;
    }

    public synchronized void schedule(BaselineAutoAdjustData baselineAutoAdjustData, long delay) {
        if (this.baselineTimeoutObj != null) {
            this.timeoutProcessor.removeTimeoutObject(this.baselineTimeoutObj);
        }
        this.baselineTimeoutObj = new BaselineMultiplyUseTimeoutObject(baselineAutoAdjustData, delay, this.baselineAutoAdjustExecutor, this.timeoutProcessor, this.log);
        this.timeoutProcessor.addTimeoutObject(this.baselineTimeoutObj);
    }

    public long lastScheduledTaskTime() {
        if (this.baselineTimeoutObj == null) {
            return -1L;
        }
        long lastScheduledTaskTime = this.baselineTimeoutObj.getTotalEndTime() - System.currentTimeMillis();
        return lastScheduledTaskTime < 0L ? -1L : lastScheduledTaskTime;
    }

    private static class BaselineMultiplyUseTimeoutObject
    implements GridTimeoutObject {
        private static final long AUTO_ADJUST_LOG_INTERVAL = IgniteSystemProperties.getLong("IGNITE_BASELINE_AUTO_ADJUST_LOG_INTERVAL", 60000L);
        private final BaselineAutoAdjustData baselineAutoAdjustData;
        private final BaselineAutoAdjustExecutor baselineAutoAdjustExecutor;
        private final GridTimeoutProcessor timeoutProcessor;
        private final IgniteLogger log;
        private final long totalEndTime;
        private final IgniteUuid id = IgniteUuid.randomUuid();
        private long endTime;

        protected BaselineMultiplyUseTimeoutObject(BaselineAutoAdjustData data, long executionTimeout, BaselineAutoAdjustExecutor executor, GridTimeoutProcessor processor, IgniteLogger log) {
            this.baselineAutoAdjustData = data;
            this.baselineAutoAdjustExecutor = executor;
            this.timeoutProcessor = processor;
            this.log = log;
            this.endTime = this.calculateEndTime(executionTimeout);
            this.totalEndTime = U.currentTimeMillis() + executionTimeout;
        }

        private long calculateEndTime(long timeout) {
            return U.currentTimeMillis() + (AUTO_ADJUST_LOG_INTERVAL < timeout ? AUTO_ADJUST_LOG_INTERVAL : timeout);
        }

        @Override
        public IgniteUuid timeoutId() {
            return this.id;
        }

        @Override
        public long endTime() {
            return this.endTime;
        }

        @Override
        public void onTimeout() {
            if (this.baselineAutoAdjustExecutor.isExecutionExpired(this.baselineAutoAdjustData)) {
                return;
            }
            long lastScheduledTaskTime = this.totalEndTime - System.currentTimeMillis();
            if (lastScheduledTaskTime <= 0L) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Baseline auto-adjust will be executed right now.");
                }
                this.baselineAutoAdjustExecutor.execute(this.baselineAutoAdjustData);
            } else {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Baseline auto-adjust will be executed in '" + lastScheduledTaskTime + "' ms.");
                }
                this.endTime = this.calculateEndTime(lastScheduledTaskTime);
                this.timeoutProcessor.addTimeoutObject(this);
            }
        }

        public long getTotalEndTime() {
            return this.totalEndTime;
        }
    }
}

