/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.aware;

import org.apache.ignite.internal.IgniteInterruptedCheckedException;

class SegmentArchiveSizeStorage {
    private long curr;
    private long reserved;
    private volatile boolean interrupted;

    SegmentArchiveSizeStorage() {
    }

    synchronized void addCurrentSize(long size) {
        this.curr += size;
        if (size > 0L) {
            this.notifyAll();
        }
    }

    synchronized void addReservedSize(long size) {
        this.reserved += size;
        if (size > 0L) {
            this.notifyAll();
        }
    }

    synchronized void resetSizes() {
        this.curr = 0L;
        this.reserved = 0L;
    }

    synchronized void awaitExceedMaxSize(long max) throws IgniteInterruptedCheckedException {
        try {
            while (max - (this.curr + this.reserved) > 0L && !this.interrupted) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedCheckedException(e);
        }
        if (this.interrupted) {
            throw new IgniteInterruptedCheckedException("Interrupt waiting of exceed max archive size");
        }
    }

    synchronized void interrupt() {
        this.interrupted = true;
        this.notifyAll();
    }

    void reset() {
        this.interrupted = false;
    }
}

