/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteFutureCancelledCheckedException;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.pagemem.store.PageWriteListener;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotSender;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.FastCrc;
import org.apache.ignite.internal.processors.marshaller.MappedName;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.IgniteThrowableRunner;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

class SnapshotFutureTask
extends GridFutureAdapter<Boolean>
implements CheckpointListener {
    private final GridCacheSharedContext<?, ?> cctx;
    private final FilePageStoreManager pageStore;
    private final IgniteLogger log;
    private final UUID srcNodeId;
    private final String snpName;
    private final File tmpSnpWorkDir;
    private final ThreadLocal<ByteBuffer> locBuff;
    private final FileIOFactory ioFactory;
    private final Map<GroupPartitionId, Long> partFileLengths = new HashMap<GroupPartitionId, Long>();
    private final Map<GroupPartitionId, PageStoreSerialWriter> partDeltaWriters = new HashMap<GroupPartitionId, PageStoreSerialWriter>();
    private final List<CacheConfigurationSender> ccfgSndrs = new CopyOnWriteArrayList<CacheConfigurationSender>();
    @GridToStringExclude
    private final SnapshotSender snpSndr;
    private final Map<Integer, Set<Integer>> parts;
    private final Map<Integer, Set<Integer>> processed = new HashMap<Integer, Set<Integer>>();
    private final CompletableFuture<Boolean> cpEndFut = new CompletableFuture();
    private final GridFutureAdapter<Void> startedFut = new GridFutureAdapter();
    private volatile File tmpConsIdDir;
    private volatile CompletableFuture<Void> closeFut;
    private final AtomicReference<Throwable> err = new AtomicReference();
    private final AtomicBoolean started = new AtomicBoolean();

    public SnapshotFutureTask(IgniteCheckedException e) {
        assert (e != null) : "Exception for a finished snapshot task must be not null";
        this.cctx = null;
        this.pageStore = null;
        this.log = null;
        this.snpName = null;
        this.srcNodeId = null;
        this.tmpSnpWorkDir = null;
        this.snpSndr = null;
        this.err.set(e);
        this.startedFut.onDone(e);
        this.onDone(e);
        this.parts = null;
        this.ioFactory = null;
        this.locBuff = null;
    }

    public SnapshotFutureTask(GridCacheSharedContext<?, ?> cctx, UUID srcNodeId, String snpName, File tmpWorkDir, FileIOFactory ioFactory, SnapshotSender snpSndr, Map<Integer, Set<Integer>> parts, ThreadLocal<ByteBuffer> locBuff) {
        assert (snpName != null) : "Snapshot name cannot be empty or null.";
        assert (snpSndr != null) : "Snapshot sender which handles execution tasks must be not null.";
        assert (snpSndr.executor() != null) : "Executor service must be not null.";
        assert (cctx.pageStore() instanceof FilePageStoreManager) : "Snapshot task can work only with physical files.";
        this.parts = parts;
        this.cctx = cctx;
        this.pageStore = (FilePageStoreManager)cctx.pageStore();
        this.log = cctx.logger(SnapshotFutureTask.class);
        this.snpName = snpName;
        this.srcNodeId = srcNodeId;
        this.tmpSnpWorkDir = new File(tmpWorkDir, snpName);
        this.snpSndr = snpSndr;
        this.ioFactory = ioFactory;
        this.locBuff = locBuff;
    }

    public String snapshotName() {
        return this.snpName;
    }

    public UUID sourceNodeId() {
        return this.srcNodeId;
    }

    public Class<? extends SnapshotSender> type() {
        return this.snpSndr.getClass();
    }

    public Set<Integer> affectedCacheGroups() {
        return this.parts.keySet();
    }

    public void acceptException(Throwable th) {
        if (th == null) {
            return;
        }
        if (this.err.compareAndSet(null, th)) {
            this.closeAsync();
        }
        this.startedFut.onDone(th);
        if (!(th instanceof IgniteFutureCancelledCheckedException)) {
            U.error(this.log, "Snapshot task has accepted exception to stop", th);
        }
    }

    @Override
    public boolean onDone(@Nullable Boolean res, @Nullable Throwable err) {
        for (PageStoreSerialWriter writer : this.partDeltaWriters.values()) {
            U.closeQuiet(writer);
        }
        for (CacheConfigurationSender ccfgSndr : this.ccfgSndrs) {
            U.closeQuiet(ccfgSndr);
        }
        this.snpSndr.close(err);
        if (this.tmpConsIdDir != null) {
            U.delete(this.tmpConsIdDir);
        }
        try {
            if (U.fileCount(this.tmpSnpWorkDir.toPath()) == 0 || err != null) {
                U.delete(this.tmpSnpWorkDir.toPath());
            }
        }
        catch (IOException e) {
            this.log.error("Snapshot directory doesn't exist [snpName=" + this.snpName + ", dir=" + this.tmpSnpWorkDir + ']');
        }
        if (err != null) {
            this.startedFut.onDone(err);
        }
        return super.onDone(res, err);
    }

    public void awaitStarted() throws IgniteCheckedException {
        this.startedFut.get();
    }

    private boolean stopping() {
        return this.err.get() != null;
    }

    public boolean start() {
        if (this.stopping()) {
            return false;
        }
        try {
            if (!this.started.compareAndSet(false, true)) {
                return false;
            }
            this.tmpConsIdDir = U.resolveWorkDirectory(this.tmpSnpWorkDir.getAbsolutePath(), IgniteSnapshotManager.databaseRelativePath(this.cctx.kernalContext().pdsFolderResolver().resolveFolders().folderName()), false);
            for (Integer grpId : this.parts.keySet()) {
                CacheGroupContext gctx = this.cctx.cache().cacheGroup(grpId);
                if (gctx == null) {
                    throw new IgniteCheckedException("Cache group context not found: " + grpId);
                }
                if (!CU.isPersistentCache(gctx.config(), this.cctx.kernalContext().config().getDataStorageConfiguration())) {
                    throw new IgniteCheckedException("In-memory cache groups are not allowed to be snapshot: " + grpId);
                }
                if (gctx.config().isEncryptionEnabled()) {
                    throw new IgniteCheckedException("Encrypted cache groups are not allowed to be snapshot: " + grpId);
                }
                U.ensureDirectory(FilePageStoreManager.cacheWorkDir(this.tmpConsIdDir, FilePageStoreManager.cacheDirName(gctx.config())), "directory for snapshotting cache group", this.log);
            }
            this.startedFut.listen(f -> ((GridCacheDatabaseSharedManager)this.cctx.database()).removeCheckpointListener(this));
            ((GridCacheDatabaseSharedManager)this.cctx.database()).addCheckpointListener(this);
            if (this.log.isInfoEnabled()) {
                this.log.info("Snapshot operation is scheduled on local node and will be handled by the checkpoint listener [sctx=" + this + ", topVer=" + this.cctx.discovery().topologyVersionEx() + ']');
            }
        }
        catch (IgniteCheckedException e) {
            this.acceptException(e);
            return false;
        }
        return true;
    }

    @Override
    public void beforeCheckpointBegin(CheckpointListener.Context ctx) {
        if (this.stopping()) {
            return;
        }
        ctx.finishedStateFut().listen(f -> {
            if (f.error() == null) {
                this.cpEndFut.complete(true);
            } else {
                this.cpEndFut.completeExceptionally(f.error());
            }
        });
    }

    @Override
    public void onMarkCheckpointBegin(CheckpointListener.Context ctx) {
        if (this.stopping()) {
            return;
        }
        try {
            for (Map.Entry<Integer, Set<Integer>> e : this.parts.entrySet()) {
                Iterator<GridDhtLocalPartition> iter;
                int grpId = e.getKey();
                Set<Integer> grpParts = e.getValue();
                GridDhtPartitionTopology top = this.cctx.cache().cacheGroup(grpId).topology();
                if (grpParts == null) {
                    iter = top.currentLocalPartitions().iterator();
                } else {
                    if (grpParts.contains(65535)) {
                        throw new IgniteCheckedException("Index partition cannot be included into snapshot if  set of cache group partitions has been explicitly provided [grpId=" + grpId + ']');
                    }
                    iter = F.iterator(grpParts, top::localPartition, false, new IgnitePredicate[0]);
                }
                HashSet<Integer> owning = new HashSet<Integer>();
                HashSet<Integer> missed = new HashSet<Integer>();
                while (iter.hasNext()) {
                    GridDhtLocalPartition part = iter.next();
                    if (part.state() == GridDhtPartitionState.OWNING) {
                        owning.add(part.id());
                        continue;
                    }
                    missed.add(part.id());
                }
                if (grpParts != null) {
                    if (!missed.isEmpty()) {
                        throw new IgniteCheckedException("Snapshot operation cancelled due to not all of requested partitions has OWNING state on local node [grpId=" + grpId + ", missed" + missed + ']');
                    }
                } else if (!missed.isEmpty()) {
                    this.log.warning("All local cache group partitions in OWNING state have been included into a snapshot. Partitions which have different states skipped. Index partitions has also been skipped [snpName=" + this.snpName + ", grpId=" + grpId + ", missed=" + missed + ']');
                } else if (missed.isEmpty() && this.cctx.kernalContext().query().moduleEnabled()) {
                    owning.add(65535);
                }
                this.processed.put(grpId, owning);
            }
            ArrayList ccfgs = new ArrayList();
            for (Map.Entry<Integer, Set<Integer>> e : this.processed.entrySet()) {
                int grpId = e.getKey();
                CacheGroupContext gctx = this.cctx.cache().cacheGroup(grpId);
                if (gctx == null) {
                    throw new IgniteCheckedException("Cache group context has not found due to the cache group is stopped: " + grpId);
                }
                for (int partId : e.getValue()) {
                    GroupPartitionId pair = new GroupPartitionId(grpId, partId);
                    PageStore store = this.pageStore.getStore(grpId, partId);
                    this.partDeltaWriters.put(pair, new PageStoreSerialWriter(store, IgniteSnapshotManager.partDeltaFile(FilePageStoreManager.cacheWorkDir(this.tmpConsIdDir, FilePageStoreManager.cacheDirName(gctx.config())), partId)));
                    this.partFileLengths.put(pair, store.size());
                }
                ccfgs.add(gctx.config());
            }
            this.pageStore.readConfigurationFiles(ccfgs, (ccfg, ccfgFile) -> this.ccfgSndrs.add(new CacheConfigurationSender(ccfg.getName(), FilePageStoreManager.cacheDirName(ccfg), (File)ccfgFile)));
        }
        catch (IgniteCheckedException e) {
            this.acceptException(e);
        }
    }

    @Override
    public void onCheckpointBegin(CheckpointListener.Context ctx) {
        if (this.stopping()) {
            return;
        }
        assert (!this.processed.isEmpty()) : "Partitions to process must be collected under checkpoint mark phase";
        this.wrapExceptionIfStarted(() -> this.snpSndr.init(this.processed.values().stream().mapToInt(Set::size).sum())).run();
        if (!this.startedFut.onDone()) {
            return;
        }
        ArrayList<CompletionStage> futs = new ArrayList<CompletionStage>();
        if (this.log.isInfoEnabled()) {
            this.log.info("Submit partition processing tasks with partition allocated lengths: " + this.partFileLengths);
        }
        Collection<BinaryType> binTypesCopy = this.cctx.kernalContext().cacheObjects().metadata(Collections.emptyList()).values();
        futs.add(CompletableFuture.runAsync(this.wrapExceptionIfStarted(() -> this.snpSndr.sendBinaryMeta(binTypesCopy)), this.snpSndr.executor()));
        ArrayList<Map<Integer, MappedName>> mappingsCopy = this.cctx.kernalContext().marshallerContext().getCachedMappings();
        futs.add(CompletableFuture.runAsync(this.wrapExceptionIfStarted(() -> this.snpSndr.sendMarshallerMeta(mappingsCopy)), this.snpSndr.executor()));
        for (CacheConfigurationSender cacheConfigurationSender : this.ccfgSndrs) {
            futs.add(CompletableFuture.runAsync(this.wrapExceptionIfStarted(cacheConfigurationSender::sendCacheConfig), this.snpSndr.executor()));
        }
        for (Map.Entry entry : this.processed.entrySet()) {
            int grpId = (Integer)entry.getKey();
            CacheGroupContext gctx = this.cctx.cache().cacheGroup(grpId);
            if (gctx == null) {
                this.acceptException(new IgniteCheckedException("Cache group context has not found due to the cache group is stopped: " + grpId));
                break;
            }
            Iterator iterator = ((Set)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                int partId = (Integer)iterator.next();
                GroupPartitionId pair = new GroupPartitionId(grpId, partId);
                CacheConfiguration ccfg = gctx.config();
                assert (ccfg != null) : "Cache configuration cannot be empty on snapshot creation: " + pair;
                String cacheDirName = FilePageStoreManager.cacheDirName(ccfg);
                Long partLen = this.partFileLengths.get(pair);
                CompletionStage fut0 = CompletableFuture.runAsync(this.wrapExceptionIfStarted(() -> {
                    this.snpSndr.sendPart(FilePageStoreManager.getPartitionFile(this.pageStore.workDir(), cacheDirName, partId), cacheDirName, pair, partLen);
                    this.partDeltaWriters.get(pair).markPartitionProcessed();
                }), this.snpSndr.executor()).runAfterBothAsync(this.cpEndFut, this.wrapExceptionIfStarted(() -> {
                    File delta = this.partDeltaWriters.get(pair).deltaFile;
                    try {
                        delta.createNewFile();
                    }
                    catch (IOException ex) {
                        throw new IgniteCheckedException(ex);
                    }
                    this.snpSndr.sendDelta(delta, cacheDirName, pair);
                    boolean deleted = delta.delete();
                    assert (deleted);
                }), this.snpSndr.executor());
                futs.add(fut0);
            }
        }
        int futsSize = futs.size();
        CompletableFuture.allOf(futs.toArray(new CompletableFuture[futsSize])).whenComplete((res, t) -> {
            assert (t == null) : "Exception must never be thrown since a wrapper is used for each snapshot task: " + t;
            this.closeAsync();
        });
    }

    private Runnable wrapExceptionIfStarted(IgniteThrowableRunner exec) {
        return () -> {
            if (this.stopping()) {
                return;
            }
            try {
                exec.run();
            }
            catch (Throwable t) {
                this.acceptException(t);
            }
        };
    }

    public synchronized CompletableFuture<Void> closeAsync() {
        if (this.closeFut == null) {
            Throwable err0 = this.err.get();
            this.closeFut = CompletableFuture.runAsync(() -> this.onDone(true, err0), this.cctx.kernalContext().getSystemExecutorService());
        }
        return this.closeFut;
    }

    @Override
    public boolean cancel() {
        this.acceptException(new IgniteFutureCancelledCheckedException("Snapshot operation has been cancelled by external process [snpName=" + this.snpName + ']'));
        try {
            this.closeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            U.error(this.log, "SnapshotFutureTask cancellation failed", e);
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotFutureTask ctx = (SnapshotFutureTask)o;
        return this.snpName.equals(ctx.snpName);
    }

    public int hashCode() {
        return Objects.hash(this.snpName);
    }

    @Override
    public String toString() {
        return S.toString(SnapshotFutureTask.class, this);
    }

    private static class AtomicBitSet {
        private final AtomicIntegerArray arr;
        private final int size;

        public AtomicBitSet(int size) {
            this.size = size;
            this.arr = new AtomicIntegerArray(size + 31 >>> 5);
        }

        public boolean touch(long off) {
            int val;
            int cur;
            if (off >= (long)this.size) {
                return false;
            }
            int bit = 1 << (int)off;
            int bucket = (int)(off >>> 5);
            do {
                if ((cur = this.arr.get(bucket)) != (val = cur | bit)) continue;
                return false;
            } while (!this.arr.compareAndSet(bucket, cur, val));
            return true;
        }
    }

    private class PageStoreSerialWriter
    implements PageWriteListener,
    Closeable {
        @GridToStringExclude
        private final PageStore store;
        private final File deltaFile;
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        @GridToStringExclude
        private final BooleanSupplier checkpointComplete = () -> SnapshotFutureTask.this.cpEndFut.isDone() && !SnapshotFutureTask.this.cpEndFut.isCompletedExceptionally();
        private final AtomicBitSet writtenPages;
        @GridToStringExclude
        private volatile FileIO deltaFileIo;
        private volatile boolean partProcessed;

        public PageStoreSerialWriter(PageStore store, File deltaFile) {
            assert (store != null);
            assert (SnapshotFutureTask.this.cctx.database().checkpointLockIsHeldByThread());
            this.deltaFile = deltaFile;
            this.store = store;
            this.writtenPages = new AtomicBitSet(store.pages());
            store.addWriteListener(this);
        }

        public boolean stopped() {
            return this.checkpointComplete.getAsBoolean() && this.partProcessed || SnapshotFutureTask.this.stopping();
        }

        public void markPartitionProcessed() {
            this.lock.writeLock().lock();
            try {
                this.partProcessed = true;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(long pageId, ByteBuffer buf) {
            assert (buf.position() == 0) : buf.position();
            assert (buf.order() == ByteOrder.nativeOrder()) : buf.order();
            if (this.deltaFileIo == null) {
                this.lock.writeLock().lock();
                try {
                    if (this.stopped()) {
                        return;
                    }
                    if (this.deltaFileIo == null) {
                        this.deltaFileIo = SnapshotFutureTask.this.ioFactory.create(this.deltaFile);
                    }
                }
                catch (IOException e) {
                    SnapshotFutureTask.this.acceptException(e);
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            int pageIdx = -1;
            this.lock.readLock().lock();
            try {
                if (this.stopped()) {
                    return;
                }
                pageIdx = PageIdUtils.pageIndex(pageId);
                if (this.checkpointComplete.getAsBoolean()) {
                    if (!this.writtenPages.touch(pageIdx)) {
                        return;
                    }
                    ByteBuffer locBuf = (ByteBuffer)SnapshotFutureTask.this.locBuff.get();
                    assert (locBuf.capacity() == this.store.getPageSize());
                    locBuf.clear();
                    if (!this.store.read(pageId, locBuf, true)) {
                        return;
                    }
                    locBuf.flip();
                    this.writePage0(pageId, locBuf);
                } else {
                    this.writePage0(pageId, buf);
                    this.writtenPages.touch(pageIdx);
                }
            }
            catch (Throwable ex) {
                SnapshotFutureTask.this.acceptException(new IgniteCheckedException("Error during writing pages to delta partition file [pageIdx=" + pageIdx + ", writer=" + this + ']', ex));
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        private void writePage0(long pageId, ByteBuffer pageBuf) throws IOException {
            assert (this.deltaFileIo != null) : "Delta pages storage is not inited: " + this;
            assert (pageBuf.position() == 0);
            assert (pageBuf.order() == ByteOrder.nativeOrder()) : "Page buffer order " + pageBuf.order() + " should be same with " + ByteOrder.nativeOrder();
            if (SnapshotFutureTask.this.log.isDebugEnabled()) {
                SnapshotFutureTask.this.log.debug("onPageWrite [pageId=" + pageId + ", pageIdBuff=" + PageIO.getPageId(pageBuf) + ", fileSize=" + this.deltaFileIo.size() + ", crcBuff=" + FastCrc.calcCrc(pageBuf, pageBuf.limit()) + ", crcPage=" + PageIO.getCrc(pageBuf) + ']');
                pageBuf.rewind();
            }
            this.deltaFileIo.writeFully(pageBuf);
        }

        @Override
        public void close() {
            this.lock.writeLock().lock();
            try {
                U.closeQuiet(this.deltaFileIo);
                this.deltaFileIo = null;
                this.store.removeWriteListener(this);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public String toString() {
            return S.toString(PageStoreSerialWriter.class, this);
        }
    }

    private class CacheConfigurationSender
    implements BiConsumer<String, File>,
    Closeable {
        private final String cacheName;
        private final String cacheDirName;
        private final Lock lock = new ReentrantLock();
        private volatile File ccfgFile;
        private volatile boolean sent;
        private volatile boolean fromTemp;

        public CacheConfigurationSender(String cacheName, String cacheDirName, File ccfgFile) {
            this.cacheName = cacheName;
            this.cacheDirName = cacheDirName;
            this.ccfgFile = ccfgFile;
            SnapshotFutureTask.this.pageStore.addConfigurationChangeListener(this);
        }

        public void sendCacheConfig() {
            this.lock.lock();
            try {
                SnapshotFutureTask.this.snpSndr.sendCacheConfig(this.ccfgFile, this.cacheDirName);
                this.close0();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(String cacheName, File ccfgFile) {
            assert (ccfgFile.exists()) : "Cache configuration file must exist [cacheName=" + cacheName + ", ccfgFile=" + ccfgFile.getAbsolutePath() + ']';
            if (SnapshotFutureTask.this.stopping()) {
                return;
            }
            if (!cacheName.equals(this.cacheName) || this.sent || this.fromTemp) {
                return;
            }
            this.lock.lock();
            try {
                if (this.sent || this.fromTemp) {
                    return;
                }
                File cacheWorkDir = FilePageStoreManager.cacheWorkDir(SnapshotFutureTask.this.tmpSnpWorkDir, this.cacheDirName);
                if (!U.mkdirs(cacheWorkDir)) {
                    throw new IOException("Unable to create temp directory to copy original configuration file: " + cacheWorkDir);
                }
                File newCcfgFile = new File(cacheWorkDir, ccfgFile.getName());
                newCcfgFile.createNewFile();
                IgniteSnapshotManager.copy(SnapshotFutureTask.this.ioFactory, ccfgFile, newCcfgFile, ccfgFile.length());
                this.ccfgFile = newCcfgFile;
                this.fromTemp = true;
            }
            catch (IOException e) {
                SnapshotFutureTask.this.acceptException(e);
            }
            finally {
                this.lock.unlock();
            }
        }

        private void close0() {
            this.sent = true;
            SnapshotFutureTask.this.pageStore.removeConfigurationChangeListener(this);
            if (this.fromTemp) {
                U.delete(this.ccfgFile);
            }
        }

        @Override
        public void close() {
            this.lock.lock();
            try {
                this.close0();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

