/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class InitNewPageRecord
extends PageDeltaRecord {
    protected int ioType;
    protected int ioVer;
    @GridToStringExclude
    protected long newPageId;

    public InitNewPageRecord(int grpId, long pageId, int ioType, int ioVer, long newPageId) {
        this(grpId, pageId, ioType, ioVer, newPageId, null);
    }

    public InitNewPageRecord(int grpId, long pageId, int ioType, int ioVer, long newPageId, @Nullable IgniteLogger log) {
        super(grpId, pageId);
        this.ioType = ioType;
        this.ioVer = ioVer;
        this.newPageId = newPageId;
        int newPartId = PageIdUtils.partId(newPageId);
        int partId = PageIdUtils.partId(pageId);
        if (newPartId == 0 && newPartId != partId) {
            U.warn(log, "Partition consistency warning: newPageId=" + Long.toHexString(newPageId) + " (newPartId: 0) pageId=" + Long.toHexString(pageId) + " (partId: " + partId + ")");
            newPartId = partId;
            this.newPageId = PageIdUtils.pageId(newPartId, PageIdUtils.flag(newPageId), PageIdUtils.pageIndex(newPageId));
        }
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        Object io = PageIO.getPageIO(this.ioType, this.ioVer);
        ((PageIO)io).initNewPage(pageAddr, this.newPageId, pageMem.realPageSize(this.groupId()));
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.INIT_NEW_PAGE_RECORD;
    }

    public int ioVersion() {
        return this.ioVer;
    }

    public int ioType() {
        return this.ioType;
    }

    public long newPageId() {
        return this.newPageId;
    }

    @Override
    public String toString() {
        return S.toString(InitNewPageRecord.class, this, "newPageId", (Object)U.hexLong(this.newPageId), "super", (Object)super.toString());
    }
}

