/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.router;

import java.util.Collection;
import java.util.Collections;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.client.ssl.GridSslContextFactory;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.security.SecurityCredentialsProvider;
import org.jetbrains.annotations.Nullable;

public class GridTcpRouterConfiguration {
    public static final Collection<String> DFLT_SERVERS = Collections.singleton("127.0.0.1:11211");
    public static final String DFLT_TCP_HOST = "0.0.0.0";
    public static final int DFLT_TCP_PORT = 11212;
    public static final int DFLT_PORT_RANGE = 0;
    public static final boolean DFLT_TCP_NODELAY = true;
    private String host = "0.0.0.0";
    private int port = 11212;
    private int portRange = 0;
    private boolean noDelay = true;
    private long idleTimeout = 7000L;
    private boolean sslClientAuth;
    private GridSslContextFactory sslCtxFactory;
    private Collection<String> srvrs = DFLT_SERVERS;
    private IgniteLogger log;
    private SecurityCredentialsProvider credsProvider;

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getPortRange() {
        return this.portRange;
    }

    public boolean isNoDelay() {
        return this.noDelay;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public boolean isSslClientAuth() {
        return this.sslClientAuth;
    }

    @Nullable
    public GridSslContextFactory getSslContextFactory() {
        return this.sslCtxFactory;
    }

    public Collection<String> getServers() {
        return this.srvrs;
    }

    public IgniteLogger getLogger() {
        return this.log;
    }

    @Nullable
    public SecurityCredentialsProvider getSecurityCredentialsProvider() {
        return this.credsProvider;
    }

    public GridTcpRouterConfiguration setHost(String host) {
        this.host = host;
        return this;
    }

    public GridTcpRouterConfiguration setPort(int port) {
        this.port = port;
        return this;
    }

    public GridTcpRouterConfiguration setPortRange(int portRange) {
        A.ensure(portRange >= 0, "portRange >= 0");
        this.portRange = portRange;
        return this;
    }

    public GridTcpRouterConfiguration setNoDelay(boolean noDelay) {
        this.noDelay = noDelay;
        return this;
    }

    public GridTcpRouterConfiguration setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    public GridTcpRouterConfiguration setSslClientAuth(boolean sslClientAuth) {
        this.sslClientAuth = sslClientAuth;
        return this;
    }

    public GridTcpRouterConfiguration setSslContextFactory(GridSslContextFactory sslCtxFactory) {
        this.sslCtxFactory = sslCtxFactory;
        return this;
    }

    public GridTcpRouterConfiguration setServers(Collection<String> srvrs) {
        this.srvrs = srvrs;
        return this;
    }

    public GridTcpRouterConfiguration setLogger(IgniteLogger log) {
        this.log = log;
        return this;
    }

    public GridTcpRouterConfiguration setSecurityCredentialsProvider(SecurityCredentialsProvider credsProvider) {
        this.credsProvider = credsProvider;
        return this;
    }

    public String toString() {
        return S.toString(GridTcpRouterConfiguration.class, this);
    }
}

