/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class QueryIndex
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final QueryIndexType DFLT_IDX_TYP = QueryIndexType.SORTED;
    public static final int DFLT_INLINE_SIZE = -1;
    private String name;
    @GridToStringInclude
    private LinkedHashMap<String, Boolean> fields;
    private QueryIndexType type = DFLT_IDX_TYP;
    private int inlineSize = -1;

    public QueryIndex() {
    }

    public QueryIndex(String field) {
        this(field, QueryIndexType.SORTED, true);
    }

    public QueryIndex(String field, boolean asc) {
        this(field, QueryIndexType.SORTED, asc);
    }

    public QueryIndex(String field, boolean asc, String name) {
        this(field, QueryIndexType.SORTED, asc);
        this.name = name;
    }

    public QueryIndex(String field, QueryIndexType type) {
        this(Arrays.asList(field), type);
    }

    public QueryIndex(String field, QueryIndexType type, boolean asc) {
        this.fields = new LinkedHashMap();
        this.fields.put(field, asc);
        this.type = type;
    }

    public QueryIndex(String field, QueryIndexType type, boolean asc, String name) {
        this.fields = new LinkedHashMap();
        this.fields.put(field, asc);
        this.type = type;
        this.name = name;
    }

    public QueryIndex(Collection<String> fields, QueryIndexType type) {
        this.fields = new LinkedHashMap();
        for (String field : fields) {
            this.fields.put(field, true);
        }
        this.type = type;
    }

    public QueryIndex(LinkedHashMap<String, Boolean> fields, QueryIndexType type) {
        this.fields = fields;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public QueryIndex setName(String name) {
        this.name = name;
        return this;
    }

    public LinkedHashMap<String, Boolean> getFields() {
        return this.fields;
    }

    public QueryIndex setFields(LinkedHashMap<String, Boolean> fields) {
        this.fields = fields;
        return this;
    }

    public Collection<String> getFieldNames() {
        return this.fields.keySet();
    }

    public QueryIndex setFieldNames(Collection<String> fields, boolean asc) {
        this.fields = new LinkedHashMap();
        for (String field : fields) {
            this.fields.put(field, asc);
        }
        return this;
    }

    public QueryIndexType getIndexType() {
        return this.type;
    }

    public QueryIndex setIndexType(QueryIndexType type) {
        this.type = type;
        return this;
    }

    public int getInlineSize() {
        return this.inlineSize;
    }

    public QueryIndex setInlineSize(int inlineSize) {
        this.inlineSize = inlineSize;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryIndex index = (QueryIndex)o;
        return this.inlineSize == index.inlineSize && F.eq(this.name, index.name) && F.eq(this.fields, index.fields) && this.type == index.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.fields, this.type, this.inlineSize});
    }

    public String toString() {
        return S.toString(QueryIndex.class, this);
    }
}

