/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.util.concurrent;

import java.io.Serializable;
import java.util.concurrent.Semaphore;
import org.apache.ignite.raft.jraft.util.Requires;

public final class AdjustableSemaphore
implements Serializable {
    private static final long serialVersionUID = -266635933115069924L;
    private final ResizeableSemaphore semaphore = new ResizeableSemaphore(0);
    private volatile int maxPermits = 0;

    public AdjustableSemaphore() {
    }

    public AdjustableSemaphore(int maxPermits) {
        Requires.requireTrue(maxPermits >= 0, "maxPermits must be a non-negative value");
        this.setMaxPermits(maxPermits);
    }

    public int getMaxPermits() {
        return this.maxPermits;
    }

    public synchronized void setMaxPermits(int newMaxPermits) {
        Requires.requireTrue(newMaxPermits >= 0, "Semaphore permits must be at least 0, but was " + newMaxPermits);
        int delta = newMaxPermits - this.maxPermits;
        if (delta == 0) {
            return;
        }
        if (delta > 0) {
            this.semaphore.release(delta);
        } else {
            this.semaphore.reducePermits(-delta);
        }
        this.maxPermits = newMaxPermits;
    }

    public void release() {
        this.semaphore.release();
    }

    public void acquire() throws InterruptedException {
        this.semaphore.acquire();
    }

    public boolean tryAcquire() {
        return this.semaphore.tryAcquire();
    }

    public int availablePermits() {
        return this.semaphore.availablePermits();
    }

    public boolean isAvailable() {
        return this.availablePermits() > 0;
    }

    private static final class ResizeableSemaphore
    extends Semaphore {
        private static final long serialVersionUID = 1204115455517785966L;

        ResizeableSemaphore(int permits) {
            super(permits);
        }

        @Override
        protected void reducePermits(int reduction) {
            super.reducePermits(reduction);
        }
    }
}

