/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.raft;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cluster.management.ClusterState;
import org.apache.ignite.internal.cluster.management.raft.ClusterStateStorage;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

class RaftStorageManager {
    private static final byte[] CMG_STATE_KEY = "cmg_state".getBytes(StandardCharsets.UTF_8);
    private static final byte[] LOGICAL_TOPOLOGY_PREFIX = "logical_".getBytes(StandardCharsets.UTF_8);
    private static final byte[] VALIDATED_NODE_PREFIX = "validation_".getBytes(StandardCharsets.UTF_8);
    private final ClusterStateStorage storage;

    RaftStorageManager(ClusterStateStorage storage) {
        this.storage = storage;
    }

    @Nullable
    ClusterState getClusterState() {
        byte[] value = this.storage.get(CMG_STATE_KEY);
        return value == null ? null : (ClusterState)ByteUtils.fromBytes((byte[])value);
    }

    void putClusterState(ClusterState state) {
        this.storage.put(CMG_STATE_KEY, ByteUtils.toBytes((Object)state));
    }

    Collection<ClusterNode> getLogicalTopology() {
        Collection collection;
        block8: {
            Cursor<ClusterNode> cursor = this.storage.getWithPrefix(LOGICAL_TOPOLOGY_PREFIX, (k, v) -> (ClusterNode)ByteUtils.fromBytes((byte[])v));
            try {
                collection = cursor.stream().collect(Collectors.toList());
                if (cursor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IgniteInternalException("Unable to get data from storage", (Throwable)e);
                }
            }
            cursor.close();
        }
        return collection;
    }

    void putLogicalTopologyNode(ClusterNode node) {
        byte[] nodeNameBytes = node.name().getBytes(StandardCharsets.UTF_8);
        byte[] nodeIdBytes = node.id().getBytes(StandardCharsets.UTF_8);
        byte[] key = RaftStorageManager.logicalTopologyKey(nodeNameBytes, nodeIdBytes);
        byte[] prefix = Arrays.copyOf(key, key.length - nodeIdBytes.length);
        this.storage.replaceAll(prefix, key, ByteUtils.toBytes((Object)node));
    }

    void removeLogicalTopologyNodes(Set<ClusterNode> nodes) {
        Collection keys = nodes.stream().map(RaftStorageManager::logicalTopologyKey).collect(Collectors.toList());
        this.storage.removeAll(keys);
    }

    boolean isNodeInLogicalTopology(ClusterNode node) {
        byte[] value = this.storage.get(RaftStorageManager.logicalTopologyKey(node));
        return value != null;
    }

    private static byte[] logicalTopologyKey(ClusterNode node) {
        byte[] nodeNameBytes = node.name().getBytes(StandardCharsets.UTF_8);
        byte[] nodeIdBytes = node.id().getBytes(StandardCharsets.UTF_8);
        return RaftStorageManager.logicalTopologyKey(nodeNameBytes, nodeIdBytes);
    }

    private static byte[] logicalTopologyKey(byte[] nodeNameBytes, byte[] nodeIdBytes) {
        return ByteBuffer.allocate(LOGICAL_TOPOLOGY_PREFIX.length + nodeNameBytes.length + nodeIdBytes.length).put(LOGICAL_TOPOLOGY_PREFIX).put(nodeNameBytes).put(nodeIdBytes).array();
    }

    boolean isNodeValidated(String nodeId) {
        byte[] value = this.storage.get(RaftStorageManager.validatedNodeKey(nodeId));
        return value != null;
    }

    void putValidatedNode(String nodeId) {
        this.storage.put(RaftStorageManager.validatedNodeKey(nodeId), ArrayUtils.BYTE_EMPTY_ARRAY);
    }

    void removeValidatedNode(String nodeId) {
        this.storage.remove(RaftStorageManager.validatedNodeKey(nodeId));
    }

    private static byte[] validatedNodeKey(String nodeId) {
        byte[] nodeIdBytes = nodeId.getBytes(StandardCharsets.UTF_8);
        return ByteBuffer.allocate(VALIDATED_NODE_PREFIX.length + nodeIdBytes.length).put(VALIDATED_NODE_PREFIX).put(nodeIdBytes).array();
    }

    Collection<String> getValidatedNodeIds() {
        Collection collection;
        block8: {
            Cursor<String> cursor = this.storage.getWithPrefix(VALIDATED_NODE_PREFIX, (k, v) -> new String((byte[])k, VALIDATED_NODE_PREFIX.length, ((byte[])k).length - VALIDATED_NODE_PREFIX.length, StandardCharsets.UTF_8));
            Cursor<String> cursor2 = cursor;
            try {
                collection = cursor.stream().collect(Collectors.toList());
                if (cursor2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cursor2 != null) {
                        try {
                            cursor2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IgniteInternalException("Unable to get data from storage", (Throwable)e);
                }
            }
            cursor2.close();
        }
        return collection;
    }

    CompletableFuture<Void> snapshot(Path snapshotPath) {
        return this.storage.snapshot(snapshotPath);
    }

    void restoreSnapshot(Path snapshotPath) {
        this.storage.restoreSnapshot(snapshotPath);
    }
}

