/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.sql;

import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.sql.SQLException;
import org.apache.ignite.internal.cli.call.sql.SqlQueryCall;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.sql.SqlCompleter;
import org.apache.ignite.internal.cli.commands.sql.SqlReplTopLevelCliCommand;
import org.apache.ignite.internal.cli.core.CallExecutionPipelineProvider;
import org.apache.ignite.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite.internal.cli.core.call.StringCallInput;
import org.apache.ignite.internal.cli.core.exception.ExceptionHandlers;
import org.apache.ignite.internal.cli.core.exception.ExceptionWriter;
import org.apache.ignite.internal.cli.core.exception.handler.SqlExceptionHandler;
import org.apache.ignite.internal.cli.core.repl.Repl;
import org.apache.ignite.internal.cli.core.repl.executor.RegistryCommandExecutor;
import org.apache.ignite.internal.cli.core.repl.executor.ReplExecutorProvider;
import org.apache.ignite.internal.cli.decorators.PlainTableDecorator;
import org.apache.ignite.internal.cli.decorators.SqlQueryResultDecorator;
import org.apache.ignite.internal.cli.decorators.TableDecorator;
import org.apache.ignite.internal.cli.deprecated.IgniteCliException;
import org.apache.ignite.internal.cli.sql.SqlManager;
import org.apache.ignite.internal.cli.sql.SqlSchemaProvider;
import picocli.CommandLine;

@CommandLine.Command(name="sql", description={"Executes SQL query"})
public class SqlReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Option(names={"-u", "--jdbc-url"}, required=true, descriptionKey="ignite.jdbc-url", description={"JDBC url to ignite cluster"})
    private String jdbc;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting"})
    private boolean plain;
    @CommandLine.ArgGroup
    private ExecOptions execOptions;
    @Inject
    private ReplExecutorProvider replExecutorProvider;

    private static String extract(File file) {
        try {
            return String.join((CharSequence)"\n", Files.readAllLines(file.toPath(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IgniteCliException("File with command not found");
        }
    }

    @Override
    public void run() {
        try (SqlManager sqlManager = new SqlManager(this.jdbc);){
            if (this.execOptions == null || this.execOptions.command.isBlank()) {
                this.replExecutorProvider.get().execute(Repl.builder().withPromptProvider(() -> "sql-cli> ").withCompleter(new SqlCompleter(new SqlSchemaProvider(sqlManager::getMetadata))).withCommandClass(SqlReplTopLevelCliCommand.class).withCallExecutionPipelineProvider(this.provider(sqlManager)).withHistoryFileName("sqlhistory").build());
            } else {
                String executeCommand = this.execOptions.file != null ? SqlReplCommand.extract(this.execOptions.file) : this.execOptions.command;
                this.createSqlExecPipeline(sqlManager, executeCommand).runPipeline();
            }
        }
        catch (SQLException e) {
            new SqlExceptionHandler().handle(ExceptionWriter.fromPrintWriter(this.spec.commandLine().getErr()), e);
        }
    }

    private CallExecutionPipelineProvider provider(SqlManager sqlManager) {
        return (executor, exceptionHandlers, line) -> executor.hasCommand(line) ? this.createInternalCommandPipeline(executor, exceptionHandlers, line) : this.createSqlExecPipeline(sqlManager, line);
    }

    private CallExecutionPipeline<?, ?> createSqlExecPipeline(SqlManager sqlManager, String line) {
        TableDecorator tableDecorator = this.plain ? new PlainTableDecorator() : new TableDecorator();
        return CallExecutionPipeline.builder(new SqlQueryCall(sqlManager)).inputProvider(() -> new StringCallInput(line)).output(this.spec.commandLine().getOut()).errOutput(this.spec.commandLine().getErr()).decorator(new SqlQueryResultDecorator(tableDecorator)).verbose(this.verbose).build();
    }

    private CallExecutionPipeline<?, ?> createInternalCommandPipeline(RegistryCommandExecutor call, ExceptionHandlers exceptionHandlers, String line) {
        return CallExecutionPipeline.builder(call).inputProvider(() -> new StringCallInput(line)).output(this.spec.commandLine().getOut()).errOutput(this.spec.commandLine().getErr()).exceptionHandlers(exceptionHandlers).verbose(this.verbose).build();
    }

    private static class ExecOptions {
        @CommandLine.Parameters(index="0", description={"SQL query to execute"})
        private String command;
        @CommandLine.Option(names={"-f", "--script-file"}, description={"Path to file with SQL commands to execute"})
        private File file;

        private ExecOptions() {
        }
    }
}

