/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.app;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgnitionManager;
import org.apache.ignite.client.handler.ClientHandlerModule;
import org.apache.ignite.compute.IgniteCompute;
import org.apache.ignite.configuration.schemas.network.NetworkConfiguration;
import org.apache.ignite.internal.app.LifecycleManager;
import org.apache.ignite.internal.baseline.BaselineManager;
import org.apache.ignite.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite.internal.cluster.management.network.messages.CmgMessagesSerializationRegistryInitializer;
import org.apache.ignite.internal.cluster.management.raft.ClusterStateStorage;
import org.apache.ignite.internal.cluster.management.raft.RocksDbClusterStateStorage;
import org.apache.ignite.internal.cluster.management.rest.ClusterManagementRestFactory;
import org.apache.ignite.internal.components.LongJvmPauseDetector;
import org.apache.ignite.internal.compute.ComputeComponent;
import org.apache.ignite.internal.compute.ComputeComponentImpl;
import org.apache.ignite.internal.compute.ComputeMessagesSerializationRegistryInitializer;
import org.apache.ignite.internal.compute.IgniteComputeImpl;
import org.apache.ignite.internal.compute.configuration.ComputeConfiguration;
import org.apache.ignite.internal.configuration.ConfigurationManager;
import org.apache.ignite.internal.configuration.ConfigurationModule;
import org.apache.ignite.internal.configuration.ConfigurationModules;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.configuration.ServiceLoaderModulesProvider;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.storage.DistributedConfigurationStorage;
import org.apache.ignite.internal.configuration.storage.LocalConfigurationStorage;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.hlc.HybridClockImpl;
import org.apache.ignite.internal.index.IndexManager;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.server.KeyValueStorage;
import org.apache.ignite.internal.metastorage.server.persistence.RocksDbKeyValueStorage;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.internal.metrics.MetricSource;
import org.apache.ignite.internal.metrics.configuration.MetricConfiguration;
import org.apache.ignite.internal.metrics.rest.MetricRestFactory;
import org.apache.ignite.internal.metrics.sources.JvmMetricSource;
import org.apache.ignite.internal.raft.Loza;
import org.apache.ignite.internal.raft.configuration.RaftConfiguration;
import org.apache.ignite.internal.raft.storage.impl.LogStorageFactoryCreator;
import org.apache.ignite.internal.raft.storage.impl.VolatileLogStorageFactoryCreator;
import org.apache.ignite.internal.recovery.ConfigurationCatchUpListener;
import org.apache.ignite.internal.recovery.RecoveryCompletionFutureFactory;
import org.apache.ignite.internal.replicator.ReplicaManager;
import org.apache.ignite.internal.replicator.ReplicaService;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesSerializationRegistryInitializer;
import org.apache.ignite.internal.rest.RestComponent;
import org.apache.ignite.internal.rest.configuration.PresentationsFactory;
import org.apache.ignite.internal.rest.configuration.RestConfiguration;
import org.apache.ignite.internal.rest.node.NodeManagementRestFactory;
import org.apache.ignite.internal.schema.SchemaManager;
import org.apache.ignite.internal.schema.configuration.TablesConfiguration;
import org.apache.ignite.internal.sql.api.IgniteSqlImpl;
import org.apache.ignite.internal.sql.engine.QueryProcessor;
import org.apache.ignite.internal.sql.engine.SqlQueryProcessor;
import org.apache.ignite.internal.sql.engine.message.SqlQueryMessagesSerializationRegistryInitializer;
import org.apache.ignite.internal.storage.DataStorageManager;
import org.apache.ignite.internal.storage.DataStorageModule;
import org.apache.ignite.internal.storage.DataStorageModules;
import org.apache.ignite.internal.table.IgniteTablesInternal;
import org.apache.ignite.internal.table.distributed.TableManager;
import org.apache.ignite.internal.table.distributed.TableMessageGroup;
import org.apache.ignite.internal.table.distributed.TableMessagesSerializationRegistryInitializer;
import org.apache.ignite.internal.tx.LockManager;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.impl.HeapLockManager;
import org.apache.ignite.internal.tx.impl.IgniteTransactionsImpl;
import org.apache.ignite.internal.tx.impl.TxManagerImpl;
import org.apache.ignite.internal.tx.message.TxMessageGroup;
import org.apache.ignite.internal.tx.message.TxMessagesSerializationRegistryInitializer;
import org.apache.ignite.internal.vault.VaultManager;
import org.apache.ignite.internal.vault.VaultService;
import org.apache.ignite.internal.vault.persistence.PersistentVaultService;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.lang.NodeStoppingException;
import org.apache.ignite.network.ClusterLocalConfiguration;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.ClusterService;
import org.apache.ignite.network.MessageSerializationRegistryImpl;
import org.apache.ignite.network.NettyBootstrapFactory;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.network.scalecube.ScaleCubeClusterServiceFactory;
import org.apache.ignite.network.serialization.MessageSerializationRegistry;
import org.apache.ignite.raft.jraft.RaftMessagesSerializationRegistryInitializer;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.table.manager.IgniteTables;
import org.apache.ignite.tx.IgniteTransactions;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class IgniteImpl
implements Ignite {
    private static final IgniteLogger LOG = Loggers.forClass(IgniteImpl.class);
    private static final Path VAULT_DB_PATH = Paths.get("vault", new String[0]);
    private static final Path METASTORAGE_DB_PATH = Paths.get("metastorage", new String[0]);
    private static final Path CMG_DB_PATH = Paths.get("cmg", new String[0]);
    private static final Path PARTITIONS_STORE_PATH = Paths.get("db", new String[0]);
    private final String name;
    private final LifecycleManager lifecycleManager;
    private final VaultManager vaultMgr;
    private final SqlQueryProcessor qryEngine;
    private final IgniteSql sql;
    private final ConfigurationManager nodeCfgMgr;
    private final ClusterService clusterSvc;
    private final ComputeComponent computeComponent;
    private final NettyBootstrapFactory nettyBootstrapFactory;
    private final Loza raftMgr;
    private final MetaStorageManager metaStorageMgr;
    private final ConfigurationManager clusterCfgMgr;
    private final BaselineManager baselineMgr;
    private final ReplicaManager replicaMgr;
    private final TxManager txManager;
    private final TableManager distributedTblMgr;
    private final IndexManager indexManager;
    private final RestComponent restComponent;
    private final ClusterManagementGroupManager cmgMgr;
    private final ClientHandlerModule clientHandlerModule;
    private final ConfigurationStorage cfgStorage;
    private final IgniteCompute compute;
    private final LongJvmPauseDetector longJvmPauseDetector;
    private final DataStorageManager dataStorageMgr;
    private final SchemaManager schemaManager;
    private final MetricManager metricManager;
    private final VolatileLogStorageFactoryCreator volatileLogStorageFactoryCreator;
    private final HybridClock clock;

    IgniteImpl(String name, Path workDir, @Nullable ClassLoader serviceProviderClassLoader) {
        this.name = name;
        this.longJvmPauseDetector = new LongJvmPauseDetector(name, Loggers.forClass(LongJvmPauseDetector.class));
        this.lifecycleManager = new LifecycleManager(name);
        this.vaultMgr = IgniteImpl.createVault(workDir);
        this.metricManager = new MetricManager();
        ConfigurationModules modules = IgniteImpl.loadConfigurationModules(serviceProviderClassLoader);
        this.nodeCfgMgr = new ConfigurationManager(modules.local().rootKeys(), modules.local().validators(), (ConfigurationStorage)new LocalConfigurationStorage(this.vaultMgr), modules.local().internalSchemaExtensions(), modules.local().polymorphicSchemaExtensions());
        NetworkConfiguration networkConfiguration = (NetworkConfiguration)this.nodeCfgMgr.configurationRegistry().getConfiguration(NetworkConfiguration.KEY);
        MessageSerializationRegistryImpl serializationRegistry = new MessageSerializationRegistryImpl();
        CmgMessagesSerializationRegistryInitializer.registerFactories((MessageSerializationRegistry)serializationRegistry);
        RaftMessagesSerializationRegistryInitializer.registerFactories((MessageSerializationRegistry)serializationRegistry);
        SqlQueryMessagesSerializationRegistryInitializer.registerFactories((MessageSerializationRegistry)serializationRegistry);
        TxMessagesSerializationRegistryInitializer.registerFactories((MessageSerializationRegistry)serializationRegistry);
        ComputeMessagesSerializationRegistryInitializer.registerFactories((MessageSerializationRegistry)serializationRegistry);
        TableMessagesSerializationRegistryInitializer.registerFactories((MessageSerializationRegistry)serializationRegistry);
        ReplicaMessagesSerializationRegistryInitializer.registerFactories((MessageSerializationRegistry)serializationRegistry);
        ClusterLocalConfiguration clusterLocalConfiguration = new ClusterLocalConfiguration(name, (MessageSerializationRegistry)serializationRegistry);
        this.nettyBootstrapFactory = new NettyBootstrapFactory(networkConfiguration, clusterLocalConfiguration.getName());
        this.clusterSvc = new ScaleCubeClusterServiceFactory().createClusterService(clusterLocalConfiguration, networkConfiguration, this.nettyBootstrapFactory);
        this.computeComponent = new ComputeComponentImpl((Ignite)this, this.clusterSvc.messagingService(), (ComputeConfiguration)this.nodeCfgMgr.configurationRegistry().getConfiguration(ComputeConfiguration.KEY));
        this.clock = new HybridClockImpl();
        this.raftMgr = new Loza(this.clusterSvc, (RaftConfiguration)this.nodeCfgMgr.configurationRegistry().getConfiguration(RaftConfiguration.KEY), workDir, this.clock);
        HeapLockManager lockMgr = new HeapLockManager();
        this.replicaMgr = new ReplicaManager(this.clusterSvc, this.clock, Set.of(TableMessageGroup.class, TxMessageGroup.class));
        ReplicaService replicaSvc = new ReplicaService(this.clusterSvc.messagingService(), this.clock);
        this.txManager = new TxManagerImpl(replicaSvc, (LockManager)lockMgr, this.clock);
        this.cmgMgr = new ClusterManagementGroupManager(this.vaultMgr, this.clusterSvc, this.raftMgr, (ClusterStateStorage)new RocksDbClusterStateStorage(workDir.resolve(CMG_DB_PATH)));
        this.metaStorageMgr = new MetaStorageManager(this.vaultMgr, this.clusterSvc, this.cmgMgr, this.raftMgr, (KeyValueStorage)new RocksDbKeyValueStorage(workDir.resolve(METASTORAGE_DB_PATH)));
        this.cfgStorage = new DistributedConfigurationStorage(this.metaStorageMgr, this.vaultMgr);
        this.clusterCfgMgr = new ConfigurationManager(modules.distributed().rootKeys(), modules.distributed().validators(), this.cfgStorage, modules.distributed().internalSchemaExtensions(), modules.distributed().polymorphicSchemaExtensions());
        this.metricManager.configure((MetricConfiguration)this.clusterCfgMgr.configurationRegistry().getConfiguration(MetricConfiguration.KEY));
        this.restComponent = this.createRestComponent(name);
        this.baselineMgr = new BaselineManager(this.clusterCfgMgr, this.metaStorageMgr, this.clusterSvc);
        Consumer<Function> registry = c -> this.clusterCfgMgr.configurationRegistry().listenUpdateStorageRevision(c::apply);
        DataStorageModules dataStorageModules = new DataStorageModules(ServiceLoader.load(DataStorageModule.class, serviceProviderClassLoader));
        Path storagePath = IgniteImpl.getPartitionsStorePath(workDir);
        TablesConfiguration tablesConfiguration = (TablesConfiguration)this.clusterCfgMgr.configurationRegistry().getConfiguration(TablesConfiguration.KEY);
        this.dataStorageMgr = new DataStorageManager(tablesConfiguration, dataStorageModules.createStorageEngines(name, this.clusterCfgMgr.configurationRegistry(), storagePath, this.longJvmPauseDetector));
        this.schemaManager = new SchemaManager(registry, tablesConfiguration);
        this.volatileLogStorageFactoryCreator = new VolatileLogStorageFactoryCreator(workDir.resolve("volatile-log-spillout"));
        this.distributedTblMgr = new TableManager(name, registry, tablesConfiguration, this.raftMgr, this.replicaMgr, (LockManager)lockMgr, replicaSvc, this.baselineMgr, this.clusterSvc.topologyService(), this.txManager, this.dataStorageMgr, storagePath, this.metaStorageMgr, this.schemaManager, (LogStorageFactoryCreator)this.volatileLogStorageFactoryCreator, this.clock);
        this.indexManager = new IndexManager(tablesConfiguration, this.schemaManager, this.distributedTblMgr);
        this.qryEngine = new SqlQueryProcessor(registry, this.clusterSvc, this.distributedTblMgr, this.indexManager, this.schemaManager, this.dataStorageMgr, this.txManager, () -> dataStorageModules.collectSchemasFields(modules.distributed().polymorphicSchemaExtensions()), this.clock);
        this.sql = new IgniteSqlImpl((QueryProcessor)this.qryEngine);
        this.compute = new IgniteComputeImpl(this.clusterSvc.topologyService(), (IgniteTablesInternal)this.distributedTblMgr, this.computeComponent);
        this.clientHandlerModule = new ClientHandlerModule((QueryProcessor)this.qryEngine, (IgniteTablesInternal)this.distributedTblMgr, (IgniteTransactions)new IgniteTransactionsImpl(this.txManager), this.nodeCfgMgr.configurationRegistry(), this.compute, this.clusterSvc, this.nettyBootstrapFactory, this.sql);
    }

    private RestComponent createRestComponent(String name) {
        PresentationsFactory presentationsFactory = new PresentationsFactory(this.nodeCfgMgr, this.clusterCfgMgr);
        ClusterManagementRestFactory clusterManagementRestFactory = new ClusterManagementRestFactory(this.clusterSvc, this.cmgMgr);
        NodeManagementRestFactory nodeManagementRestFactory = new NodeManagementRestFactory(this.lifecycleManager, () -> name);
        MetricRestFactory nodeMetricRestFactory = new MetricRestFactory(this.metricManager);
        RestConfiguration restConfiguration = (RestConfiguration)this.nodeCfgMgr.configurationRegistry().getConfiguration(RestConfiguration.KEY);
        return new RestComponent(List.of(presentationsFactory, clusterManagementRestFactory, nodeManagementRestFactory, nodeMetricRestFactory), restConfiguration);
    }

    private static ConfigurationModules loadConfigurationModules(ClassLoader classLoader) {
        ServiceLoaderModulesProvider modulesProvider = new ServiceLoaderModulesProvider();
        List<ConfigurationModule> modules = modulesProvider.modules(classLoader);
        if (modules.isEmpty()) {
            throw new IllegalStateException("No configuration modules were loaded, this means Ignite cannot start. Please make sure that the classloader for loading services is correct.");
        }
        ConfigurationModules configModules = new ConfigurationModules(modules);
        LOG.info("Configuration modules loaded [modules={}, localRoots={}, distRoots={}]", new Object[]{modules, configModules.local().rootKeys(), configModules.distributed().rootKeys()});
        return configModules;
    }

    public CompletableFuture<Ignite> start(@Language(value="HOCON") @Nullable String cfg) {
        try {
            this.metricManager.registerSource((MetricSource)new JvmMetricSource());
            this.lifecycleManager.startComponent((IgniteComponent)this.longJvmPauseDetector);
            this.lifecycleManager.startComponent((IgniteComponent)this.vaultMgr);
            this.vaultMgr.putName(this.name).get();
            this.lifecycleManager.startComponent((IgniteComponent)this.nodeCfgMgr);
            if (cfg != null) {
                try {
                    this.nodeCfgMgr.bootstrap(cfg);
                }
                catch (Exception e2) {
                    throw new IgniteException("Unable to parse user-specific configuration", (Throwable)e2);
                }
            } else {
                this.nodeCfgMgr.configurationRegistry().initializeDefaults();
            }
            this.lifecycleManager.startComponents(new IgniteComponent[]{this.nettyBootstrapFactory, this.clusterSvc, this.restComponent, this.raftMgr, this.cmgMgr});
            LOG.info("Components started, joining the cluster", new Object[0]);
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.cmgMgr.joinFuture().thenRunAsync(() -> {
                LOG.info("Join complete, starting the remaining components", new Object[0]);
                try {
                    this.lifecycleManager.startComponents(new IgniteComponent[]{this.metaStorageMgr, this.clusterCfgMgr, this.metricManager, this.computeComponent, this.replicaMgr, this.txManager, this.baselineMgr, this.dataStorageMgr, this.schemaManager, this.volatileLogStorageFactoryCreator, this.distributedTblMgr, this.indexManager, this.qryEngine, this.clientHandlerModule});
                }
                catch (NodeStoppingException e) {
                    throw new CompletionException(e);
                }
            })).thenCompose(v -> {
                LOG.info("Components started, performing recovery", new Object[0]);
                CompletableFuture<Void> recoveryFuture = RecoveryCompletionFutureFactory.create(this.clusterCfgMgr, fut -> new ConfigurationCatchUpListener(this.cfgStorage, (CompletableFuture<Void>)fut, LOG));
                return this.notifyConfigurationListeners().thenCompose(t -> {
                    try {
                        this.metaStorageMgr.deployWatches();
                    }
                    catch (NodeStoppingException e) {
                        throw new CompletionException(e);
                    }
                    return recoveryFuture;
                });
            })).thenCompose(v -> {
                LOG.info("Recovery complete, finishing join", new Object[0]);
                return this.cmgMgr.onJoinReady();
            })).thenRun(() -> {
                try {
                    this.lifecycleManager.onStartComplete();
                }
                catch (NodeStoppingException e) {
                    throw new CompletionException(e);
                }
            })).handle((v, e) -> {
                if (e != null) {
                    throw this.handleStartException((Throwable)e);
                }
                return this;
            });
        }
        catch (Throwable e3) {
            throw this.handleStartException(e3);
        }
    }

    private RuntimeException handleStartException(Throwable e) {
        String errMsg = "Unable to start [node=" + this.name + "]";
        LOG.debug(errMsg, e);
        this.lifecycleManager.stopNode();
        return new IgniteException(errMsg, e);
    }

    public void stop() {
        this.lifecycleManager.stopNode();
    }

    public IgniteTables tables() {
        return this.distributedTblMgr;
    }

    public QueryProcessor queryEngine() {
        return this.qryEngine;
    }

    @TestOnly
    public IndexManager indexManager() {
        return this.indexManager;
    }

    public IgniteTransactions transactions() {
        return new IgniteTransactionsImpl(this.txManager);
    }

    public IgniteSql sql() {
        return this.sql;
    }

    public void close() {
        IgnitionManager.stop((String)this.name);
    }

    public String name() {
        return this.name;
    }

    public IgniteCompute compute() {
        return this.compute;
    }

    public Collection<ClusterNode> clusterNodes() {
        return this.clusterSvc.topologyService().allMembers();
    }

    public CompletableFuture<Collection<ClusterNode>> clusterNodesAsync() {
        return CompletableFuture.completedFuture(this.clusterNodes());
    }

    public ConfigurationRegistry nodeConfiguration() {
        return this.nodeCfgMgr.configurationRegistry();
    }

    public ConfigurationRegistry clusterConfiguration() {
        return this.clusterCfgMgr.configurationRegistry();
    }

    public String id() {
        return this.clusterSvc.topologyService().localMember().id();
    }

    public NetworkAddress restAddress() {
        return new NetworkAddress(this.restComponent.host(), this.restComponent.port());
    }

    public NetworkAddress clientAddress() {
        return NetworkAddress.from((InetSocketAddress)this.clientHandlerModule.localAddress());
    }

    public void init(Collection<String> metaStorageNodeNames, Collection<String> cmgNodeNames, String clusterName) throws NodeStoppingException {
        this.cmgMgr.initCluster(metaStorageNodeNames, cmgNodeNames, clusterName);
    }

    private CompletableFuture<Void> notifyConfigurationListeners() {
        return CompletableFuture.allOf(this.nodeConfiguration().notifyCurrentConfigurationListeners(), this.clusterConfiguration().notifyCurrentConfigurationListeners());
    }

    private static VaultManager createVault(Path workDir) {
        Path vaultPath = workDir.resolve(VAULT_DB_PATH);
        try {
            Files.createDirectories(vaultPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IgniteInternalException((Throwable)e);
        }
        return new VaultManager((VaultService)new PersistentVaultService(vaultPath));
    }

    @NotNull
    private static Path getPartitionsStorePath(Path workDir) {
        Path partitionsStore = workDir.resolve(PARTITIONS_STORE_PATH);
        try {
            Files.createDirectories(partitionsStore, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IgniteInternalException("Failed to create directory for partitions storage: " + e.getMessage(), (Throwable)e);
        }
        return partitionsStore;
    }

    @TestOnly
    public Loza raftManager() {
        return this.raftMgr;
    }

    @TestOnly
    public ClusterNode node() {
        return this.clusterSvc.topologyService().localMember();
    }
}

