/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.marshaller.asm;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.ClassGenerator;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.control.TryCatch;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import java.io.StringWriter;
import java.io.Writer;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.processing.Generated;
import jdk.jfr.Experimental;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.ByteBufferRow;
import org.apache.ignite.internal.schema.Columns;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.marshaller.BinaryMode;
import org.apache.ignite.internal.schema.marshaller.KvMarshaller;
import org.apache.ignite.internal.schema.marshaller.MarshallerException;
import org.apache.ignite.internal.schema.marshaller.MarshallerFactory;
import org.apache.ignite.internal.schema.marshaller.MarshallerUtil;
import org.apache.ignite.internal.schema.marshaller.RecordMarshaller;
import org.apache.ignite.internal.schema.marshaller.asm.ColumnAccessCodeGenerator;
import org.apache.ignite.internal.schema.marshaller.asm.IdentityMarshallerCodeGenerator;
import org.apache.ignite.internal.schema.marshaller.asm.MarshallerCodeGenerator;
import org.apache.ignite.internal.schema.marshaller.asm.ObjectMarshallerCodeGenerator;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.schema.row.RowAssembler;
import org.apache.ignite.internal.util.ObjectFactory;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.table.mapper.Mapper;

@Experimental
public class AsmMarshallerGenerator
implements MarshallerFactory {
    private static final IgniteLogger LOG = Loggers.forClass(AsmMarshallerGenerator.class);
    public static final String MARSHALLER_PACKAGE_NAME = "org.apache.ignite.internal.schema.marshaller";
    public static final String MARSHALLER_CLASS_NAME_PREFIX = "MarshallerForSchema_";
    private final boolean dumpCode = LOG.isTraceEnabled();

    @Override
    public <K, V> KvMarshaller<K, V> create(SchemaDescriptor schema, Mapper<K> keyMapper, Mapper<V> valueMapper) {
        String className = MARSHALLER_CLASS_NAME_PREFIX + schema.version();
        Class keyClass = keyMapper.targetType();
        Class valClass = valueMapper.targetType();
        StringWriter writer = new StringWriter();
        try {
            long generation = System.nanoTime();
            ClassDefinition classDef = this.generateMarshallerClass(className, schema, keyClass, valClass);
            long compilationTime = System.nanoTime();
            generation = compilationTime - generation;
            ClassGenerator generator = ClassGenerator.classGenerator((ClassLoader)AsmMarshallerGenerator.getClassLoader());
            if (this.dumpCode) {
                generator.outputTo((Writer)writer).fakeLineNumbers(true).runAsmVerifier(true).dumpRawBytecode(true);
            }
            Class aClass = generator.defineClass(classDef, KvMarshaller.class);
            compilationTime = System.nanoTime() - compilationTime;
            if (LOG.isTraceEnabled()) {
                LOG.trace("ASM marshaller created: codeGenStage={}us, compileStage={}us. Code: {}", new Object[]{TimeUnit.NANOSECONDS.toMicros(generation), TimeUnit.NANOSECONDS.toMicros(compilationTime), writer});
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("ASM marshaller created: codeGenStage={}us, compileStage={}us.", new Object[]{TimeUnit.NANOSECONDS.toMicros(generation), TimeUnit.NANOSECONDS.toMicros(compilationTime)});
            }
            return (KvMarshaller)aClass.getDeclaredConstructor(SchemaDescriptor.class, ObjectFactory.class, ObjectFactory.class).newInstance(schema, MarshallerUtil.factoryForClass(keyClass), MarshallerUtil.factoryForClass(valClass));
        }
        catch (Exception | LinkageError e) {
            throw new IllegalArgumentException("Failed to create marshaller for key-value pair: schemaVer=" + schema.version() + ", keyClass=" + keyClass.getSimpleName() + ", valueClass=" + valClass.getSimpleName(), e);
        }
    }

    @Override
    public <R> RecordMarshaller<R> create(SchemaDescriptor schema, Mapper<R> mapper) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    private ClassDefinition generateMarshallerClass(String className, SchemaDescriptor schema, Class<?> keyClass, Class<?> valClass) {
        MarshallerCodeGenerator keyMarsh = AsmMarshallerGenerator.createMarshaller(keyClass, schema.keyColumns(), 0);
        MarshallerCodeGenerator valMarsh = AsmMarshallerGenerator.createMarshaller(valClass, schema.valueColumns(), schema.keyColumns().length());
        ClassDefinition classDef = new ClassDefinition(EnumSet.of(Access.PUBLIC), MARSHALLER_PACKAGE_NAME.replace('.', '/') + "/" + className, ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(KvMarshaller.class)});
        classDef.declareAnnotation(Generated.class).setValue("value", this.getClass().getCanonicalName());
        FieldDefinition keyClassField = classDef.declareField(EnumSet.of(Access.PRIVATE, Access.STATIC, Access.FINAL), "KEY_CLASS", Class.class);
        FieldDefinition valueClassField = classDef.declareField(EnumSet.of(Access.PRIVATE, Access.STATIC, Access.FINAL), "VALUE_CLASS", Class.class);
        keyMarsh.initStaticHandlers(classDef, keyClassField);
        valMarsh.initStaticHandlers(classDef, valueClassField);
        this.generateFieldsAndConstructor(classDef);
        this.generateAssemblerFactoryMethod(classDef, schema, keyMarsh, valMarsh);
        this.generateSchemaVersionMethod(classDef, schema);
        this.generateMarshalMethod(classDef, keyMarsh, valMarsh);
        this.generateUnmarshalKeyMethod(classDef, keyMarsh);
        this.generateUnmarshalValueMethod(classDef, valMarsh);
        return classDef;
    }

    private void generateSchemaVersionMethod(ClassDefinition classDef, SchemaDescriptor schema) {
        MethodDefinition methodDef = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "schemaVersion", ParameterizedType.type(Integer.TYPE), new Parameter[0]).addException(MarshallerException.class);
        methodDef.declareAnnotation(Override.class);
        methodDef.getBody().push(schema.version()).retInt();
    }

    private static MarshallerCodeGenerator createMarshaller(Class<?> cls, Columns columns, int firstColIdx) {
        BinaryMode mode = MarshallerUtil.mode(cls);
        if (mode == BinaryMode.POJO) {
            return new ObjectMarshallerCodeGenerator(columns, cls, firstColIdx);
        }
        return new IdentityMarshallerCodeGenerator(ColumnAccessCodeGenerator.createAccessor(mode, null, firstColIdx));
    }

    private void generateFieldsAndConstructor(ClassDefinition classDef) {
        classDef.declareField(EnumSet.of(Access.PRIVATE, Access.FINAL), "keyFactory", ParameterizedType.type(ObjectFactory.class));
        classDef.declareField(EnumSet.of(Access.PRIVATE, Access.FINAL), "valFactory", ParameterizedType.type(ObjectFactory.class));
        classDef.declareField(EnumSet.of(Access.PRIVATE, Access.FINAL), "schema", ParameterizedType.type(SchemaDescriptor.class));
        MethodDefinition constrDef = classDef.declareConstructor(EnumSet.of(Access.PUBLIC), new Parameter[]{Parameter.arg((String)"schema", SchemaDescriptor.class), Parameter.arg((String)"keyFactory", (ParameterizedType)ParameterizedType.type(ObjectFactory.class)), Parameter.arg((String)"valFactory", (ParameterizedType)ParameterizedType.type(ObjectFactory.class))});
        constrDef.getBody().append((BytecodeNode)constrDef.getThis()).invokeConstructor(classDef.getSuperClass(), new ParameterizedType[0]).append((BytecodeNode)constrDef.getThis().setField("schema", (BytecodeExpression)constrDef.getScope().getVariable("schema"))).append((BytecodeNode)constrDef.getThis().setField("keyFactory", (BytecodeExpression)constrDef.getScope().getVariable("keyFactory"))).append((BytecodeNode)constrDef.getThis().setField("valFactory", (BytecodeExpression)constrDef.getScope().getVariable("valFactory"))).ret();
    }

    private void generateAssemblerFactoryMethod(ClassDefinition classDef, SchemaDescriptor schema, MarshallerCodeGenerator keyMarsh, MarshallerCodeGenerator valMarsh) {
        int i;
        Variable tmp;
        MethodDefinition methodDef = classDef.declareMethod(EnumSet.of(Access.PRIVATE), "createAssembler", ParameterizedType.type(RowAssembler.class), new Parameter[]{Parameter.arg((String)"key", Object.class), Parameter.arg((String)"val", Object.class)});
        Scope scope = methodDef.getScope();
        BytecodeBlock body = methodDef.getBody();
        Variable varlenKeyCols = scope.declareVariable("varlenKeyCols", body, BytecodeExpressions.defaultValue(Integer.TYPE));
        Variable varlenValueCols = scope.declareVariable("varlenValueCols", body, BytecodeExpressions.defaultValue(Integer.TYPE));
        Variable keyCols = scope.declareVariable(Columns.class, "keyCols");
        Variable valCols = scope.declareVariable(Columns.class, "valCols");
        body.append((BytecodeNode)keyCols.set(methodDef.getThis().getField("schema", SchemaDescriptor.class).invoke("keyColumns", Columns.class, new BytecodeExpression[0])));
        body.append((BytecodeNode)valCols.set(methodDef.getThis().getField("schema", SchemaDescriptor.class).invoke("valueColumns", Columns.class, new BytecodeExpression[0])));
        Columns columns = schema.keyColumns();
        if (columns.hasVarlengthColumns()) {
            tmp = scope.createTempVariable(Object.class);
            for (i = columns.firstVarlengthColumn(); i < columns.length(); ++i) {
                assert (!columns.column(i).type().spec().fixedLength());
                body.append(keyMarsh.getValue(classDef.getType(), scope.getVariable("key"), i)).putVariable(tmp);
                body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.isNotNull((BytecodeExpression)tmp)).ifTrue((BytecodeNode)new BytecodeBlock().append((BytecodeNode)varlenKeyCols.increment())));
            }
        }
        if ((columns = schema.valueColumns()).hasVarlengthColumns()) {
            tmp = scope.createTempVariable(Object.class);
            for (i = columns.firstVarlengthColumn(); i < columns.length(); ++i) {
                assert (!columns.column(i).type().spec().fixedLength());
                body.append(valMarsh.getValue(classDef.getType(), scope.getVariable("val"), i)).putVariable(tmp);
                body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.isNotNull((BytecodeExpression)tmp)).ifTrue((BytecodeNode)new BytecodeBlock().append((BytecodeNode)varlenValueCols.increment())));
            }
        }
        body.append((BytecodeNode)BytecodeExpressions.newInstance(RowAssembler.class, (BytecodeExpression[])new BytecodeExpression[]{methodDef.getThis().getField("schema", SchemaDescriptor.class), varlenKeyCols, varlenValueCols}));
        body.retObject();
    }

    private void generateMarshalMethod(ClassDefinition classDef, MarshallerCodeGenerator keyMarsh, MarshallerCodeGenerator valMarsh) {
        MethodDefinition methodDef = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "marshal", ParameterizedType.type(Row.class), new Parameter[]{Parameter.arg((String)"key", Object.class), Parameter.arg((String)"val", Object.class)}).addException(MarshallerException.class);
        methodDef.declareAnnotation(Override.class);
        Variable asm = methodDef.getScope().createTempVariable(RowAssembler.class);
        methodDef.getBody().append((BytecodeNode)asm.set(methodDef.getScope().getThis().invoke("createAssembler", RowAssembler.class, new BytecodeExpression[]{methodDef.getScope().getVariable("key"), methodDef.getScope().getVariable("val")}))).append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.isNull((BytecodeExpression)asm)).ifTrue((BytecodeNode)new BytecodeBlock().append((BytecodeNode)BytecodeExpressions.newInstance(IgniteInternalException.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantString((String)"ASM can't be null.")})).throwObject()));
        BytecodeBlock block = new BytecodeBlock();
        block.append(keyMarsh.marshallObject(classDef.getType(), asm, methodDef.getScope().getVariable("key"))).append(valMarsh.marshallObject(classDef.getType(), asm, methodDef.getScope().getVariable("val"))).append((BytecodeNode)BytecodeExpressions.newInstance(Row.class, (BytecodeExpression[])new BytecodeExpression[]{methodDef.getThis().getField("schema", SchemaDescriptor.class), BytecodeExpressions.newInstance(ByteBufferRow.class, (BytecodeExpression[])new BytecodeExpression[]{asm.invoke("toBytes", byte[].class, new BytecodeExpression[0])}).cast(BinaryRow.class)})).retObject();
        Variable ex = methodDef.getScope().createTempVariable(Throwable.class);
        methodDef.getBody().append((BytecodeNode)new TryCatch((BytecodeNode)block, (BytecodeNode)new BytecodeBlock().putVariable(ex).append((BytecodeNode)BytecodeExpressions.newInstance(MarshallerException.class, (BytecodeExpression[])new BytecodeExpression[]{ex})).throwObject(), ParameterizedType.type(Throwable.class)));
    }

    private void generateUnmarshalKeyMethod(ClassDefinition classDef, MarshallerCodeGenerator keyMarsh) {
        MethodDefinition methodDef = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "unmarshalKey", ParameterizedType.type(Object.class), new Parameter[]{Parameter.arg((String)"row", Row.class)}).addException(MarshallerException.class);
        methodDef.declareAnnotation(Override.class);
        Variable objVar = methodDef.getScope().declareVariable(Object.class, "obj");
        Variable objFactory = methodDef.getScope().declareVariable("factory", methodDef.getBody(), methodDef.getThis().getField("keyFactory", ObjectFactory.class));
        methodDef.getBody().append(keyMarsh.unmarshallObject(classDef.getType(), methodDef.getScope().getVariable("row"), objVar, objFactory)).append((BytecodeNode)objVar).retObject();
    }

    private void generateUnmarshalValueMethod(ClassDefinition classDef, MarshallerCodeGenerator valMarsh) {
        MethodDefinition methodDef = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "unmarshalValue", ParameterizedType.type(Object.class), new Parameter[]{Parameter.arg((String)"row", Row.class)}).addException(MarshallerException.class);
        methodDef.declareAnnotation(Override.class);
        Variable obj = methodDef.getScope().declareVariable(Object.class, "obj");
        Variable objFactory = methodDef.getScope().declareVariable("factory", methodDef.getBody(), methodDef.getThis().getField("valFactory", ObjectFactory.class));
        methodDef.getBody().append(valMarsh.unmarshallObject(classDef.getType(), methodDef.getScope().getVariable("row"), obj, objFactory)).append((BytecodeNode)obj).retObject();
    }

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader() == null ? ClassLoader.getSystemClassLoader() : Thread.currentThread().getContextClassLoader();
    }
}

