/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.jdbc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.internal.jdbc.proto.event.JdbcColumnMeta;
import org.apache.ignite.internal.jdbc.proto.event.JdbcPrimaryKeyMeta;
import org.apache.ignite.internal.jdbc.proto.event.JdbcTableMeta;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.table.TableImpl;
import org.apache.ignite.internal.util.Pair;
import org.apache.ignite.table.Table;
import org.apache.ignite.table.manager.IgniteTables;

public class JdbcMetadataCatalog {
    private static final String PK = "PK_";
    private static final String TBL_TYPE = "TABLE";
    private static final String DEFAULT_SCHEMA_NAME = "PUBLIC";
    private final IgniteTables tables;
    private static final Comparator<Pair<String, Column>> bySchemaThenTabNameThenColOrder = Comparator.comparing(Pair::getFirst).thenComparingInt(o -> ((Column)o.getSecond()).schemaIndex());
    private static final Comparator<Table> byTblTypeThenSchemaThenTblName = Comparator.comparing(Table::name);

    public JdbcMetadataCatalog(IgniteTables tables) {
        this.tables = tables;
    }

    public CompletableFuture<Collection<JdbcPrimaryKeyMeta>> getPrimaryKeys(String schemaNamePtrn, String tblNamePtrn) {
        String schemaNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(schemaNamePtrn);
        String tlbNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(tblNamePtrn);
        return this.tables.tablesAsync().thenApply(tableList -> tableList.stream().filter(t -> JdbcMetadataCatalog.matches(DEFAULT_SCHEMA_NAME, schemaNameRegex)).filter(t -> JdbcMetadataCatalog.matches(t.name(), tlbNameRegex)).map(this::createPrimaryKeyMeta).collect(Collectors.toSet()));
    }

    public CompletableFuture<List<JdbcTableMeta>> getTablesMeta(String schemaNamePtrn, String tblNamePtrn, String[] tblTypes) {
        String schemaNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(schemaNamePtrn);
        String tlbNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(tblNamePtrn);
        return this.tables.tablesAsync().thenApply(tablesList -> tablesList.stream().filter(t -> JdbcMetadataCatalog.matches(DEFAULT_SCHEMA_NAME, schemaNameRegex)).filter(t -> JdbcMetadataCatalog.matches(t.name(), tlbNameRegex)).sorted(byTblTypeThenSchemaThenTblName).map(t -> new JdbcTableMeta(DEFAULT_SCHEMA_NAME, t.name(), TBL_TYPE)).collect(Collectors.toList()));
    }

    public CompletableFuture<Collection<JdbcColumnMeta>> getColumnsMeta(String schemaNamePtrn, String tblNamePtrn, String colNamePtrn) {
        String schemaNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(schemaNamePtrn);
        String tlbNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(tblNamePtrn);
        String colNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(colNamePtrn);
        return this.tables.tablesAsync().thenApply(tablesList -> tablesList.stream().filter(t -> JdbcMetadataCatalog.matches(DEFAULT_SCHEMA_NAME, schemaNameRegex)).filter(t -> JdbcMetadataCatalog.matches(t.name(), tlbNameRegex)).flatMap(tbl -> {
            SchemaDescriptor schema = ((TableImpl)tbl).schemaView().schema();
            ArrayList<Pair> tblColPairs = new ArrayList<Pair>();
            for (Column column : schema.keyColumns().columns()) {
                tblColPairs.add(new Pair((Object)tbl.name(), (Object)column));
            }
            for (Column column : schema.valueColumns().columns()) {
                tblColPairs.add(new Pair((Object)tbl.name(), (Object)column));
            }
            return tblColPairs.stream();
        }).filter(e -> JdbcMetadataCatalog.matches(((Column)e.getSecond()).name(), colNameRegex)).sorted(bySchemaThenTabNameThenColOrder).map(pair -> this.createColumnMeta((String)pair.getFirst(), (Column)pair.getSecond())).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    public CompletableFuture<Collection<String>> getSchemasMeta(String schemaNamePtrn) {
        TreeSet<String> schemas = new TreeSet<String>();
        String schemaNameRegex = JdbcMetadataCatalog.translateSqlWildcardsToRegex(schemaNamePtrn);
        if (JdbcMetadataCatalog.matches(DEFAULT_SCHEMA_NAME, schemaNameRegex)) {
            schemas.add(DEFAULT_SCHEMA_NAME);
        }
        return this.tables.tablesAsync().thenApply(tablesList -> tablesList.stream().map(tbl -> DEFAULT_SCHEMA_NAME).filter(schema -> JdbcMetadataCatalog.matches(schema, schemaNameRegex)).collect(Collectors.toCollection(() -> schemas)));
    }

    private JdbcPrimaryKeyMeta createPrimaryKeyMeta(Table tbl) {
        String keyName = PK + tbl.name();
        SchemaRegistry registry = ((TableImpl)tbl).schemaView();
        List keyColNames = Arrays.stream(registry.schema().keyColumns().columns()).map(Column::name).collect(Collectors.toList());
        return new JdbcPrimaryKeyMeta(DEFAULT_SCHEMA_NAME, tbl.name(), keyName, keyColNames);
    }

    private JdbcColumnMeta createColumnMeta(String tblName, Column col) {
        NativeType colType = col.type();
        return new JdbcColumnMeta(col.name(), DEFAULT_SCHEMA_NAME, tblName, col.name(), Commons.nativeTypeToClass((NativeType)colType), Commons.nativeTypePrecision((NativeType)colType), Commons.nativeTypeScale((NativeType)colType), col.nullable());
    }

    private static boolean matches(String str, String sqlPtrn) {
        if (str == null) {
            return false;
        }
        if (sqlPtrn == null) {
            return true;
        }
        return str.matches(sqlPtrn);
    }

    private static String translateSqlWildcardsToRegex(String sqlPtrn) {
        if (sqlPtrn == null || sqlPtrn.isEmpty()) {
            return sqlPtrn;
        }
        Object toRegex = " " + sqlPtrn;
        toRegex = ((String)toRegex).replaceAll("([\\[\\]{}()*+?.\\\\\\\\^$|])", "\\\\$1");
        toRegex = ((String)toRegex).replaceAll("([^\\\\\\\\])((?:\\\\\\\\\\\\\\\\)*)%", "$1$2.*");
        toRegex = ((String)toRegex).replaceAll("([^\\\\\\\\])((?:\\\\\\\\\\\\\\\\)*)_", "$1$2.");
        toRegex = ((String)toRegex).replaceAll("([^\\\\\\\\])(\\\\\\\\(?>\\\\\\\\\\\\\\\\)*\\\\\\\\)*\\\\\\\\([_|%])", "$1$2$3");
        return ((String)toRegex).substring(1);
    }
}

