/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.synthetic;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.yarn.sls.synthetic.SynthJobClass;
import org.apache.hadoop.yarn.sls.synthetic.SynthTraceJobProducer;
import org.apache.hadoop.yarn.sls.synthetic.SynthUtils;

public class SynthWorkload {
    private final int id;
    private final List<SynthJobClass> classList = new ArrayList<SynthJobClass>();
    private final SynthTraceJobProducer.Trace trace;
    private final SortedMap<Integer, Double> timeWeights;

    public SynthWorkload(int identifier, SynthTraceJobProducer.Trace inTrace) {
        this.id = identifier;
        this.trace = inTrace;
        this.timeWeights = new TreeMap<Integer, Double>();
        for (SynthTraceJobProducer.TimeSample ts : this.trace.workloads.get((int)this.id).time_distribution) {
            this.timeWeights.put(ts.time, ts.jobs);
        }
    }

    public boolean add(SynthJobClass s) {
        return this.classList.add(s);
    }

    public List<Double> getWeightList() {
        ArrayList<Double> ret = new ArrayList<Double>();
        for (SynthJobClass s : this.classList) {
            ret.add(s.getClassWeight());
        }
        return ret;
    }

    public int getId() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SynthWorkload)) {
            return false;
        }
        return this.getId() == ((SynthWorkload)other).getId();
    }

    public int hashCode() {
        return this.getId();
    }

    public String toString() {
        return "SynthWorkload " + this.trace.workloads.get((int)this.id).workload_name + "[\n" + this.classList + "]\n";
    }

    public String getName() {
        return this.trace.workloads.get((int)this.id).workload_name;
    }

    public double getWorkloadWeight() {
        return this.trace.workloads.get((int)this.id).workload_weight;
    }

    public String getQueueName() {
        return this.trace.workloads.get((int)this.id).queue_name;
    }

    public long getBaseSubmissionTime(Random rand) {
        int startRange;
        int position = SynthUtils.getWeighted(this.timeWeights.values(), rand);
        int[] time = new int[this.timeWeights.keySet().size()];
        int index = 0;
        for (Integer i : this.timeWeights.keySet()) {
            time[index++] = i;
        }
        int endRange = startRange = time[position];
        if (position < this.timeWeights.keySet().size() - 1) {
            endRange = time[position + 1];
            return startRange + rand.nextInt(endRange - startRange);
        }
        return startRange;
    }

    public List<SynthJobClass> getClassList() {
        return this.classList;
    }
}

