/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.nodemanager;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.api.records.NodeAction;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.sls.nodemanager.NodeInfo;
import org.apache.hadoop.yarn.sls.scheduler.ContainerSimulator;
import org.apache.hadoop.yarn.sls.scheduler.TaskRunner;
import org.apache.hadoop.yarn.sls.utils.SLSUtils;
import org.apache.hadoop.yarn.util.Records;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NMSimulator
extends TaskRunner.Task {
    private RMNode node;
    private MasterKey masterKey;
    private List<ContainerId> completedContainerList;
    private List<ContainerId> releasedContainerList;
    private DelayQueue<ContainerSimulator> containerQueue;
    private Map<ContainerId, ContainerSimulator> runningContainers;
    private List<ContainerId> amContainerList;
    private ResourceManager rm;
    private int responseId = 0;
    private static final Logger LOG = LoggerFactory.getLogger(NMSimulator.class);

    public void init(String nodeIdStr, int memory, int cores, int dispatchTime, int heartBeatInterval, ResourceManager rm) throws IOException, YarnException {
        super.init(dispatchTime, (long)dispatchTime + 1000000L * (long)heartBeatInterval, heartBeatInterval);
        String[] rackHostName = SLSUtils.getRackHostName(nodeIdStr);
        this.node = NodeInfo.newNodeInfo(rackHostName[0], rackHostName[1], BuilderUtils.newResource((long)memory, (int)cores));
        this.rm = rm;
        this.completedContainerList = Collections.synchronizedList(new ArrayList());
        this.releasedContainerList = Collections.synchronizedList(new ArrayList());
        this.containerQueue = new DelayQueue();
        this.amContainerList = Collections.synchronizedList(new ArrayList());
        this.runningContainers = new ConcurrentHashMap<ContainerId, ContainerSimulator>();
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        req.setNodeId(this.node.getNodeID());
        req.setResource(this.node.getTotalCapability());
        req.setHttpPort(80);
        RegisterNodeManagerResponse response = rm.getResourceTrackerService().registerNodeManager(req);
        this.masterKey = response.getNMTokenMasterKey();
    }

    @Override
    public void firstStep() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void middleStep() throws Exception {
        ContainerSimulator cs = null;
        List<ContainerId> list = this.completedContainerList;
        synchronized (list) {
            while ((cs = (ContainerSimulator)this.containerQueue.poll()) != null) {
                this.runningContainers.remove(cs.getId());
                this.completedContainerList.add(cs.getId());
                LOG.debug("Container {} has completed", (Object)cs.getId());
            }
        }
        NodeHeartbeatRequest beatRequest = (NodeHeartbeatRequest)Records.newRecord(NodeHeartbeatRequest.class);
        beatRequest.setLastKnownNMTokenMasterKey(this.masterKey);
        NodeStatus ns = (NodeStatus)Records.newRecord(NodeStatus.class);
        ns.setContainersStatuses(this.generateContainerStatusList());
        ns.setNodeId(this.node.getNodeID());
        ns.setKeepAliveApplications(new ArrayList());
        ns.setResponseId(this.responseId++);
        ns.setNodeHealthStatus(NodeHealthStatus.newInstance((boolean)true, (String)"", (long)0L));
        beatRequest.setNodeStatus(ns);
        NodeHeartbeatResponse beatResponse = this.rm.getResourceTrackerService().nodeHeartbeat(beatRequest);
        if (!beatResponse.getContainersToCleanup().isEmpty()) {
            List<ContainerId> list2 = this.releasedContainerList;
            synchronized (list2) {
                for (ContainerId containerId : beatResponse.getContainersToCleanup()) {
                    if (this.amContainerList.contains(containerId)) {
                        List<ContainerId> list3 = this.amContainerList;
                        synchronized (list3) {
                            this.amContainerList.remove(containerId);
                        }
                        LOG.debug("NodeManager {} releases an AM ({}).", (Object)this.node.getNodeID(), (Object)containerId);
                        continue;
                    }
                    cs = this.runningContainers.remove(containerId);
                    this.containerQueue.remove(cs);
                    this.releasedContainerList.add(containerId);
                    LOG.debug("NodeManager {} releases a container ({}).", (Object)this.node.getNodeID(), (Object)containerId);
                }
            }
        }
        if (beatResponse.getNodeAction() == NodeAction.SHUTDOWN) {
            this.lastStep();
        }
    }

    @Override
    public void lastStep() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ContainerStatus> generateContainerStatusList() {
        ArrayList<ContainerStatus> csList = new ArrayList<ContainerStatus>();
        for (ContainerSimulator container : this.runningContainers.values()) {
            csList.add(this.newContainerStatus(container.getId(), ContainerState.RUNNING, 0));
        }
        List<ContainerId> list = this.amContainerList;
        synchronized (list) {
            for (ContainerId cId : this.amContainerList) {
                csList.add(this.newContainerStatus(cId, ContainerState.RUNNING, 0));
            }
        }
        list = this.completedContainerList;
        synchronized (list) {
            for (ContainerId cId : this.completedContainerList) {
                LOG.debug("NodeManager {} completed container ({}).", (Object)this.node.getNodeID(), (Object)cId);
                csList.add(this.newContainerStatus(cId, ContainerState.COMPLETE, 0));
            }
            this.completedContainerList.clear();
        }
        list = this.releasedContainerList;
        synchronized (list) {
            for (ContainerId cId : this.releasedContainerList) {
                LOG.debug("NodeManager {} released container ({}).", (Object)this.node.getNodeID(), (Object)cId);
                csList.add(this.newContainerStatus(cId, ContainerState.COMPLETE, -100));
            }
            this.releasedContainerList.clear();
        }
        return csList;
    }

    private ContainerStatus newContainerStatus(ContainerId cId, ContainerState state, int exitState) {
        ContainerStatus cs = (ContainerStatus)Records.newRecord(ContainerStatus.class);
        cs.setContainerId(cId);
        cs.setState(state);
        cs.setExitStatus(exitState);
        return cs;
    }

    public RMNode getNode() {
        return this.node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewContainer(Container container, long lifeTimeMS) {
        LOG.debug("NodeManager {} launches a new container ({}).", (Object)this.node.getNodeID(), (Object)container.getId());
        if (lifeTimeMS != -1L) {
            ContainerSimulator cs = new ContainerSimulator(container.getId(), container.getResource(), lifeTimeMS + System.currentTimeMillis(), lifeTimeMS);
            this.containerQueue.add(cs);
            this.runningContainers.put(cs.getId(), cs);
        } else {
            List<ContainerId> list = this.amContainerList;
            synchronized (list) {
                this.amContainerList.add(container.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupContainer(ContainerId containerId) {
        List<ContainerId> list = this.amContainerList;
        synchronized (list) {
            this.amContainerList.remove(containerId);
        }
        list = this.completedContainerList;
        synchronized (list) {
            this.completedContainerList.add(containerId);
        }
    }

    @VisibleForTesting
    Map<ContainerId, ContainerSimulator> getRunningContainers() {
        return this.runningContainers;
    }

    @VisibleForTesting
    List<ContainerId> getAMContainers() {
        return this.amContainerList;
    }

    @VisibleForTesting
    List<ContainerId> getCompletedContainers() {
        return this.completedContainerList;
    }
}

