/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls;

import java.util.ArrayList;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.api.records.ReservationRequests;
import org.apache.hadoop.yarn.api.records.Resource;

public final class ReservationClientUtil {
    private ReservationClientUtil() {
    }

    public static ReservationSubmissionRequest createMRReservation(ReservationId reservationId, String name, Resource maxMapRes, int numberMaps, long maxMapDur, Resource maxRedRes, int numberReduces, long maxRedDur, long arrival, long deadline, String queueName) {
        ReservationRequest mapRR = ReservationRequest.newInstance((Resource)maxMapRes, (int)numberMaps, (int)numberMaps, (long)maxMapDur);
        ReservationRequest redRR = ReservationRequest.newInstance((Resource)maxRedRes, (int)numberReduces, (int)numberReduces, (long)maxRedDur);
        ArrayList<ReservationRequest> listResReq = new ArrayList<ReservationRequest>();
        listResReq.add(mapRR);
        listResReq.add(redRR);
        ReservationRequests reservationRequests = ReservationRequests.newInstance(listResReq, (ReservationRequestInterpreter)ReservationRequestInterpreter.R_ORDER_NO_GAP);
        ReservationDefinition resDef = ReservationDefinition.newInstance((long)arrival, (long)deadline, (ReservationRequests)reservationRequests, (String)name);
        ReservationSubmissionRequest request = ReservationSubmissionRequest.newInstance((ReservationDefinition)resDef, (String)queueName, (ReservationId)reservationId);
        return request;
    }
}

