/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtocolInfo;
import org.apache.hadoop.ipc.ProtocolMetaInfoServerSideTranslatorPB;
import org.apache.hadoop.ipc.ProtocolProxy;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RpcClientUtil;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.ipc.protobuf.ProtocolInfoProtos;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;
import org.apache.hadoop.net.NetUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRPCCompatibility {
    private static final String ADDRESS = "0.0.0.0";
    private static InetSocketAddress addr;
    private static RPC.Server server;
    private ProtocolProxy<?> proxy;
    public static final Logger LOG;
    private static Configuration conf;

    @Before
    public void setUp() {
        ProtocolSignature.resetCache();
    }

    @After
    public void tearDown() {
        if (this.proxy != null) {
            RPC.stopProxy((Object)this.proxy.getProxy());
            this.proxy = null;
        }
        if (server != null) {
            server.stop();
            server = null;
        }
    }

    @Test
    public void testVersion0ClientVersion1Server() throws Exception {
        TestImpl1 impl = new TestImpl1();
        server = new RPC.Builder(conf).setProtocol(TestProtocol1.class).setInstance((Object)impl).setBindAddress(ADDRESS).setPort(0).setNumHandlers(2).setVerbose(false).build();
        server.addProtocol(RPC.RpcKind.RPC_WRITABLE, TestProtocol0.class, (Object)impl);
        server.start();
        addr = NetUtils.getConnectAddress((Server)server);
        this.proxy = RPC.getProtocolProxy(TestProtocol0.class, (long)0L, (InetSocketAddress)addr, (Configuration)conf);
        TestProtocol0 proxy0 = (TestProtocol0)this.proxy.getProxy();
        proxy0.ping();
    }

    @Test
    public void testVersion1ClientVersion0Server() throws Exception {
        server = new RPC.Builder(conf).setProtocol(TestProtocol0.class).setInstance((Object)new TestImpl0()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(2).setVerbose(false).build();
        server.start();
        addr = NetUtils.getConnectAddress((Server)server);
        this.proxy = RPC.getProtocolProxy(TestProtocol1.class, (long)0L, (InetSocketAddress)addr, (Configuration)conf);
        TestProtocol1 proxy1 = (TestProtocol1)this.proxy.getProxy();
        proxy1.ping();
        try {
            proxy1.echo("hello");
            Assert.fail((String)"Echo should fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testVersion2ClientVersion1Server() throws Exception {
        TestImpl1 impl = new TestImpl1();
        server = new RPC.Builder(conf).setProtocol(TestProtocol1.class).setInstance((Object)impl).setBindAddress(ADDRESS).setPort(0).setNumHandlers(2).setVerbose(false).build();
        server.addProtocol(RPC.RpcKind.RPC_WRITABLE, TestProtocol0.class, (Object)impl);
        server.start();
        addr = NetUtils.getConnectAddress((Server)server);
        Version2Client client = new Version2Client();
        client.ping();
        Assert.assertEquals((Object)"hello", (Object)client.echo("hello"));
        Assert.assertEquals((long)3L, (long)client.echo(3));
    }

    @Test
    public void testVersion2ClientVersion2Server() throws Exception {
        TestImpl2 impl = new TestImpl2();
        server = new RPC.Builder(conf).setProtocol(TestProtocol2.class).setInstance((Object)impl).setBindAddress(ADDRESS).setPort(0).setNumHandlers(2).setVerbose(false).build();
        server.addProtocol(RPC.RpcKind.RPC_WRITABLE, TestProtocol0.class, (Object)impl);
        server.start();
        addr = NetUtils.getConnectAddress((Server)server);
        Version2Client client = new Version2Client();
        client.ping();
        Assert.assertEquals((Object)"hello", (Object)client.echo("hello"));
        Assert.assertEquals((long)-3L, (long)client.echo(3));
    }

    @Test
    public void testHashCode() throws Exception {
        Method strMethod = TestProtocol3.class.getMethod("echo", String.class);
        int stringEchoHash = ProtocolSignature.getFingerprint((Method)strMethod);
        Method intMethod = TestProtocol3.class.getMethod("echo", Integer.TYPE);
        int intEchoHash = ProtocolSignature.getFingerprint((Method)intMethod);
        Assert.assertFalse((stringEchoHash == intEchoHash ? 1 : 0) != 0);
        int intEchoHash1 = ProtocolSignature.getFingerprint((Method)TestProtocol2.class.getMethod("echo", Integer.TYPE));
        Assert.assertEquals((long)intEchoHash, (long)intEchoHash1);
        int stringEchoHash1 = ProtocolSignature.getFingerprint((Method)TestProtocol2.class.getMethod("echo", String.class));
        Assert.assertFalse((stringEchoHash == stringEchoHash1 ? 1 : 0) != 0);
        int intEchoHashAlias = ProtocolSignature.getFingerprint((Method)TestProtocol3.class.getMethod("echo_alias", Integer.TYPE));
        Assert.assertFalse((intEchoHash == intEchoHashAlias ? 1 : 0) != 0);
        int intEchoHash2 = ProtocolSignature.getFingerprint((Method)TestProtocol3.class.getMethod("echo", Integer.TYPE, Integer.TYPE));
        Assert.assertFalse((intEchoHash == intEchoHash2 ? 1 : 0) != 0);
        int hash1 = ProtocolSignature.getFingerprint((Method[])new Method[]{intMethod, strMethod});
        int hash2 = ProtocolSignature.getFingerprint((Method[])new Method[]{strMethod, intMethod});
        Assert.assertEquals((long)hash1, (long)hash2);
    }

    @Test
    public void testVersionMismatch() throws IOException {
        server = new RPC.Builder(conf).setProtocol(TestProtocol2.class).setInstance((Object)new TestImpl2()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(2).setVerbose(false).build();
        server.start();
        addr = NetUtils.getConnectAddress((Server)server);
        TestProtocol4 proxy = (TestProtocol4)RPC.getProxy(TestProtocol4.class, (long)4L, (InetSocketAddress)addr, (Configuration)conf);
        try {
            proxy.echo(21);
            Assert.fail((String)"The call must throw VersionMismatch exception");
        }
        catch (RemoteException ex) {
            Assert.assertEquals((Object)RPC.VersionMismatch.class.getName(), (Object)ex.getClassName());
            Assert.assertTrue((boolean)ex.getErrorCode().equals((Object)RpcHeaderProtos.RpcResponseHeaderProto.RpcErrorCodeProto.ERROR_RPC_VERSION_MISMATCH));
        }
        catch (IOException ex) {
            Assert.fail((String)("Expected version mismatch but got " + ex));
        }
    }

    @Test
    public void testIsMethodSupported() throws IOException {
        server = new RPC.Builder(conf).setProtocol(TestProtocol2.class).setInstance((Object)new TestImpl2()).setBindAddress(ADDRESS).setPort(0).setNumHandlers(2).setVerbose(false).build();
        server.start();
        addr = NetUtils.getConnectAddress((Server)server);
        TestProtocol2 proxy = (TestProtocol2)RPC.getProxy(TestProtocol2.class, (long)0L, (InetSocketAddress)addr, (Configuration)conf);
        boolean supported = RpcClientUtil.isMethodSupported((Object)proxy, TestProtocol2.class, (RPC.RpcKind)RPC.RpcKind.RPC_WRITABLE, (long)RPC.getProtocolVersion(TestProtocol2.class), (String)"echo");
        Assert.assertTrue((boolean)supported);
        supported = RpcClientUtil.isMethodSupported((Object)proxy, TestProtocol2.class, (RPC.RpcKind)RPC.RpcKind.RPC_PROTOCOL_BUFFER, (long)RPC.getProtocolVersion(TestProtocol2.class), (String)"echo");
        Assert.assertFalse((boolean)supported);
    }

    @Test
    public void testProtocolMetaInfoSSTranslatorPB() throws Exception {
        TestImpl1 impl = new TestImpl1();
        server = new RPC.Builder(conf).setProtocol(TestProtocol1.class).setInstance((Object)impl).setBindAddress(ADDRESS).setPort(0).setNumHandlers(2).setVerbose(false).build();
        server.addProtocol(RPC.RpcKind.RPC_WRITABLE, TestProtocol0.class, (Object)impl);
        server.start();
        ProtocolMetaInfoServerSideTranslatorPB xlator = new ProtocolMetaInfoServerSideTranslatorPB(server);
        ProtocolInfoProtos.GetProtocolSignatureResponseProto resp = xlator.getProtocolSignature(null, this.createGetProtocolSigRequestProto(TestProtocol1.class, RPC.RpcKind.RPC_PROTOCOL_BUFFER));
        Assert.assertEquals((long)0L, (long)resp.getProtocolSignatureCount());
        resp = xlator.getProtocolSignature(null, this.createGetProtocolSigRequestProto(TestProtocol1.class, RPC.RpcKind.RPC_WRITABLE));
        Assert.assertEquals((long)1L, (long)resp.getProtocolSignatureCount());
        ProtocolInfoProtos.ProtocolSignatureProto sig = (ProtocolInfoProtos.ProtocolSignatureProto)resp.getProtocolSignatureList().get(0);
        Assert.assertEquals((long)0L, (long)sig.getVersion());
        boolean found = false;
        int expected = ProtocolSignature.getFingerprint((Method)TestProtocol1.class.getMethod("echo", String.class));
        Iterator i$ = sig.getMethodsList().iterator();
        while (i$.hasNext()) {
            int m = (Integer)i$.next();
            if (expected != m) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found);
    }

    private ProtocolInfoProtos.GetProtocolSignatureRequestProto createGetProtocolSigRequestProto(Class<?> protocol, RPC.RpcKind rpcKind) {
        ProtocolInfoProtos.GetProtocolSignatureRequestProto.Builder builder = ProtocolInfoProtos.GetProtocolSignatureRequestProto.newBuilder();
        builder.setProtocol(protocol.getName());
        builder.setRpcKind(rpcKind.toString());
        return builder.build();
    }

    static /* synthetic */ InetSocketAddress access$000() {
        return addr;
    }

    static /* synthetic */ Configuration access$100() {
        return conf;
    }

    static {
        LOG = LoggerFactory.getLogger(TestRPCCompatibility.class);
        conf = new Configuration();
    }

    @ProtocolInfo(protocolName="org.apache.hadoop.ipc.TestRPCCompatibility$TestProtocol1")
    public static interface TestProtocol4
    extends TestProtocol2 {
        public static final long versionID = 4L;

        @Override
        public int echo(int var1) throws IOException;
    }

    public static interface TestProtocol3 {
        public int echo(String var1);

        public int echo(int var1);

        public int echo_alias(int var1);

        public int echo(int var1, int var2);
    }

    private class Version2Client {
        private TestProtocol2 proxy2;
        private ProtocolProxy<TestProtocol2> serverInfo = RPC.getProtocolProxy(TestProtocol2.class, (long)0L, (InetSocketAddress)TestRPCCompatibility.access$000(), (Configuration)TestRPCCompatibility.access$100());

        private Version2Client() throws IOException {
            this.proxy2 = (TestProtocol2)this.serverInfo.getProxy();
        }

        public int echo(int value) throws IOException, NumberFormatException {
            if (this.serverInfo.isMethodSupported("echo", new Class[]{Integer.TYPE})) {
                System.out.println("echo int is supported");
                return -value;
            }
            System.out.println("echo int is NOT supported");
            return Integer.parseInt(this.proxy2.echo(String.valueOf(value)));
        }

        public String echo(String value) throws IOException {
            return this.proxy2.echo(value);
        }

        public void ping() throws IOException {
            this.proxy2.ping();
        }
    }

    public static class TestImpl2
    extends TestImpl1
    implements TestProtocol2 {
        @Override
        public int echo(int value) {
            return value;
        }

        @Override
        public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
            return 0L;
        }
    }

    public static class TestImpl1
    extends TestImpl0
    implements TestProtocol1 {
        @Override
        public String echo(String value) {
            return value;
        }

        @Override
        public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
            return 0L;
        }
    }

    public static class TestImpl0
    implements TestProtocol0 {
        public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
            return 0L;
        }

        public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHashCode) throws IOException {
            Class inter;
            try {
                inter = (Class)this.getClass().getGenericInterfaces()[0];
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            return ProtocolSignature.getProtocolSignature((int)clientMethodsHashCode, (long)this.getProtocolVersion(protocol, clientVersion), (Class)inter);
        }

        @Override
        public void ping() {
        }
    }

    @ProtocolInfo(protocolName="org.apache.hadoop.ipc.TestRPCCompatibility$TestProtocol1")
    public static interface TestProtocol2
    extends TestProtocol1 {
        public int echo(int var1) throws IOException;
    }

    public static interface TestProtocol1
    extends TestProtocol0 {
        public String echo(String var1) throws IOException;
    }

    public static interface TestProtocol0
    extends VersionedProtocol {
        public static final long versionID = 0L;

        public void ping() throws IOException;
    }
}

