/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.typedbytes;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.apache.hadoop.record.Buffer;
import org.apache.hadoop.record.Record;
import org.apache.hadoop.record.RecordOutput;
import org.apache.hadoop.typedbytes.TypedBytesOutput;

public class TypedBytesRecordOutput
implements RecordOutput {
    private TypedBytesOutput out;
    private static final ThreadLocal<TypedBytesRecordOutput> TB_OUT = new ThreadLocal<TypedBytesRecordOutput>(){

        @Override
        protected TypedBytesRecordOutput initialValue() {
            return new TypedBytesRecordOutput();
        }
    };

    private TypedBytesRecordOutput() {
    }

    private void setTypedBytesOutput(TypedBytesOutput out) {
        this.out = out;
    }

    public static TypedBytesRecordOutput get(TypedBytesOutput out) {
        TypedBytesRecordOutput bout = TB_OUT.get();
        bout.setTypedBytesOutput(out);
        return bout;
    }

    public static TypedBytesRecordOutput get(DataOutput out) {
        return TypedBytesRecordOutput.get(TypedBytesOutput.get(out));
    }

    public TypedBytesRecordOutput(TypedBytesOutput out) {
        this.out = out;
    }

    public TypedBytesRecordOutput(DataOutput out) {
        this(new TypedBytesOutput(out));
    }

    public void writeBool(boolean b, String tag) throws IOException {
        this.out.writeBool(b);
    }

    public void writeBuffer(Buffer buf, String tag) throws IOException {
        this.out.writeBytes(buf.get());
    }

    public void writeByte(byte b, String tag) throws IOException {
        this.out.writeByte(b);
    }

    public void writeDouble(double d, String tag) throws IOException {
        this.out.writeDouble(d);
    }

    public void writeFloat(float f, String tag) throws IOException {
        this.out.writeFloat(f);
    }

    public void writeInt(int i, String tag) throws IOException {
        this.out.writeInt(i);
    }

    public void writeLong(long l, String tag) throws IOException {
        this.out.writeLong(l);
    }

    public void writeString(String s, String tag) throws IOException {
        this.out.writeString(s);
    }

    public void startRecord(Record r, String tag) throws IOException {
        this.out.writeListHeader();
    }

    public void startVector(ArrayList v, String tag) throws IOException {
        this.out.writeVectorHeader(v.size());
    }

    public void startMap(TreeMap m, String tag) throws IOException {
        this.out.writeMapHeader(m.size());
    }

    public void endRecord(Record r, String tag) throws IOException {
        this.out.writeListFooter();
    }

    public void endVector(ArrayList v, String tag) throws IOException {
    }

    public void endMap(TreeMap m, String tag) throws IOException {
    }
}

