/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.typedbytes;

import java.io.DataInput;
import java.io.IOException;
import org.apache.hadoop.record.Buffer;
import org.apache.hadoop.record.Index;
import org.apache.hadoop.record.RecordInput;
import org.apache.hadoop.typedbytes.TypedBytesInput;

public class TypedBytesRecordInput
implements RecordInput {
    private TypedBytesInput in;
    private static final ThreadLocal<TypedBytesRecordInput> TB_IN = new ThreadLocal<TypedBytesRecordInput>(){

        @Override
        protected TypedBytesRecordInput initialValue() {
            return new TypedBytesRecordInput();
        }
    };

    private TypedBytesRecordInput() {
    }

    private void setTypedBytesInput(TypedBytesInput in) {
        this.in = in;
    }

    public static TypedBytesRecordInput get(TypedBytesInput in) {
        TypedBytesRecordInput bin = TB_IN.get();
        bin.setTypedBytesInput(in);
        return bin;
    }

    public static TypedBytesRecordInput get(DataInput in) {
        return TypedBytesRecordInput.get(TypedBytesInput.get(in));
    }

    public TypedBytesRecordInput(TypedBytesInput in) {
        this.in = in;
    }

    public TypedBytesRecordInput(DataInput in) {
        this(new TypedBytesInput(in));
    }

    public boolean readBool(String tag) throws IOException {
        this.in.skipType();
        return this.in.readBool();
    }

    public Buffer readBuffer(String tag) throws IOException {
        this.in.skipType();
        return new Buffer(this.in.readBytes());
    }

    public byte readByte(String tag) throws IOException {
        this.in.skipType();
        return this.in.readByte();
    }

    public double readDouble(String tag) throws IOException {
        this.in.skipType();
        return this.in.readDouble();
    }

    public float readFloat(String tag) throws IOException {
        this.in.skipType();
        return this.in.readFloat();
    }

    public int readInt(String tag) throws IOException {
        this.in.skipType();
        return this.in.readInt();
    }

    public long readLong(String tag) throws IOException {
        this.in.skipType();
        return this.in.readLong();
    }

    public String readString(String tag) throws IOException {
        this.in.skipType();
        return this.in.readString();
    }

    public void startRecord(String tag) throws IOException {
        this.in.skipType();
    }

    public Index startVector(String tag) throws IOException {
        this.in.skipType();
        return new TypedBytesIndex(this.in.readVectorHeader());
    }

    public Index startMap(String tag) throws IOException {
        this.in.skipType();
        return new TypedBytesIndex(this.in.readMapHeader());
    }

    public void endRecord(String tag) throws IOException {
    }

    public void endVector(String tag) throws IOException {
    }

    public void endMap(String tag) throws IOException {
    }

    private static final class TypedBytesIndex
    implements Index {
        private int nelems;

        private TypedBytesIndex(int nelems) {
            this.nelems = nelems;
        }

        public boolean done() {
            return this.nelems <= 0;
        }

        public void incr() {
            --this.nelems;
        }
    }
}

