/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.records;

import java.io.IOException;
import org.apache.hadoop.hdfs.server.federation.router.RouterServiceState;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreSerializer;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.RouterState;
import org.apache.hadoop.hdfs.server.federation.store.records.StateStoreVersion;
import org.junit.Assert;
import org.junit.Test;

public class TestRouterState {
    private static final String ADDRESS = "address";
    private static final String VERSION = "version";
    private static final String COMPILE_INFO = "compileInfo";
    private static final long START_TIME = 100L;
    private static final long DATE_MODIFIED = 200L;
    private static final long DATE_CREATED = 300L;
    private static final long FILE_RESOLVER_VERSION = 500L;
    private static final RouterServiceState STATE = RouterServiceState.RUNNING;

    private RouterState generateRecord() throws IOException {
        RouterState record = RouterState.newInstance((String)ADDRESS, (long)100L, (RouterServiceState)STATE);
        record.setVersion(VERSION);
        record.setCompileInfo(COMPILE_INFO);
        record.setDateCreated(300L);
        record.setDateModified(200L);
        StateStoreVersion version = StateStoreVersion.newInstance();
        version.setMountTableVersion(500L);
        record.setStateStoreVersion(version);
        return record;
    }

    private void validateRecord(RouterState record) throws IOException {
        Assert.assertEquals((Object)ADDRESS, (Object)record.getAddress());
        Assert.assertEquals((long)100L, (long)record.getDateStarted());
        Assert.assertEquals((Object)STATE, (Object)record.getStatus());
        Assert.assertEquals((Object)COMPILE_INFO, (Object)record.getCompileInfo());
        Assert.assertEquals((Object)VERSION, (Object)record.getVersion());
        StateStoreVersion version = record.getStateStoreVersion();
        Assert.assertEquals((long)500L, (long)version.getMountTableVersion());
    }

    @Test
    public void testGetterSetter() throws IOException {
        RouterState record = this.generateRecord();
        this.validateRecord(record);
    }

    @Test
    public void testSerialization() throws IOException {
        RouterState record = this.generateRecord();
        StateStoreSerializer serializer = StateStoreSerializer.getSerializer();
        String serializedString = serializer.serializeString((BaseRecord)record);
        RouterState newRecord = (RouterState)serializer.deserialize(serializedString, RouterState.class);
        this.validateRecord(newRecord);
    }
}

