/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeContext;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.resolver.MembershipNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.NamenodeStatusReport;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUnavailableException;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestNamenodeResolver {
    private static StateStoreService stateStore;
    private static ActiveNamenodeResolver namenodeResolver;

    @BeforeClass
    public static void create() throws Exception {
        Configuration conf = FederationStateStoreTestUtils.getStateStoreConfiguration();
        conf.setLong("dfs.federation.router.store.membership.expiration", TimeUnit.SECONDS.toMillis(5L));
        stateStore = FederationStateStoreTestUtils.newStateStore(conf);
        Assert.assertNotNull((Object)stateStore);
        namenodeResolver = new MembershipNamenodeResolver(conf, stateStore);
        namenodeResolver.setRouterId(FederationTestUtils.ROUTERS[0]);
    }

    @AfterClass
    public static void destroy() throws Exception {
        stateStore.stop();
        stateStore.close();
    }

    @Before
    public void setup() throws IOException, InterruptedException {
        stateStore.loadDriver();
        FederationStateStoreTestUtils.waitStateStore(stateStore, 10000L);
        boolean cleared = FederationStateStoreTestUtils.clearRecords(stateStore, MembershipState.class);
        Assert.assertTrue((boolean)cleared);
    }

    @Test
    public void testStateStoreDisconnected() throws Exception {
        NamenodeStatusReport report = FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], HAServiceProtocol.HAServiceState.ACTIVE);
        Assert.assertTrue((boolean)namenodeResolver.registerNamenode(report));
        stateStore.closeDriver();
        Assert.assertFalse((boolean)stateStore.isDriverReady());
        stateStore.refreshCaches(true);
        List nns = namenodeResolver.getNamenodesForBlockPoolId(FederationTestUtils.NAMESERVICES[0]);
        Assert.assertNull((Object)nns);
        FederationTestUtils.verifyException(namenodeResolver, "registerNamenode", StateStoreUnavailableException.class, new Class[]{NamenodeStatusReport.class}, new Object[]{report});
    }

    private void verifyFirstRegistration(String nsId, String nnId, int resultsCount, FederationNamenodeServiceState state) throws IOException {
        List namenodes = namenodeResolver.getNamenodesForNameserviceId(nsId);
        if (resultsCount == 0) {
            Assert.assertNull((Object)namenodes);
        } else {
            Assert.assertEquals((long)resultsCount, (long)namenodes.size());
            if (namenodes.size() > 0) {
                FederationNamenodeContext namenode = (FederationNamenodeContext)namenodes.get(0);
                Assert.assertEquals((Object)state, (Object)namenode.getState());
                Assert.assertEquals((Object)nnId, (Object)namenode.getNamenodeId());
            }
        }
    }

    @Test
    public void testRegistrationExpired() throws InterruptedException, IOException {
        NamenodeStatusReport report = FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], HAServiceProtocol.HAServiceState.ACTIVE);
        Assert.assertTrue((boolean)namenodeResolver.registerNamenode(report));
        stateStore.refreshCaches(true);
        this.verifyFirstRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], 1, FederationNamenodeServiceState.ACTIVE);
        Thread.sleep(6000L);
        stateStore.refreshCaches(true);
        this.verifyFirstRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], 0, FederationNamenodeServiceState.ACTIVE);
        Assert.assertTrue((boolean)namenodeResolver.registerNamenode(report));
        stateStore.refreshCaches(true);
        this.verifyFirstRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], 1, FederationNamenodeServiceState.ACTIVE);
    }

    @Test
    public void testRegistrationNamenodeSelection() throws InterruptedException, IOException {
        Assert.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], HAServiceProtocol.HAServiceState.ACTIVE)));
        Thread.sleep(100L);
        Assert.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[1], HAServiceProtocol.HAServiceState.STANDBY)));
        stateStore.refreshCaches(true);
        this.verifyFirstRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], 2, FederationNamenodeServiceState.ACTIVE);
        Assert.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], HAServiceProtocol.HAServiceState.ACTIVE)));
        Thread.sleep(6000L);
        Assert.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[1], HAServiceProtocol.HAServiceState.STANDBY)));
        stateStore.refreshCaches(true);
        this.verifyFirstRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[1], 1, FederationNamenodeServiceState.STANDBY);
        Assert.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], HAServiceProtocol.HAServiceState.ACTIVE)));
        Thread.sleep(100L);
        Assert.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[1], null)));
        stateStore.refreshCaches(true);
        this.verifyFirstRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], 2, FederationNamenodeServiceState.ACTIVE);
        Assert.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[1], HAServiceProtocol.HAServiceState.STANDBY)));
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], null)));
        stateStore.refreshCaches(true);
        this.verifyFirstRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[1], 2, FederationNamenodeServiceState.STANDBY);
        Assert.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], null)));
        Thread.sleep(100L);
        Assert.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[1], HAServiceProtocol.HAServiceState.STANDBY)));
        Thread.sleep(100L);
        Assert.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[2], HAServiceProtocol.HAServiceState.ACTIVE)));
        stateStore.refreshCaches(true);
        this.verifyFirstRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[2], 3, FederationNamenodeServiceState.ACTIVE);
        Assert.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[0], HAServiceProtocol.HAServiceState.STANDBY)));
        Assert.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[2], HAServiceProtocol.HAServiceState.STANDBY)));
        Thread.sleep(1500L);
        Assert.assertTrue((boolean)namenodeResolver.registerNamenode(FederationTestUtils.createNamenodeReport(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[1], HAServiceProtocol.HAServiceState.STANDBY)));
        stateStore.refreshCaches(true);
        this.verifyFirstRegistration(FederationTestUtils.NAMESERVICES[0], FederationTestUtils.NAMENODES[1], 3, FederationNamenodeServiceState.STANDBY);
    }
}

