/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.clientrm;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FailApplicationAttemptRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FailApplicationAttemptResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceTypeInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceTypeInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewReservationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationPriorityResponse;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.federation.failover.FederationProxyProviderUtil;
import org.apache.hadoop.yarn.server.federation.policies.RouterPolicyFacade;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.router.RouterMetrics;
import org.apache.hadoop.yarn.server.router.RouterServerUtil;
import org.apache.hadoop.yarn.server.router.clientrm.AbstractClientRequestInterceptor;
import org.apache.hadoop.yarn.server.router.clientrm.ClientRequestInterceptor;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.MonotonicClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationClientInterceptor
extends AbstractClientRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(FederationClientInterceptor.class);
    private int numSubmitRetries;
    private Map<SubClusterId, ApplicationClientProtocol> clientRMProxies;
    private FederationStateStoreFacade federationFacade;
    private Random rand;
    private RouterPolicyFacade policyFacade;
    private RouterMetrics routerMetrics;
    private final Clock clock = new MonotonicClock();

    @Override
    public void init(String userName) {
        super.init(userName);
        this.federationFacade = FederationStateStoreFacade.getInstance();
        this.rand = new Random(System.currentTimeMillis());
        Configuration conf = this.getConf();
        try {
            this.policyFacade = new RouterPolicyFacade(conf, this.federationFacade, this.federationFacade.getSubClusterResolver(), null);
        }
        catch (FederationPolicyInitializationException e) {
            LOG.error(e.getMessage());
        }
        this.numSubmitRetries = conf.getInt("yarn.router.submit.retry", 3);
        this.clientRMProxies = new ConcurrentHashMap<SubClusterId, ApplicationClientProtocol>();
        this.routerMetrics = RouterMetrics.getMetrics();
    }

    @Override
    public void setNextInterceptor(ClientRequestInterceptor next) {
        throw new YarnRuntimeException("setNextInterceptor is being called on FederationClientRequestInterceptor, which should be the last one in the chain. Check if the interceptor pipeline configuration is correct");
    }

    @VisibleForTesting
    protected ApplicationClientProtocol getClientRMProxyForSubCluster(SubClusterId subClusterId) throws YarnException {
        if (this.clientRMProxies.containsKey(subClusterId)) {
            return this.clientRMProxies.get(subClusterId);
        }
        ApplicationClientProtocol clientRMProxy = null;
        try {
            clientRMProxy = (ApplicationClientProtocol)FederationProxyProviderUtil.createRMProxy((Configuration)this.getConf(), ApplicationClientProtocol.class, (SubClusterId)subClusterId, (UserGroupInformation)this.user);
        }
        catch (Exception e) {
            RouterServerUtil.logAndThrowException("Unable to create the interface to reach the SubCluster " + subClusterId, e);
        }
        this.clientRMProxies.put(subClusterId, clientRMProxy);
        return clientRMProxy;
    }

    private SubClusterId getRandomActiveSubCluster(Map<SubClusterId, SubClusterInfo> activeSubclusters) throws YarnException {
        if (activeSubclusters == null || activeSubclusters.size() < 1) {
            RouterServerUtil.logAndThrowException("No active SubCluster available to submit the request.", null);
        }
        ArrayList<SubClusterId> list = new ArrayList<SubClusterId>(activeSubclusters.keySet());
        return (SubClusterId)list.get(this.rand.nextInt(list.size()));
    }

    public GetNewApplicationResponse getNewApplication(GetNewApplicationRequest request) throws YarnException, IOException {
        long startTime = this.clock.getTime();
        Map subClustersActive = this.federationFacade.getSubClusters(true);
        for (int i = 0; i < this.numSubmitRetries; ++i) {
            SubClusterId subClusterId = this.getRandomActiveSubCluster(subClustersActive);
            LOG.debug("getNewApplication try #" + i + " on SubCluster " + subClusterId);
            ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
            GetNewApplicationResponse response = null;
            try {
                response = clientRMProxy.getNewApplication(request);
            }
            catch (Exception e) {
                LOG.warn("Unable to create a new ApplicationId in SubCluster " + subClusterId.getId(), (Throwable)e);
            }
            if (response != null) {
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededAppsCreated(stopTime - startTime);
                return response;
            }
            subClustersActive.remove(subClusterId);
        }
        this.routerMetrics.incrAppsFailedCreated();
        String errMsg = "Fail to create a new application.";
        LOG.error(errMsg);
        throw new YarnException(errMsg);
    }

    public SubmitApplicationResponse submitApplication(SubmitApplicationRequest request) throws YarnException, IOException {
        long startTime = this.clock.getTime();
        if (request == null || request.getApplicationSubmissionContext() == null || request.getApplicationSubmissionContext().getApplicationId() == null) {
            this.routerMetrics.incrAppsFailedSubmitted();
            RouterServerUtil.logAndThrowException("Missing submitApplication request or applicationSubmissionContex information.", null);
        }
        ApplicationId applicationId = request.getApplicationSubmissionContext().getApplicationId();
        ArrayList<SubClusterId> blacklist = new ArrayList<SubClusterId>();
        for (int i = 0; i < this.numSubmitRetries; ++i) {
            String message;
            SubClusterId subClusterId = this.policyFacade.getHomeSubcluster(request.getApplicationSubmissionContext(), blacklist);
            LOG.info("submitApplication appId" + applicationId + " try #" + i + " on SubCluster " + subClusterId);
            ApplicationHomeSubCluster appHomeSubCluster = ApplicationHomeSubCluster.newInstance((ApplicationId)applicationId, (SubClusterId)subClusterId);
            if (i == 0) {
                try {
                    subClusterId = this.federationFacade.addApplicationHomeSubCluster(appHomeSubCluster);
                }
                catch (YarnException e) {
                    this.routerMetrics.incrAppsFailedSubmitted();
                    message = "Unable to insert the ApplicationId " + applicationId + " into the FederationStateStore";
                    RouterServerUtil.logAndThrowException(message, e);
                }
            } else {
                try {
                    this.federationFacade.updateApplicationHomeSubCluster(appHomeSubCluster);
                }
                catch (YarnException e) {
                    message = "Unable to update the ApplicationId " + applicationId + " into the FederationStateStore";
                    SubClusterId subClusterIdInStateStore = this.federationFacade.getApplicationHomeSubCluster(applicationId);
                    if (subClusterId == subClusterIdInStateStore) {
                        LOG.info("Application " + applicationId + " already submitted on SubCluster " + subClusterId);
                    }
                    this.routerMetrics.incrAppsFailedSubmitted();
                    RouterServerUtil.logAndThrowException(message, e);
                }
            }
            ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
            SubmitApplicationResponse response = null;
            try {
                response = clientRMProxy.submitApplication(request);
            }
            catch (Exception e) {
                LOG.warn("Unable to submit the application " + applicationId + "to SubCluster " + subClusterId.getId(), (Throwable)e);
            }
            if (response != null) {
                LOG.info("Application " + request.getApplicationSubmissionContext().getApplicationName() + " with appId " + applicationId + " submitted on " + subClusterId);
                long stopTime = this.clock.getTime();
                this.routerMetrics.succeededAppsSubmitted(stopTime - startTime);
                return response;
            }
            blacklist.add(subClusterId);
        }
        this.routerMetrics.incrAppsFailedSubmitted();
        String errMsg = "Application " + request.getApplicationSubmissionContext().getApplicationName() + " with appId " + applicationId + " failed to be submitted.";
        LOG.error(errMsg);
        throw new YarnException(errMsg);
    }

    public KillApplicationResponse forceKillApplication(KillApplicationRequest request) throws YarnException, IOException {
        long startTime = this.clock.getTime();
        if (request == null || request.getApplicationId() == null) {
            this.routerMetrics.incrAppsFailedKilled();
            RouterServerUtil.logAndThrowException("Missing forceKillApplication request or ApplicationId.", null);
        }
        ApplicationId applicationId = request.getApplicationId();
        SubClusterId subClusterId = null;
        try {
            subClusterId = this.federationFacade.getApplicationHomeSubCluster(request.getApplicationId());
        }
        catch (YarnException e) {
            this.routerMetrics.incrAppsFailedKilled();
            RouterServerUtil.logAndThrowException("Application " + applicationId + " does not exist in FederationStateStore", e);
        }
        ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
        KillApplicationResponse response = null;
        try {
            LOG.info("forceKillApplication " + applicationId + " on SubCluster " + subClusterId);
            response = clientRMProxy.forceKillApplication(request);
        }
        catch (Exception e) {
            this.routerMetrics.incrAppsFailedKilled();
            LOG.error("Unable to kill the application report for " + request.getApplicationId() + "to SubCluster " + subClusterId.getId(), (Throwable)e);
            throw e;
        }
        if (response == null) {
            LOG.error("No response when attempting to kill the application " + applicationId + " to SubCluster " + subClusterId.getId());
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededAppsKilled(stopTime - startTime);
        return response;
    }

    public GetApplicationReportResponse getApplicationReport(GetApplicationReportRequest request) throws YarnException, IOException {
        long startTime = this.clock.getTime();
        if (request == null || request.getApplicationId() == null) {
            this.routerMetrics.incrAppsFailedRetrieved();
            RouterServerUtil.logAndThrowException("Missing getApplicationReport request or applicationId information.", null);
        }
        SubClusterId subClusterId = null;
        try {
            subClusterId = this.federationFacade.getApplicationHomeSubCluster(request.getApplicationId());
        }
        catch (YarnException e) {
            this.routerMetrics.incrAppsFailedRetrieved();
            RouterServerUtil.logAndThrowException("Application " + request.getApplicationId() + " does not exist in FederationStateStore", e);
        }
        ApplicationClientProtocol clientRMProxy = this.getClientRMProxyForSubCluster(subClusterId);
        GetApplicationReportResponse response = null;
        try {
            response = clientRMProxy.getApplicationReport(request);
        }
        catch (Exception e) {
            this.routerMetrics.incrAppsFailedRetrieved();
            LOG.error("Unable to get the application report for " + request.getApplicationId() + "to SubCluster " + subClusterId.getId(), (Throwable)e);
            throw e;
        }
        if (response == null) {
            LOG.error("No response when attempting to retrieve the report of the application " + request.getApplicationId() + " to SubCluster " + subClusterId.getId());
        }
        long stopTime = this.clock.getTime();
        this.routerMetrics.succeededAppsRetrieved(stopTime - startTime);
        return response;
    }

    public GetApplicationsResponse getApplications(GetApplicationsRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public GetClusterMetricsResponse getClusterMetrics(GetClusterMetricsRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public GetClusterNodesResponse getClusterNodes(GetClusterNodesRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public GetQueueInfoResponse getQueueInfo(GetQueueInfoRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public GetQueueUserAclsInfoResponse getQueueUserAcls(GetQueueUserAclsInfoRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public MoveApplicationAcrossQueuesResponse moveApplicationAcrossQueues(MoveApplicationAcrossQueuesRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public GetNewReservationResponse getNewReservation(GetNewReservationRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public ReservationSubmissionResponse submitReservation(ReservationSubmissionRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public ReservationListResponse listReservations(ReservationListRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public ReservationUpdateResponse updateReservation(ReservationUpdateRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public ReservationDeleteResponse deleteReservation(ReservationDeleteRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public GetNodesToLabelsResponse getNodeToLabels(GetNodesToLabelsRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public GetLabelsToNodesResponse getLabelsToNodes(GetLabelsToNodesRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public GetClusterNodeLabelsResponse getClusterNodeLabels(GetClusterNodeLabelsRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public GetApplicationAttemptReportResponse getApplicationAttemptReport(GetApplicationAttemptReportRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public GetApplicationAttemptsResponse getApplicationAttempts(GetApplicationAttemptsRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public GetContainerReportResponse getContainerReport(GetContainerReportRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public GetContainersResponse getContainers(GetContainersRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public GetDelegationTokenResponse getDelegationToken(GetDelegationTokenRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public RenewDelegationTokenResponse renewDelegationToken(RenewDelegationTokenRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public CancelDelegationTokenResponse cancelDelegationToken(CancelDelegationTokenRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public FailApplicationAttemptResponse failApplicationAttempt(FailApplicationAttemptRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public UpdateApplicationPriorityResponse updateApplicationPriority(UpdateApplicationPriorityRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public SignalContainerResponse signalToContainer(SignalContainerRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public UpdateApplicationTimeoutsResponse updateApplicationTimeouts(UpdateApplicationTimeoutsRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }

    public GetAllResourceTypeInfoResponse getResourceTypeInfo(GetAllResourceTypeInfoRequest request) throws YarnException, IOException {
        throw new NotImplementedException();
    }
}

