/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.tools.rumen.JobTraceReader;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.apache.hadoop.tools.rumen.LoggedTask;
import org.apache.hadoop.tools.rumen.LoggedTaskAttempt;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SLSUtils {
    public static final String DEFAULT_JOB_TYPE = "mapreduce";

    public static String[] getRackHostName(String hostname) {
        NodeBase node = new NodeBase(hostname);
        return new String[]{node.getNetworkLocation().substring(1), node.getName()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> parseNodesFromRumenTrace(String jobTrace) throws IOException {
        HashSet<String> nodeSet = new HashSet<String>();
        File fin = new File(jobTrace);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "file:///");
        try (JobTraceReader reader = new JobTraceReader(new Path(fin.getAbsolutePath()), conf);){
            LoggedJob job = null;
            while ((job = (LoggedJob)reader.getNext()) != null) {
                LoggedTaskAttempt taskAttempt;
                for (LoggedTask mapTask : job.getMapTasks()) {
                    if (mapTask.getAttempts().size() == 0) continue;
                    taskAttempt = (LoggedTaskAttempt)mapTask.getAttempts().get(mapTask.getAttempts().size() - 1);
                    nodeSet.add(taskAttempt.getHostName().getValue());
                }
                for (LoggedTask reduceTask : job.getReduceTasks()) {
                    if (reduceTask.getAttempts().size() == 0) continue;
                    taskAttempt = (LoggedTaskAttempt)reduceTask.getAttempts().get(reduceTask.getAttempts().size() - 1);
                    nodeSet.add(taskAttempt.getHostName().getValue());
                }
            }
        }
        return nodeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> parseNodesFromSLSTrace(String jobTrace) throws IOException {
        HashSet<String> nodeSet = new HashSet<String>();
        JsonFactory jsonF = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper();
        try (InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(jobTrace), "UTF-8");){
            MappingIterator i = mapper.readValues(jsonF.createParser((Reader)input), Map.class);
            while (i.hasNext()) {
                SLSUtils.addNodes(nodeSet, (Map)i.next());
            }
        }
        return nodeSet;
    }

    private static void addNodes(Set<String> nodeSet, Map jsonEntry) {
        if (jsonEntry.containsKey("num.nodes")) {
            int numNodes = Integer.parseInt(jsonEntry.get("num.nodes").toString());
            int numRacks = 1;
            if (jsonEntry.containsKey("num.racks")) {
                numRacks = Integer.parseInt(jsonEntry.get("num.racks").toString());
            }
            nodeSet.addAll(SLSUtils.generateNodes(numNodes, numRacks));
        }
        if (jsonEntry.containsKey("job.tasks")) {
            List tasks = (List)jsonEntry.get("job.tasks");
            for (Object o : tasks) {
                Map jsonTask = (Map)o;
                String hostname = (String)jsonTask.get("container.host");
                if (hostname == null) continue;
                nodeSet.add(hostname);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> parseNodesFromNodeFile(String nodeFile) throws IOException {
        HashSet<String> nodeSet = new HashSet<String>();
        JsonFactory jsonF = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper();
        try (InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(nodeFile), "UTF-8");){
            MappingIterator i = mapper.readValues(jsonF.createParser((Reader)input), Map.class);
            while (i.hasNext()) {
                Map jsonE = (Map)i.next();
                String rack = "/" + jsonE.get("rack");
                List tasks = (List)jsonE.get("nodes");
                for (Object o : tasks) {
                    Map jsonNode = (Map)o;
                    nodeSet.add(rack + "/" + jsonNode.get("node"));
                }
            }
        }
        return nodeSet;
    }

    public static Set<? extends String> generateNodes(int numNodes, int numRacks) {
        HashSet<String> nodeSet = new HashSet<String>();
        if (numRacks < 1) {
            numRacks = 1;
        }
        if (numRacks > numNodes) {
            numRacks = numNodes;
        }
        for (int i = 0; i < numNodes; ++i) {
            nodeSet.add("/rack" + i % numRacks + "/node" + i);
        }
        return nodeSet;
    }
}

