/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.solver.impl;

import java.util.ArrayList;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.api.records.ReservationRequests;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;

public abstract class BaseSolver {
    private static final Random RAND = new Random();

    public final ReservationSubmissionRequest toRecurringRDL(Resource containerSpec, RLESparseResourceAllocation containerRequests, Configuration config) {
        int timeInterval = config.getInt("resourceestimator.timeInterval", 5);
        long pipelineSubmissionTime = containerRequests.getEarliestStartTime();
        long pipelineFinishTime = containerRequests.getLatestNonNullTime();
        long containerMemAlloc = containerSpec.getMemorySize();
        long jobLen = (pipelineFinishTime - pipelineSubmissionTime) / (long)timeInterval;
        ArrayList<ReservationRequest> reservationRequestList = new ArrayList<ReservationRequest>();
        int i = 0;
        while ((long)i < jobLen) {
            ReservationRequest reservationRequest = ReservationRequest.newInstance((Resource)containerSpec, (int)((int)(containerRequests.getCapacityAtTime((long)(i * timeInterval)).getMemorySize() / containerMemAlloc)), (int)1, (long)timeInterval);
            reservationRequestList.add(reservationRequest);
            ++i;
        }
        ReservationRequests reservationRequests = ReservationRequests.newInstance(reservationRequestList, (ReservationRequestInterpreter)ReservationRequestInterpreter.R_ALL);
        ReservationDefinition reservationDefinition = ReservationDefinition.newInstance((long)pipelineSubmissionTime, (long)pipelineFinishTime, (ReservationRequests)reservationRequests, (String)"LpSolver#toRecurringRDL");
        ReservationId reservationId = ReservationId.newInstance((long)RAND.nextLong(), (long)RAND.nextLong());
        ReservationSubmissionRequest reservationSubmissionRequest = ReservationSubmissionRequest.newInstance((ReservationDefinition)reservationDefinition, (String)"resourceestimator", (ReservationId)reservationId);
        return reservationSubmissionRequest;
    }
}

