/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSequenceFileSerialization {
    private Configuration conf;
    private FileSystem fs;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.set("io.serializations", "org.apache.hadoop.io.serializer.JavaSerialization");
        this.fs = FileSystem.getLocal((Configuration)this.conf);
    }

    @After
    public void tearDown() throws Exception {
        this.fs.close();
    }

    @Test
    public void testJavaSerialization() throws Exception {
        Path file = new Path(GenericTestUtils.getTempPath("testseqser.seq"));
        this.fs.delete(file, true);
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)this.fs, (Configuration)this.conf, (Path)file, Long.class, String.class);
        writer.append((Object)1L, (Object)"one");
        writer.append((Object)2L, (Object)"two");
        writer.close();
        SequenceFile.Reader reader = new SequenceFile.Reader(this.fs, file, this.conf);
        Assert.assertEquals((Object)1L, (Object)reader.next((Object)null));
        Assert.assertEquals((Object)"one", (Object)reader.getCurrentValue((Object)null));
        Assert.assertEquals((Object)2L, (Object)reader.next((Object)null));
        Assert.assertEquals((Object)"two", (Object)reader.getCurrentValue((Object)null));
        Assert.assertNull((Object)reader.next((Object)null));
        reader.close();
    }
}

