/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.DU;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.test.GenericTestUtils;

public class TestDU
extends TestCase {
    private static final File DU_DIR = GenericTestUtils.getTestDir("dutmp");

    public void setUp() {
        FileUtil.fullyDelete((File)DU_DIR);
        TestDU.assertTrue((boolean)DU_DIR.mkdirs());
    }

    public void tearDown() throws IOException {
        FileUtil.fullyDelete((File)DU_DIR);
    }

    private void createFile(File newFile, int size) throws IOException {
        Random random = new Random();
        byte[] data = new byte[size];
        random.nextBytes(data);
        newFile.createNewFile();
        RandomAccessFile file = new RandomAccessFile(newFile, "rws");
        file.write(data);
        file.getFD().sync();
        file.close();
    }

    public void testDU() throws IOException, InterruptedException {
        int writtenSize = 32768;
        int slack = 4096;
        File file = new File(DU_DIR, "data");
        this.createFile(file, 32768);
        Thread.sleep(5000L);
        DU du = new DU(file, 10000L, 0L, -1L);
        du.init();
        long duSize = du.getUsed();
        du.close();
        TestDU.assertTrue((String)"Invalid on-disk size", (duSize >= 32768L && 32768L <= duSize + 4096L ? 1 : 0) != 0);
        du = new DU(file, 0L, 1L, -1L);
        du.init();
        duSize = du.getUsed();
        du.close();
        TestDU.assertTrue((String)"Invalid on-disk size", (duSize >= 32768L && 32768L <= duSize + 4096L ? 1 : 0) != 0);
        du = new DU(file, 10000L, 0L, -1L);
        du.init();
        duSize = du.getUsed();
        TestDU.assertTrue((String)"Invalid on-disk size", (duSize >= 32768L && 32768L <= duSize + 4096L ? 1 : 0) != 0);
    }

    public void testDUGetUsedWillNotReturnNegative() throws IOException {
        File file = new File(DU_DIR, "data");
        TestDU.assertTrue((boolean)file.createNewFile());
        Configuration conf = new Configuration();
        conf.setLong("fs.du.interval", 10000L);
        DU du = new DU(file, 10000L, 0L, -1L);
        du.incDfsUsed(-9223372036854775807L);
        long duSize = du.getUsed();
        TestDU.assertTrue((String)String.valueOf(duSize), (duSize >= 0L ? 1 : 0) != 0);
    }

    public void testDUSetInitialValue() throws IOException {
        File file = new File(DU_DIR, "dataX");
        this.createFile(file, 8192);
        DU du = new DU(file, 3000L, 0L, 1024L);
        du.init();
        TestDU.assertTrue((String)"Initial usage setting not honored", (du.getUsed() == 1024L ? 1 : 0) != 0);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        TestDU.assertTrue((String)"Usage didn't get updated", (du.getUsed() == 8192L ? 1 : 0) != 0);
    }
}

