/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.google.common.base.Supplier;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.CleanupQueue;
import org.apache.hadoop.mapred.Clock;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.SortValidator;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;

public class UtilsForTests {
    static final Log LOG = LogFactory.getLog(UtilsForTests.class);
    static final long KB = 1024L;
    static final long MB = 0x100000L;
    static final long GB = 0x40000000L;
    static final long TB = 0x10000000000L;
    static final long PB = 0x4000000000000L;
    static final Object waitLock = new Object();
    static DecimalFormat dfm = new DecimalFormat("####.000");
    static DecimalFormat ifm = new DecimalFormat("###,###,###,###,###");
    static final String regexpSpecials = "[]()?*+|.!^-\\~@";
    static char[] space = new char[300];

    public static String dfmt(double d) {
        return dfm.format(d);
    }

    public static String ifmt(double d) {
        return ifm.format(d);
    }

    public static String formatBytes(long numBytes) {
        StringBuffer buf = new StringBuffer();
        boolean bDetails = true;
        double num = numBytes;
        if (numBytes < 1024L) {
            buf.append(numBytes + " B");
            bDetails = false;
        } else if (numBytes < 0x100000L) {
            buf.append(UtilsForTests.dfmt(num / 1024.0) + " KB");
        } else if (numBytes < 0x40000000L) {
            buf.append(UtilsForTests.dfmt(num / 1048576.0) + " MB");
        } else if (numBytes < 0x10000000000L) {
            buf.append(UtilsForTests.dfmt(num / 1.073741824E9) + " GB");
        } else if (numBytes < 0x4000000000000L) {
            buf.append(UtilsForTests.dfmt(num / 1.099511627776E12) + " TB");
        } else {
            buf.append(UtilsForTests.dfmt(num / 1.125899906842624E15) + " PB");
        }
        if (bDetails) {
            buf.append(" (" + UtilsForTests.ifmt(numBytes) + " bytes)");
        }
        return buf.toString();
    }

    public static String formatBytes2(long numBytes) {
        StringBuffer buf = new StringBuffer();
        long u = 0L;
        if (numBytes >= 0x10000000000L) {
            u = numBytes / 0x10000000000L;
            numBytes -= u * 0x10000000000L;
            buf.append(u + " TB ");
        }
        if (numBytes >= 0x40000000L) {
            u = numBytes / 0x40000000L;
            numBytes -= u * 0x40000000L;
            buf.append(u + " GB ");
        }
        if (numBytes >= 0x100000L) {
            u = numBytes / 0x100000L;
            numBytes -= u * 0x100000L;
            buf.append(u + " MB ");
        }
        if (numBytes >= 1024L) {
            u = numBytes / 1024L;
            numBytes -= u * 1024L;
            buf.append(u + " KB ");
        }
        buf.append(u + " B");
        return buf.toString();
    }

    public static String regexpEscape(String plain) {
        StringBuffer buf = new StringBuffer();
        char[] ch = plain.toCharArray();
        int csup = ch.length;
        for (int c = 0; c < csup; ++c) {
            if (regexpSpecials.indexOf(ch[c]) != -1) {
                buf.append("\\");
            }
            buf.append(ch[c]);
        }
        return buf.toString();
    }

    public static String createConfigValue(int msgSize) {
        StringBuilder sb = new StringBuilder(msgSize);
        for (int i = 0; i < msgSize; ++i) {
            sb.append('a');
        }
        return sb.toString();
    }

    public static String safeGetCanonicalPath(File f) {
        try {
            String s = f.getCanonicalPath();
            return s == null ? f.toString() : s;
        }
        catch (IOException io) {
            return f.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String slurp(File f) throws IOException {
        int len = (int)f.length();
        byte[] buf = new byte[len];
        String contents = null;
        try (FileInputStream in = new FileInputStream(f);){
            in.read(buf, 0, len);
            contents = new String(buf, "UTF-8");
        }
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String slurpHadoop(Path p, FileSystem fs) throws IOException {
        int len = (int)fs.getFileStatus(p).getLen();
        byte[] buf = new byte[len];
        String contents = null;
        try (FSDataInputStream in = fs.open(p);){
            in.read(buf, 0, len);
            contents = new String(buf, "UTF-8");
        }
        return contents;
    }

    public static String rjustify(String s, int width) {
        if (s == null) {
            s = "null";
        }
        if (width > s.length()) {
            s = UtilsForTests.getSpace(width - s.length()) + s;
        }
        return s;
    }

    public static String ljustify(String s, int width) {
        if (s == null) {
            s = "null";
        }
        if (width > s.length()) {
            s = s + UtilsForTests.getSpace(width - s.length());
        }
        return s;
    }

    public static String getSpace(int len) {
        if (len > space.length) {
            space = new char[Math.max(len, 2 * space.length)];
            Arrays.fill(space, ' ');
        }
        return new String(space, 0, len);
    }

    static JobStatus getJobStatus(JobClient jc, JobID id) throws IOException {
        JobStatus[] statuses;
        for (JobStatus jobStatus : statuses = jc.getAllJobs()) {
            if (!jobStatus.getJobID().equals((Object)id)) continue;
            return jobStatus;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitFor(long duration) {
        try {
            Object object = waitLock;
            synchronized (object) {
                waitLock.wait(duration);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static void waitForJobTracker(JobClient jobClient) {
        while (true) {
            try {
                ClusterStatus status = jobClient.getClusterStatus();
                while (status.getJobTrackerStatus() != Cluster.JobTrackerStatus.RUNNING) {
                    UtilsForTests.waitFor(100L);
                    status = jobClient.getClusterStatus();
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    static void waitTillDone(JobClient jobClient) throws IOException {
        while (true) {
            boolean shouldWait = false;
            for (JobStatus jobStatuses : jobClient.getAllJobs()) {
                if (jobStatuses.getRunState() == JobStatus.SUCCEEDED || jobStatuses.getRunState() == JobStatus.FAILED || jobStatuses.getRunState() == JobStatus.KILLED) continue;
                shouldWait = true;
                break;
            }
            if (!shouldWait) break;
            UtilsForTests.waitFor(100L);
        }
    }

    static void configureWaitingJobConf(JobConf jobConf, Path inDir, Path outputPath, int numMaps, int numRed, String jobName, String mapSignalFilename, String redSignalFilename) throws IOException {
        jobConf.setJobName(jobName);
        jobConf.setInputFormat(SortValidator.RecordStatsChecker.NonSplitableSequenceFileInputFormat.class);
        jobConf.setOutputFormat(SequenceFileOutputFormat.class);
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)outputPath);
        jobConf.setMapperClass(HalfWaitingMapper.class);
        jobConf.setReducerClass(IdentityReducer.class);
        jobConf.setOutputKeyClass(BytesWritable.class);
        jobConf.setOutputValueClass(BytesWritable.class);
        jobConf.setInputFormat(RandomInputFormat.class);
        jobConf.setNumMapTasks(numMaps);
        jobConf.setNumReduceTasks(numRed);
        jobConf.setJar("build/test/mapred/testjar/testjob.jar");
        jobConf.set(UtilsForTests.getTaskSignalParameter(true), mapSignalFilename);
        jobConf.set(UtilsForTests.getTaskSignalParameter(false), redSignalFilename);
    }

    static String getTaskSignalParameter(boolean isMap) {
        return isMap ? "test.mapred.map.waiting.target" : "test.mapred.reduce.waiting.target";
    }

    static void signalTasks(MiniDFSCluster dfs, FileSystem fileSys, String mapSignalFile, String reduceSignalFile, int replication) throws IOException, TimeoutException {
        try {
            UtilsForTests.writeFile(dfs.getNameNode(), fileSys.getConf(), new Path(mapSignalFile), (short)replication);
            UtilsForTests.writeFile(dfs.getNameNode(), fileSys.getConf(), new Path(reduceSignalFile), (short)replication);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static void signalTasks(MiniDFSCluster dfs, FileSystem fileSys, boolean isMap, String mapSignalFile, String reduceSignalFile) throws IOException, TimeoutException {
        try {
            UtilsForTests.writeFile(dfs.getNameNode(), fileSys.getConf(), isMap ? new Path(mapSignalFile) : new Path(reduceSignalFile), (short)1);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static String getSignalFile(Path dir) {
        return new Path(dir, "signal").toString();
    }

    static String getMapSignalFile(Path dir) {
        return new Path(dir, "map-signal").toString();
    }

    static String getReduceSignalFile(Path dir) {
        return new Path(dir, "reduce-signal").toString();
    }

    static void writeFile(NameNode namenode, Configuration conf, Path name, short replication) throws IOException, TimeoutException, InterruptedException {
        FileSystem fileSys = FileSystem.get((Configuration)conf);
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fileSys, (Configuration)conf, (Path)name, BytesWritable.class, BytesWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
        writer.append((Writable)new BytesWritable(), (Writable)new BytesWritable());
        writer.close();
        fileSys.setReplication(name, replication);
        DFSTestUtil.waitReplication((FileSystem)fileSys, (Path)name, (short)replication);
    }

    static RunningJob runJob(JobConf conf, Path inDir, Path outDir) throws IOException {
        return UtilsForTests.runJob(conf, inDir, outDir, conf.getNumMapTasks(), conf.getNumReduceTasks());
    }

    static RunningJob runJob(JobConf conf, Path inDir, Path outDir, int numMaps, int numReds) throws IOException {
        String input = "The quick brown fox\nhas many silly\nred fox sox\n";
        return UtilsForTests.runJob(conf, inDir, outDir, numMaps, numReds, input);
    }

    static RunningJob runJob(JobConf conf, Path inDir, Path outDir, int numMaps, int numReds, String input) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (fs.exists(outDir)) {
            fs.delete(outDir, true);
        }
        if (!fs.exists(inDir)) {
            fs.mkdirs(inDir);
        }
        for (int i = 0; i < numMaps; ++i) {
            FSDataOutputStream file = fs.create(new Path(inDir, "part-" + i));
            file.writeBytes(input);
            file.close();
        }
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.setNumMapTasks(numMaps);
        conf.setNumReduceTasks(numReds);
        JobClient jobClient = new JobClient(conf);
        RunningJob job = jobClient.submitJob(conf);
        return job;
    }

    public static void waitForAppFinished(RunningJob job, MiniMRYarnCluster cluster) throws IOException {
        ApplicationId appId = ApplicationId.newInstance((long)Long.parseLong(job.getID().getJtIdentifier()), (int)job.getID().getId());
        ConcurrentMap rmApps = cluster.getResourceManager().getRMContext().getRMApps();
        if (!rmApps.containsKey(appId)) {
            throw new IOException("Job not found");
        }
        final RMApp rmApp = (RMApp)rmApps.get(appId);
        try {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    return RMAppImpl.isAppInFinalState((RMApp)rmApp);
                }
            }, (int)1000, (int)180000);
        }
        catch (InterruptedException | TimeoutException e1) {
            throw new IOException("Yarn application with " + appId + " didn't finish " + "did not reach finale State", e1);
        }
    }

    public static RunningJob runJobSucceed(JobConf conf, Path inDir, Path outDir) throws IOException {
        conf.setJobName("test-job-succeed");
        conf.setMapperClass(IdentityMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        RunningJob job = UtilsForTests.runJob(conf, inDir, outDir);
        long sleepCount = 0L;
        while (!job.isComplete()) {
            try {
                if (sleepCount > 300L) {
                    throw new IOException("Job didn't finish in 30 seconds");
                }
                Thread.sleep(100L);
                ++sleepCount;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return job;
    }

    public static RunningJob runJobFail(JobConf conf, Path inDir, Path outDir) throws IOException {
        conf.setJobName("test-job-fail");
        conf.setMapperClass(FailMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        conf.setMaxMapAttempts(1);
        RunningJob job = UtilsForTests.runJob(conf, inDir, outDir);
        long sleepCount = 0L;
        while (!job.isComplete()) {
            try {
                if (sleepCount > 300L) {
                    throw new IOException("Job didn't finish in 30 seconds");
                }
                Thread.sleep(100L);
                ++sleepCount;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return job;
    }

    public static RunningJob runJobKill(JobConf conf, Path inDir, Path outDir) throws IOException {
        conf.setJobName("test-job-kill");
        conf.setMapperClass(KillMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        RunningJob job = UtilsForTests.runJob(conf, inDir, outDir);
        long sleepCount = 0L;
        while (job.getJobState() != JobStatus.RUNNING) {
            try {
                if (sleepCount > 300L) {
                    throw new IOException("Job didn't finish in 30 seconds");
                }
                Thread.sleep(100L);
                ++sleepCount;
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        job.killJob();
        sleepCount = 0L;
        while (job.cleanupProgress() == 0.0f) {
            try {
                if (sleepCount > 2000L) {
                    throw new IOException("Job cleanup didn't start in 20 seconds");
                }
                Thread.sleep(10L);
                ++sleepCount;
            }
            catch (InterruptedException ie) {
                break;
            }
        }
        return job;
    }

    static void setUpConfigFile(Properties confProps, File configFile) throws IOException {
        Configuration config = new Configuration(false);
        FileOutputStream fos = new FileOutputStream(configFile);
        Enumeration<?> e = confProps.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            config.set(key, confProps.getProperty(key));
        }
        config.writeXml((OutputStream)fos);
        fos.close();
    }

    public static DataOutputStream createTmpFileDFS(FileSystem dfs, Path URIPATH, FsPermission permission, String input) throws Exception {
        FSDataOutputStream file = FileSystem.create((FileSystem)dfs, (Path)URIPATH, (FsPermission)permission);
        file.writeBytes(input);
        file.close();
        return file;
    }

    public static String getFQDNofTT(String taskTrackerLong) throws Exception {
        String[] firstSplit = taskTrackerLong.split("_");
        String tmpOutput = firstSplit[1];
        String[] secondSplit = tmpOutput.split(":");
        String tmpTaskTracker = secondSplit[0];
        return tmpTaskTracker;
    }

    static {
        Arrays.fill(space, ' ');
    }

    static class KillMapper
    extends MapReduceBase
    implements Mapper<WritableComparable, Writable, WritableComparable, Writable> {
        KillMapper() {
        }

        public void map(WritableComparable key, Writable value, OutputCollector<WritableComparable, Writable> out, Reporter reporter) throws IOException {
            try {
                Thread.sleep(1000000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static class FailMapper
    extends MapReduceBase
    implements Mapper<WritableComparable, Writable, WritableComparable, Writable> {
        FailMapper() {
        }

        public void map(WritableComparable key, Writable value, OutputCollector<WritableComparable, Writable> out, Reporter reporter) throws IOException {
            System.err.println("failing map");
            throw new RuntimeException("failing map");
        }
    }

    static class FakeClock
    extends Clock {
        long time = 0L;

        FakeClock() {
        }

        public void advance(long millis) {
            this.time += millis;
        }

        long getTime() {
            return this.time;
        }
    }

    public static class InlineCleanupQueue
    extends CleanupQueue {
        List<String> stalePaths = new ArrayList<String>();

        public void addToQueue(CleanupQueue.PathDeletionContext ... contexts) {
            for (CleanupQueue.PathDeletionContext context : contexts) {
                try {
                    if (InlineCleanupQueue.deletePath((CleanupQueue.PathDeletionContext)context)) continue;
                    LOG.warn((Object)("Stale path " + context.fullPath));
                    this.stalePaths.add(context.fullPath);
                }
                catch (IOException e) {
                    LOG.warn((Object)("Caught exception while deleting path " + context.fullPath));
                    LOG.info((Object)StringUtils.stringifyException((Throwable)e));
                    this.stalePaths.add(context.fullPath);
                }
            }
        }
    }

    public static class RandomInputFormat
    implements InputFormat<Text, Text> {
        public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
            InputSplit[] result = new InputSplit[numSplits];
            Path outDir = FileOutputFormat.getOutputPath((JobConf)job);
            for (int i = 0; i < result.length; ++i) {
                result[i] = new FileSplit(new Path(outDir, "dummy-split-" + i), 0L, 1L, (String[])null);
            }
            return result;
        }

        public RecordReader<Text, Text> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            return new RandomRecordReader(((FileSplit)split).getPath());
        }

        static class RandomRecordReader
        implements RecordReader<Text, Text> {
            Path name;

            public RandomRecordReader(Path p) {
                this.name = p;
            }

            public boolean next(Text key, Text value) {
                if (this.name != null) {
                    key.set(this.name.getName());
                    this.name = null;
                    return true;
                }
                return false;
            }

            public Text createKey() {
                return new Text();
            }

            public Text createValue() {
                return new Text();
            }

            public long getPos() {
                return 0L;
            }

            public void close() {
            }

            public float getProgress() {
                return 0.0f;
            }
        }
    }

    static class WaitingReducer
    extends MapReduceBase
    implements Reducer<WritableComparable, Writable, WritableComparable, Writable> {
        FileSystem fs = null;
        Path signal;

        WaitingReducer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reduce(WritableComparable key, Iterator<Writable> val, OutputCollector<WritableComparable, Writable> output, Reporter reporter) throws IOException {
            if (this.fs != null) {
                while (!this.fs.exists(this.signal)) {
                    try {
                        reporter.progress();
                        WaitingReducer waitingReducer = this;
                        synchronized (waitingReducer) {
                            ((Object)((Object)this)).wait(1000L);
                        }
                    }
                    catch (InterruptedException ie) {
                        System.out.println("Interrupted while the map was waiting for the signal.");
                        break;
                    }
                }
            } else {
                throw new IOException("Could not get the DFS!!");
            }
        }

        public void configure(JobConf conf) {
            try {
                this.fs = FileSystem.get((Configuration)conf);
                this.signal = new Path(conf.get(UtilsForTests.getTaskSignalParameter(false)));
            }
            catch (IOException ioe) {
                System.out.println("Got an exception while obtaining the filesystem");
            }
        }
    }

    static class HalfWaitingMapper
    extends WaitingMapper {
        HalfWaitingMapper() {
        }

        @Override
        public boolean shouldWait(int id) {
            return id >= this.totalMaps / 2;
        }
    }

    static class WaitingMapper
    extends MapReduceBase
    implements Mapper<WritableComparable, Writable, WritableComparable, Writable> {
        FileSystem fs = null;
        Path signal;
        int id = 0;
        int totalMaps = 0;

        WaitingMapper() {
        }

        public boolean shouldWait(int id) {
            return true;
        }

        public Path getSignalFile(int id) {
            return this.signal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void map(WritableComparable key, Writable val, OutputCollector<WritableComparable, Writable> output, Reporter reporter) throws IOException {
            if (this.shouldWait(this.id)) {
                if (this.fs != null) {
                    while (!this.fs.exists(this.getSignalFile(this.id))) {
                        try {
                            reporter.progress();
                            WaitingMapper waitingMapper = this;
                            synchronized (waitingMapper) {
                                ((Object)((Object)this)).wait(1000L);
                            }
                        }
                        catch (InterruptedException ie) {
                            System.out.println("Interrupted while the map was waiting for  the signal.");
                            break;
                        }
                    }
                } else {
                    throw new IOException("Could not get the DFS!!");
                }
            }
        }

        public void configure(JobConf conf) {
            try {
                String taskId = conf.get("mapreduce.task.attempt.id");
                this.id = Integer.parseInt(taskId.split("_")[4]);
                this.totalMaps = Integer.parseInt(conf.get("mapreduce.job.maps"));
                this.fs = FileSystem.get((Configuration)conf);
                this.signal = new Path(conf.get(UtilsForTests.getTaskSignalParameter(true)));
            }
            catch (IOException ioe) {
                System.out.println("Got an exception while obtaining the filesystem");
            }
        }
    }
}

