/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance.portfolio;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.finance.portfolio.FinancePortfolio;
import org.ojalgo.type.TypeUtils;

public final class SimpleAsset
extends FinancePortfolio {
    private final double myMeanReturn;
    private final double myVolatility;
    private final BigDecimal myWeight;

    public SimpleAsset(FinancePortfolio portfolio) {
        this(portfolio.getMeanReturn(), portfolio.getVolatility(), BigMath.ONE);
    }

    public SimpleAsset(FinancePortfolio portfolio, Number weight) {
        this(portfolio.getMeanReturn(), portfolio.getVolatility(), weight);
    }

    public SimpleAsset(Number weight) {
        this(PrimitiveMath.ZERO, PrimitiveMath.ZERO, weight);
    }

    public SimpleAsset(Number meanReturn, Number volatility) {
        this(meanReturn, volatility, BigMath.ONE);
    }

    public SimpleAsset(Number meanReturn, Number volatility, Number weight) {
        this.myMeanReturn = meanReturn != null ? meanReturn.doubleValue() : PrimitiveMath.ZERO;
        this.myVolatility = volatility != null ? volatility.doubleValue() : PrimitiveMath.ZERO;
        this.myWeight = TypeUtils.toBigDecimal(weight);
    }

    private SimpleAsset() {
        this(BigMath.ZERO, BigMath.ZERO, BigMath.ONE);
    }

    @Override
    public double getMeanReturn() {
        return this.myMeanReturn;
    }

    @Override
    public double getVolatility() {
        return this.myVolatility;
    }

    public BigDecimal getWeight() {
        return this.myWeight;
    }

    @Override
    public List<BigDecimal> getWeights() {
        return Collections.singletonList(this.myWeight);
    }

    @Override
    protected void reset() {
    }
}

