/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.jx;

import org.apache.flex.compiler.codegen.ISubEmitter;
import org.apache.flex.compiler.codegen.js.IJSEmitter;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSDocEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.flex.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.flex.compiler.internal.codegen.js.flexjs.JSFlexJSEmitter;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IAccessorNode;
import org.apache.flex.compiler.tree.as.IDefinitionNode;
import org.apache.flex.compiler.tree.as.IExpressionNode;
import org.apache.flex.compiler.tree.as.IFunctionNode;
import org.apache.flex.compiler.tree.as.IInterfaceNode;
import org.apache.flex.compiler.tree.as.ITypeNode;

public class InterfaceEmitter
extends JSSubEmitter
implements ISubEmitter<IInterfaceNode> {
    public InterfaceEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IInterfaceNode node) {
        IDefinitionNode[] members;
        JSFlexJSEmitter fjs = (JSFlexJSEmitter)this.getEmitter();
        ICompilerProject project = this.getWalker().getProject();
        fjs.getDocEmitter().emitInterfaceDoc(node, project);
        String qname = node.getQualifiedName();
        if (qname != null && !qname.equals("")) {
            this.write(this.getEmitter().formatQualifiedName(qname));
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.EQUAL);
            this.write(ASEmitterTokens.FUNCTION);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.write(ASEmitterTokens.SPACE);
            this.write(ASEmitterTokens.BLOCK_OPEN);
            this.writeNewline();
            this.write(ASEmitterTokens.BLOCK_CLOSE);
            this.write(ASEmitterTokens.SEMICOLON);
        }
        for (IDefinitionNode mnode : members = node.getAllMemberDefinitionNodes()) {
            boolean isAccessor;
            boolean bl = isAccessor = mnode.getNodeID() == ASTNodeID.GetterID || mnode.getNodeID() == ASTNodeID.SetterID;
            if (isAccessor && this.getModel().getInterfacePropertyMap().contains(qname)) continue;
            this.writeNewline();
            if (isAccessor) {
                IAccessorNode accessor = (IAccessorNode)mnode;
                String propType = accessor.getVariableType();
                IExpressionNode typeNode = accessor.getVariableTypeNode();
                ITypeDefinition typeDef = typeNode.resolveType(project);
                String packageName = typeDef.getPackageName();
                packageName = project.getActualPackageName(packageName);
                this.write(JSDocEmitterTokens.JSDOC_OPEN);
                this.write(ASEmitterTokens.SPACE);
                fjs.getDocEmitter().emitType(propType, packageName);
                this.write(ASEmitterTokens.SPACE);
                this.write(JSDocEmitterTokens.JSDOC_CLOSE);
            }
            this.write(this.getEmitter().formatQualifiedName(qname));
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.PROTOTYPE);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(mnode.getQualifiedName());
            if (isAccessor && !this.getModel().getInterfacePropertyMap().contains(qname)) {
                this.getModel().getInterfacePropertyMap().add(qname);
            } else {
                this.write(ASEmitterTokens.SPACE);
                this.writeToken(ASEmitterTokens.EQUAL);
                this.write(ASEmitterTokens.FUNCTION);
                fjs.emitParameters(((IFunctionNode)mnode).getParametersContainerNode());
                this.write(ASEmitterTokens.SPACE);
                this.write(ASEmitterTokens.BLOCK_OPEN);
                this.writeNewline();
                this.write(ASEmitterTokens.BLOCK_CLOSE);
            }
            this.write(ASEmitterTokens.SEMICOLON);
        }
        fjs.getPackageFooterEmitter().emitClassInfo((ITypeNode)node);
    }
}

