/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.projects;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.flex.compiler.internal.projects.ASProject;
import org.apache.flex.compiler.internal.projects.DefinitionPriority;
import org.apache.flex.compiler.internal.projects.SourcePathManager;
import org.apache.flex.compiler.problems.DuplicateSourceFileProblem;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.problems.UnsupportedSourceFileProblem;
import org.apache.flex.compiler.units.ICompilationUnit;
import org.apache.flex.utils.FilenameNormalization;

final class SourceListManager {
    private final ASProject project;
    private final SourcePathManager sourcePathManager;
    private Set<File> sources;
    private Collection<ICompilerProblem> problems;

    SourceListManager(ASProject project, SourcePathManager sourcePathManager) {
        this.project = project;
        this.sourcePathManager = sourcePathManager;
        this.sources = new LinkedHashSet<File>();
        this.problems = Collections.emptyList();
    }

    void setSourceList(File[] newSources) throws InterruptedException {
        this.setSourceList(newSources, false);
    }

    void setSourceList(File[] newSources, boolean overrideSourcePath) throws InterruptedException {
        if ((newSources = FilenameNormalization.normalize(newSources)).equals(this.sources)) {
            return;
        }
        ArrayList problems = new ArrayList();
        LinkedHashSet<File> newSourcesSet = new LinkedHashSet<File>();
        ArrayList<File> newSourcesToCreate = new ArrayList<File>();
        for (File file : newSources) {
            assert (!file.isDirectory());
            if (this.project.getSourceCompilationUnitFactory().canCreateCompilationUnit(file)) {
                if (!overrideSourcePath && this.sourcePathManager.isFileOnSourcePath(file)) continue;
                if (newSourcesSet.contains(file)) {
                    problems.add(new DuplicateSourceFileProblem(file));
                    continue;
                }
                newSourcesSet.add(file);
                if (this.sources.contains(file)) continue;
                newSourcesToCreate.add(file);
                continue;
            }
            problems.add(new UnsupportedSourceFileProblem(file));
        }
        HashSet<ICompilationUnit> unitsToRemove = new HashSet<ICompilationUnit>();
        for (File existingSource : this.sources) {
            if (newSourcesSet.contains(existingSource)) continue;
            unitsToRemove.addAll(this.project.getCompilationUnits(existingSource.getAbsolutePath()));
        }
        this.sources = newSourcesSet;
        List<ICompilationUnit> unitsToAdd = Collections.emptyList();
        if (!newSourcesToCreate.isEmpty()) {
            unitsToAdd = new ArrayList(newSourcesToCreate.size());
            for (File file : newSourcesToCreate) {
                ICompilationUnit unit = this.project.getSourceCompilationUnitFactory().createCompilationUnit(file, DefinitionPriority.BasePriority.SOURCE_LIST, 0, null, null);
                if (unit == null) continue;
                unitsToAdd.add(unit);
            }
        }
        List emptyList = Collections.emptyList();
        this.problems = problems.size() == 0 ? emptyList : problems;
        this.project.sourceListChange(unitsToRemove, unitsToAdd);
    }

    public boolean containsSource(File source) {
        assert (source.equals(FilenameNormalization.normalize(source)));
        return this.sources.contains(source);
    }

    public void addSource(File newSource) throws InterruptedException {
        this.addSource(newSource, false);
    }

    public void addSource(File newSource, boolean overrideSourcePath) throws InterruptedException {
        File[] newSources = this.sources.toArray(new File[this.sources.size() + 1]);
        newSources[this.sources.size()] = newSource;
        this.setSourceList(newSources, overrideSourcePath);
    }

    public void removeSource(File sourceToRemove) throws InterruptedException {
        if (this.sources.isEmpty()) {
            return;
        }
        if (!this.sources.contains(sourceToRemove = FilenameNormalization.normalize(sourceToRemove))) {
            return;
        }
        LinkedHashSet<File> newSources = new LinkedHashSet<File>(this.sources);
        newSources.remove(sourceToRemove);
        this.setSourceList(newSources.toArray(new File[newSources.size()]));
    }

    void collectProblems(Collection<ICompilerProblem> problems) {
        problems.addAll(this.problems);
    }

    public void collectionCompilationUnitsForRootSourceFile(File rootSourceFile, Collection<ICompilationUnit> units) {
        Collection<ICompilationUnit> compilationUnits = this.project.getCompilationUnits(rootSourceFile.getAbsolutePath());
        units.addAll(compilationUnits);
    }

    public boolean hasCompilationUnitsForRootSourceFile(File rootSourceFile) {
        Collection<ICompilationUnit> compilationUnits = this.project.getCompilationUnits(rootSourceFile.getAbsolutePath());
        return compilationUnits.size() > 0;
    }
}

