/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.primitives.Bytes;
import com.google.common.truth.AbstractArraySubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.ListSubject;
import java.util.Arrays;
import java.util.List;

public class PrimitiveByteArraySubject
extends AbstractArraySubject<PrimitiveByteArraySubject, byte[]> {
    PrimitiveByteArraySubject(FailureStrategy failureStrategy, byte[] o) {
        super(failureStrategy, o);
    }

    @Override
    protected String underlyingType() {
        return "byte";
    }

    @Override
    protected List<Byte> listRepresentation() {
        return Bytes.asList((byte[])((byte[])this.getSubject()));
    }

    @Override
    public void isEqualTo(Object expected) {
        byte[] actual = (byte[])this.getSubject();
        if (actual == expected) {
            return;
        }
        try {
            byte[] expectedArray = (byte[])expected;
            if (!Arrays.equals(actual, expectedArray)) {
                this.fail("is equal to", (Object)Arrays.toString(expectedArray));
            }
        }
        catch (ClassCastException e) {
            this.failWithBadType(expected);
        }
    }

    @Override
    public void isNotEqualTo(Object expected) {
        byte[] actual = (byte[])this.getSubject();
        try {
            byte[] expectedArray = (byte[])expected;
            if (actual == expected || Arrays.equals(actual, expectedArray)) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.getDisplaySubject(), Arrays.toString(expectedArray));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public ListSubject<?, Byte, List<Byte>> asList() {
        return ListSubject.create(this.failureStrategy, this.listRepresentation());
    }
}

